/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import com.google.common.collect.ImmutableSet;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.DistillationTowerMultiblock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DistillationTowerTileEntity
extends PoweredMultiblockTileEntity<DistillationTowerTileEntity, DistillationRecipe>
implements IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IBlockBounds {
    public static TileEntityType<DistillationTowerTileEntity> TYPE;
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final int INV_0 = 0;
    public static final int INV_1 = 1;
    public static final int INV_2 = 2;
    public static final int INV_3 = 3;
    public static final BlockPos Fluid_IN;
    public static final BlockPos Fluid_OUT;
    public static final BlockPos Item_OUT;
    public static final Set<BlockPos> Energy_IN;
    public static final Set<BlockPos> Redstone_IN;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public MultiFluidTank[] tanks = new MultiFluidTank[]{new MultiFluidTank(24000), new MultiFluidTank(24000)};
    private int cooldownTicks = 0;
    private boolean wasActive = false;
    public boolean enableStepping = false;
    public int step = 0;
    private CapabilityReference<IItemHandler> output_capref = CapabilityReference.forTileEntity((TileEntity)this, () -> {
        Direction outputdir = this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f();
        return new DirectionalBlockPos(this.getBlockPosForPos(Item_OUT).func_177972_a(outputdir), outputdir);
    }, (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private static CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES;

    public DistillationTowerTileEntity() {
        super((IETemplateMultiblock)DistillationTowerMultiblock.INSTANCE, 16000, true, null);
    }

    public TileEntityType<?> func_200662_C() {
        return TYPE;
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.cooldownTicks = nbt.func_74762_e("cooldownTicks");
        if (!descPacket) {
            this.inventory = this.readInventory(nbt.func_74775_l("inventory"));
        }
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_218657_a("tank0", (INBT)this.tanks[0].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank1", (INBT)this.tanks[1].writeToNBT(new CompoundNBT()));
        nbt.func_74768_a("cooldownTicks", this.cooldownTicks);
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)this.writeInventory(this.inventory));
        }
    }

    protected NonNullList<ItemStack> readInventory(CompoundNBT nbt) {
        NonNullList list = NonNullList.func_191196_a();
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)list);
        if (list.size() == 0) {
            list = this.inventory.size() == 4 ? this.inventory : NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        } else if (list.size() < 4) {
            while (list.size() < 4) {
                list.add((Object)ItemStack.field_190927_a);
            }
        }
        return list;
    }

    protected CompoundNBT writeInventory(NonNullList<ItemStack> list) {
        return ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), list);
    }

    public boolean step() {
        if (this.step > 0) {
            --this.step;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        ItemStack emptyContainer;
        PoweredMultiblockTileEntity.MultiblockProcessInMachine process;
        DistillationRecipe recipe;
        if (this.enableStepping && !this.step()) {
            return;
        }
        ApiUtils.checkForNeedlessTicking((TileEntity)this);
        if (this.field_145850_b.field_72995_K || this.isDummy() || this.isRSDisabled()) {
            return;
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
        boolean update = false;
        if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && this.tanks[0].getFluidAmount() > 0 && (recipe = DistillationRecipe.findRecipe(this.tanks[0].getFluid())) != null && this.tanks[0].getFluidAmount() >= recipe.getInputFluid().getAmount() && this.energyStorage.getEnergyStored() >= recipe.getTotalProcessEnergy() && this.addProcessToQueue((PoweredMultiblockTileEntity.MultiblockProcess)(process = new PoweredMultiblockTileEntity.MultiblockProcessInMachine((MultiblockRecipe)recipe, new int[0]).setInputTanks(new int[]{0})), true)) {
            this.addProcessToQueue((PoweredMultiblockTileEntity.MultiblockProcess)process, false);
            update = true;
        }
        super.func_73660_a();
        if (this.processQueue.size() > 0) {
            this.wasActive = true;
            this.cooldownTicks = 6;
        } else if (this.wasActive) {
            this.wasActive = false;
            update = true;
        }
        if (this.inventory.get(0) != ItemStack.field_190927_a && this.tanks[0].getFluidAmount() < this.tanks[0].getCapacity() && !(emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[0], (ItemStack)((ItemStack)this.inventory.get(0)), (ItemStack)((ItemStack)this.inventory.get(1)), null)).func_190926_b()) {
            if (!((ItemStack)this.inventory.get(1)).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)emptyContainer)) {
                ((ItemStack)this.inventory.get(1)).func_190917_f(emptyContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                this.inventory.set(1, (Object)emptyContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
            update = true;
        }
        if (this.tanks[1].getFluidAmount() > 0) {
            ItemStack filledContainer;
            if (this.inventory.get(2) != ItemStack.field_190927_a && !(filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tanks[1], (ItemStack)((ItemStack)this.inventory.get(2)), (ItemStack)((ItemStack)this.inventory.get(3)), null)).func_190926_b()) {
                if (((ItemStack)this.inventory.get(3)).func_190916_E() == 1 && !Utils.isFluidContainerFull((ItemStack)filledContainer)) {
                    this.inventory.set(3, (Object)filledContainer.func_77946_l());
                } else {
                    if (!((ItemStack)this.inventory.get(3)).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)filledContainer)) {
                        ((ItemStack)this.inventory.get(3)).func_190917_f(filledContainer.func_190916_E());
                    } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                        this.inventory.set(3, (Object)filledContainer.func_77946_l());
                    }
                    ((ItemStack)this.inventory.get(2)).func_190918_g(1);
                    if (((ItemStack)this.inventory.get(2)).func_190916_E() <= 0) {
                        this.inventory.set(2, (Object)ItemStack.field_190927_a);
                    }
                }
                update = true;
            }
            update |= ((Boolean)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.getBlockPosForPos(Fluid_OUT).func_177972_a(this.getFacing().func_176734_d()), (Direction)this.getFacing().func_176734_d()).map(output -> {
                boolean ret = false;
                if (this.tanks[1].fluids.size() > 0) {
                    ArrayList<FluidStack> toDrain = new ArrayList<FluidStack>();
                    for (FluidStack target : this.tanks[1].fluids) {
                        FluidStack outStack = Utils.copyFluidStackWithAmount((FluidStack)target, (int)Math.min(target.getAmount(), 100), (boolean)false);
                        int accepted = output.fill(outStack, IFluidHandler.FluidAction.SIMULATE);
                        if (accepted <= 0) continue;
                        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)outStack, (int)Math.min(outStack.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                        toDrain.add(new FluidStack(target.getFluid(), drained));
                        ret |= true;
                    }
                    toDrain.forEach(fluid -> this.tanks[1].drain(fluid, IFluidHandler.FluidAction.EXECUTE));
                }
                return ret;
            }).orElse((Object)false)).booleanValue();
        }
        if (update) {
            this.updateMasterBlock(null, true);
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates(int slot) {
        this.updateMasterBlock(null, true);
    }

    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)this.master();
    }

    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    protected DistillationRecipe getRecipeForId(ResourceLocation id) {
        return DistillationRecipe.recipes.get(id);
    }

    public Set<BlockPos> getEnergyPos() {
        return Energy_IN;
    }

    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        if (this.formed && this.isEnergyPos() && (facing == null || facing == Direction.UP)) {
            return IEEnums.IOSideConfig.INPUT;
        }
        return IEEnums.IOSideConfig.NONE;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    public DistillationRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return new int[]{1};
    }

    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<DistillationRecipe> process) {
        return true;
    }

    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.output_capref, (ItemStack)output, (boolean)false)).func_190926_b()) {
            Direction outputdir = this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f();
            Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)this.getBlockPosForPos(Item_OUT).func_177972_a(outputdir), (ItemStack)output, (Direction)outputdir);
        }
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<DistillationRecipe> process) {
    }

    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<DistillationRecipe> process) {
        return 1.0f;
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public boolean shouldRenderAsActive() {
        return this.cooldownTicks > 0 || super.shouldRenderAsActive();
    }

    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        DistillationTowerTileEntity master = (DistillationTowerTileEntity)this.master();
        if (master != null) {
            if (this.posInMultiblock.equals((Object)Fluid_IN) && (side == null || (this.getIsMirrored() ? side == this.getFacing().func_176735_f() : side == this.getFacing().func_176746_e()))) {
                return new IFluidTank[]{master.tanks[0]};
            }
            if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || side == this.getFacing().func_176734_d())) {
                return new IFluidTank[]{master.tanks[1]};
            }
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        if (this.posInMultiblock.equals((Object)Fluid_IN) && (this.getIsMirrored() ? side == null || side == this.getFacing().func_176735_f() : side == null || side == this.getFacing().func_176746_e())) {
            DistillationRecipe r1;
            DistillationTowerTileEntity master = (DistillationTowerTileEntity)this.master();
            if (master == null || master.tanks[0].getFluidAmount() >= master.tanks[0].getCapacity()) {
                return false;
            }
            FluidStack copy0 = Utils.copyFluidStackWithAmount((FluidStack)resource, (int)1000, (boolean)false);
            FluidStack copy1 = Utils.copyFluidStackWithAmount((FluidStack)master.tanks[0].getFluid(), (int)1000, (boolean)false);
            if (master.tanks[0].getFluid() == FluidStack.EMPTY) {
                DistillationRecipe r = DistillationRecipe.findRecipe(copy0);
                return r != null;
            }
            DistillationRecipe r0 = DistillationRecipe.findRecipe(copy0);
            return r0 == (r1 = DistillationRecipe.findRecipe(copy1));
        }
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, Direction side) {
        if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || side == this.getFacing().func_176734_d())) {
            DistillationTowerTileEntity master = (DistillationTowerTileEntity)this.master();
            return master != null && master.tanks[1].getFluidAmount() > 0;
        }
        return false;
    }

    public boolean isLadder() {
        return this.posInMultiblock.func_177956_o() > 0 && this.posInMultiblock.func_177958_n() == 2 && this.posInMultiblock.func_177952_p() == 0;
    }

    public VoxelShape getBlockBounds(ISelectionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        int bX = posInMultiblock.func_177958_n();
        int bY = posInMultiblock.func_177956_o();
        int bZ = posInMultiblock.func_177952_p();
        if (bY < 2 && bX == 0 && bZ == 3) {
            if (bY == 1) {
                return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0));
            }
            return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.125, 0.0, 0.75, 0.375, 1.0, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.375, 1.0, 0.25));
        }
        if (bY == 2 && bX == 3 && bZ == 2) {
            return Arrays.asList(new AxisAlignedBB(-0.0625, 0.375, 0.125, 0.0625, 1.125, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.5, 0.25, 0.75, 1.0, 0.75));
        }
        if (bY > 0 && bX == 1 && bZ == 3) {
            if (bY != 15) {
                ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                list.add(new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125));
                if (bY > 0 && bY % 4 == 0) {
                    list.add(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
                }
                return list;
            }
            return Arrays.asList(new AxisAlignedBB(0.1875, 0.0, -0.0625, 0.8125, 0.625, 0.8125));
        }
        if (bY > 0 && bX == 2 && bZ == 0) {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            list.add(new AxisAlignedBB(0.0625, bY == 1 ? 0.125 : 0.0, 0.875, 0.9375, 1.0, 1.0625));
            if (bY > 0 && bY % 4 == 0) {
                list.add(new AxisAlignedBB(0.0, 0.5, 0.875, 1.0, 1.0, 1.0625));
                list.add(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.0625));
            }
            return list;
        }
        if (bX > 0 && bX < 3 && bZ > 0 && bZ < 3) {
            if (bY > 0) {
                AxisAlignedBB bb = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
                if (bZ == 1) {
                    if (bX == 1) {
                        bb = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 1.0, 1.0);
                    }
                    if (bX == 2) {
                        bb = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 1.0, 1.0);
                    }
                } else if (bZ == 2) {
                    if (bX == 1) {
                        bb = new AxisAlignedBB(0.0625, 0.0, 0.0, 1.0, 1.0, 0.9375);
                    }
                    if (bX == 2) {
                        bb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.9375, 1.0, 0.9375);
                    }
                }
                return Arrays.asList(bb);
            }
            return Arrays.asList(new AxisAlignedBB(-0.125, 0.5, -0.125, 1.125, 1.125, 1.125), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (bY > 0 && bY % 4 == 0) {
            return Arrays.asList(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
        }
        if (bY == 0) {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            if (bX == 0 && bZ == 1 || bX == 1 && bZ == 3 || bX == 3 && bZ == 2 || bX == 3 && bZ == 3) {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
            } else {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
            }
            return list;
        }
        return Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    static {
        Fluid_IN = new BlockPos(3, 0, 3);
        Fluid_OUT = new BlockPos(1, 0, 3);
        Item_OUT = new BlockPos(0, 0, 1);
        Energy_IN = ImmutableSet.of((Object)new BlockPos(3, 1, 3));
        Redstone_IN = ImmutableSet.of((Object)new BlockPos(0, 1, 3));
        SHAPES = CachedShapesWithTransform.createForMultiblock(DistillationTowerTileEntity::getShape);
    }
}

