/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting;

import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import flaxbeard.immersivepetroleum.common.items.ProjectorItem;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ProjectorCraftingHandler
implements ICraftingRecipe {
    private final ResourceLocation id;

    public ProjectorCraftingHandler(ResourceLocation id) {
        this.id = id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)Serializers.PROJECTOR_SERIALIZER.get();
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return new Result(inv).canCraft;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return new Result(inv).output;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return new Result(inv).remaining;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    private class Result {
        private final boolean canCraft;
        private final NonNullList<ItemStack> remaining;
        private final ItemStack output;
        private ItemStack manual = ItemStack.field_190927_a;
        int manualStack = 0;

        public Result(CraftingInventory inv) {
            this.canCraft = this.isValid(inv);
            if (this.canCraft) {
                this.remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
                this.remaining.set(this.manualStack, (Object)this.manual.func_77946_l());
                String last = ItemNBTHelper.getString((ItemStack)this.manual, (String)"lastMultiblock");
                ItemStack op = new ItemStack((IItemProvider)IPContent.Items.projector, 1);
                ItemNBTHelper.putString((ItemStack)op, (String)"multiblock", (String)last);
                ProjectorItem.setFlipped(op, true);
                this.output = op;
            } else {
                this.remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
                this.output = ItemStack.field_190927_a;
            }
        }

        private boolean isValid(CraftingInventory inv) {
            boolean hasProjector = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() == IEItems.Tools.manual) {
                    if (this.manual.func_190926_b() && ItemNBTHelper.hasKey((ItemStack)stack, (String)"lastMultiblock")) {
                        this.manual = stack;
                        this.manualStack = i;
                        continue;
                    }
                    return false;
                }
                if (stack.func_77973_b() == IPContent.Items.projector) {
                    if (!hasProjector) {
                        hasProjector = true;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            return !this.manual.func_190926_b() && hasProjector;
        }
    }
}

