/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class RecipeReloadListener
implements IResourceManagerReloadListener {
    public void func_195410_a(IResourceManager resourceManager) {
        if (EffectiveSide.get().isServer()) {
            RecipeReloadListener.lists(ServerLifecycleHooks.getCurrentServer().func_199529_aN());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void recipesUpdated(RecipesUpdatedEvent event) {
        RecipeReloadListener.lists(event.getRecipeManager());
    }

    static void lists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.func_199510_b();
        ImmersivePetroleum.log.info("Loading Distillation Recipes.");
        DistillationRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, DistillationRecipe.class, DistillationRecipe.TYPE);
        ImmersivePetroleum.log.info("Loading Reservoirs.");
        PumpjackHandler.reservoirs = new LinkedHashMap<ResourceLocation, PumpjackHandler.ReservoirType>(RecipeReloadListener.filterRecipes(recipes, PumpjackHandler.ReservoirType.class, PumpjackHandler.ReservoirType.TYPE));
    }

    static <R extends IRecipe<?>> Map<ResourceLocation, R> filterRecipes(Collection<IRecipe<?>> recipes, Class<R> recipeClass, IRecipeType<R> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.func_222127_g() == recipeType).map(recipeClass::cast).collect(Collectors.toMap(recipe -> recipe.func_199560_c(), recipe -> recipe));
    }
}

