/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.data;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.models.connection.ConnectionLoader;
import blusunrize.immersiveengineering.common.data.models.LoadedModelBuilder;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.AutoLubricatorBlock;
import flaxbeard.immersivepetroleum.common.blocks.GasGeneratorBlock;
import flaxbeard.immersivepetroleum.common.data.IPLoadedModels;
import flaxbeard.immersivepetroleum.common.util.fluids.IPFluid;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;

public class IPBlockStates
extends BlockStateProvider {
    private static final ResourceLocation FORGE_LOADER = new ResourceLocation("forge", "obj");
    final IPLoadedModels loadedModels;
    final ExistingFileHelper exFileHelper;
    private final ConfiguredModel EMPTY_MODEL;

    public IPBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper, IPLoadedModels loadedModels) {
        super(gen, "immersivepetroleum", exFileHelper);
        this.EMPTY_MODEL = new ConfiguredModel((ModelFile)new ModelFile.ExistingModelFile(new ResourceLocation("immersiveengineering", "block/ie_empty"), this.existingFileHelper));
        this.loadedModels = loadedModels;
        this.exFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        ModelFile dummyOilOreModel = this.cubeAll(IPContent.Blocks.dummyOilOre);
        this.getVariantBuilder(IPContent.Blocks.dummyOilOre).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(dummyOilOreModel)});
        this.itemModelWithParent(IPContent.Blocks.dummyOilOre, dummyOilOreModel);
        ModelFile.ExistingModelFile dummyPipeModel = this.getExistingFile(this.modLoc("block/dummy_pipe"));
        this.getVariantBuilder(IPContent.Blocks.dummyPipe).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)dummyPipeModel)});
        this.itemModelWithParent(IPContent.Blocks.dummyPipe, (ModelFile)dummyPipeModel);
        ModelFile.ExistingModelFile dummyConveyorModel = this.getExistingFile(this.modLoc("block/dummy_conveyor"));
        this.getVariantBuilder(IPContent.Blocks.dummyConveyor).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)dummyConveyorModel)});
        ((BlockModelBuilder)this.getItemBuilder(IPContent.Blocks.dummyConveyor).parent((ModelFile)dummyConveyorModel)).texture("particle", new ResourceLocation("immersiveengineering", "block/conveyor/conveyor"));
        this.distillationtower();
        this.pumpjack();
        this.simpleBlockWithItem(IPContent.Blocks.asphalt);
        this.gasGenerator();
        this.autolubricator();
        for (IPFluid f : IPFluid.LIST) {
            ResourceLocation still = f.getAttributes().getStillTexture();
            ModelBuilder model = ((BlockModelBuilder)this.getBuilder("block/fluid/" + f.getRegistryName().func_110623_a())).texture("particle", still);
            this.getVariantBuilder(f.block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
        this.loadedModels.backupModels();
    }

    private void distillationtower() {
        ResourceLocation idleTexture = this.modLoc("multiblock/distillation_tower");
        ResourceLocation modelNormal = this.modLoc("models/multiblock/obj/distillationtower.obj");
        ResourceLocation modelMirrored = this.modLoc("models/multiblock/obj/distillationtower_mirrored.obj");
        LoadedModelBuilder normal = this.multiblockModel(IPContent.Multiblock.distillationtower, modelNormal, idleTexture, "_idle");
        LoadedModelBuilder mirrored = this.multiblockModel(IPContent.Multiblock.distillationtower, modelMirrored, idleTexture, "_mirrored_idle");
        this.createMultiblock(IPContent.Multiblock.distillationtower, (ModelFile)normal, (ModelFile)mirrored, idleTexture);
    }

    private void pumpjack() {
        ResourceLocation texture = this.modLoc("multiblock/pumpjack_base");
        ResourceLocation modelNormal = this.modLoc("models/multiblock/obj/pumpjack.obj");
        ResourceLocation modelMirrored = this.modLoc("models/multiblock/obj/pumpjack_mirrored.obj");
        LoadedModelBuilder normal = this.multiblockModel(IPContent.Multiblock.pumpjack, modelNormal, texture, "");
        LoadedModelBuilder mirrored = this.multiblockModel(IPContent.Multiblock.pumpjack, modelMirrored, texture, "_mirrored");
        this.createMultiblock(IPContent.Multiblock.pumpjack, (ModelFile)normal, (ModelFile)mirrored, texture);
    }

    private LoadedModelBuilder multiblockModel(Block block, ResourceLocation model, ResourceLocation texture, String add) {
        LoadedModelBuilder re = ((LoadedModelBuilder)((LoadedModelBuilder)this.loadedModels.withExistingParent(this.getMultiblockPath(block) + add, this.mcLoc("block")).texture("texture", texture)).texture("particle", texture)).additional("flip-v", true).additional("model", model).additional("detectCullableFaces", false).loader(FORGE_LOADER);
        return re;
    }

    private void autolubricator() {
        ResourceLocation texture = this.modLoc("models/lubricator");
        BlockModelBuilder lube_empty = (BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("lube_empty", new ResourceLocation("immersiveengineering", "block/ie_empty"))).texture("particle", texture);
        LoadedModelBuilder lubeModel = (LoadedModelBuilder)((LoadedModelBuilder)this.loadedModels.withExistingParent(this.getPath(IPContent.Blocks.auto_lubricator), this.mcLoc("block")).loader(FORGE_LOADER).additional("model", this.modLoc("models/block/obj/autolubricator.obj")).additional("flip-v", true).texture("texture", texture)).texture("particle", texture);
        VariantBlockStateBuilder lubeBuilder = this.getVariantBuilder(IPContent.Blocks.auto_lubricator);
        for (Direction dir : AutoLubricatorBlock.FACING.func_177700_c()) {
            int rot = 90 * dir.func_176736_b() + 90;
            lubeBuilder.partialState().with((IProperty)AutoLubricatorBlock.SLAVE, (Comparable)Boolean.valueOf(false)).with((IProperty)AutoLubricatorBlock.FACING, (Comparable)dir).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)lubeModel, 0, rot, false)});
            lubeBuilder.partialState().with((IProperty)AutoLubricatorBlock.SLAVE, (Comparable)Boolean.valueOf(true)).with((IProperty)AutoLubricatorBlock.FACING, (Comparable)dir).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)lube_empty)});
        }
    }

    private void gasGenerator() {
        JsonObject basemodel = new JsonObject();
        basemodel.addProperty("loader", "forge:obj");
        basemodel.addProperty("model", this.modLoc("models/block/obj/generator.obj").toString());
        basemodel.addProperty("flip-v", Boolean.valueOf(true));
        ResourceLocation texture = this.modLoc("block/obj/generator");
        LoadedModelBuilder model = ((LoadedModelBuilder)((LoadedModelBuilder)this.loadedModels.getBuilder(this.getPath(IPContent.Blocks.gas_generator)).texture("texture", texture)).texture("particle", texture)).loader(ConnectionLoader.LOADER_NAME).additional("base_model", (JsonElement)basemodel).additional("layers", Arrays.asList("CUTOUT", "SOLID"));
        VariantBlockStateBuilder builder = this.getVariantBuilder(IPContent.Blocks.gas_generator);
        Direction.Plane.HORIZONTAL.forEach(dir -> {
            int rotation = (90 * dir.func_176736_b() + 90) % 360;
            builder.partialState().with((IProperty)GasGeneratorBlock.FACING, (Comparable)dir).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, rotation, false)});
        });
    }

    private void createMultiblock(Block b, ModelFile masterModel, ModelFile mirroredModel, ResourceLocation particleTexture) {
        this.createMultiblock(b, masterModel, mirroredModel, (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, (IProperty<Boolean>)IEProperties.MIRRORED, 180, particleTexture);
    }

    private void createMultiblock(Block b, ModelFile masterModel, @Nullable ModelFile mirroredModel, IProperty<Boolean> isSlave, EnumProperty<Direction> facing, @Nullable IProperty<Boolean> mirroredState, int rotationOffset, ResourceLocation particleTex) {
        Preconditions.checkArgument((mirroredModel == null == (mirroredState == null) ? 1 : 0) != 0);
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        builder.partialState().with(isSlave, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.withExistingParent(this.getMultiblockPath(b) + "_empty", this.EMPTY_MODEL.model.getLocation())).texture("particle", particleTex))});
        boolean[] possibleMirrorStates = mirroredState != null ? new boolean[]{false, true} : new boolean[1];
        for (boolean mirrored : possibleMirrorStates) {
            for (Direction dir : facing.func_177700_c()) {
                int angleY;
                int angleX;
                if (facing.func_177700_c().contains(Direction.UP)) {
                    angleX = -90 * dir.func_96559_d();
                    angleY = dir.func_176740_k() != Direction.Axis.Y ? this.getAngle(dir, rotationOffset) : 0;
                } else {
                    angleY = this.getAngle(dir, rotationOffset);
                    angleX = 0;
                }
                ModelFile model = mirrored ? mirroredModel : masterModel;
                VariantBlockStateBuilder.PartialBlockstate partialState = builder.partialState().with(isSlave, (Comparable)Boolean.valueOf(false)).with(facing, (Comparable)dir);
                if (mirroredState != null) {
                    partialState = partialState.with(mirroredState, (Comparable)Boolean.valueOf(mirrored));
                }
                partialState.setModels(new ConfiguredModel[]{new ConfiguredModel(model, angleX, angleY, true)});
            }
        }
    }

    private int getAngle(Direction dir, int offset) {
        return (int)((dir.func_185119_l() + (float)offset) % 360.0f);
    }

    private String getMultiblockPath(Block b) {
        return "multiblock/" + this.getPath(b);
    }

    private String getPath(Block b) {
        return b.getRegistryName().func_110623_a();
    }

    private void itemModelWithParent(Block block, ModelFile parent) {
        ((BlockModelBuilder)this.getItemBuilder(block).parent(parent)).texture("particle", this.modLoc("block/" + this.getPath(block)));
    }

    private void simpleBlockWithItem(Block block) {
        ModelFile file = this.cubeAll(block);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(file)});
        this.itemModelWithParent(block, file);
    }

    private BlockModelBuilder getItemBuilder(Block block) {
        return (BlockModelBuilder)this.getBuilder(this.modLoc("item/" + this.getPath(block)).toString());
    }
}

