/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.blocks.metal.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.metal.DistillationTowerTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.metal.GasGeneratorTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.metal.PumpjackTileEntity;
import flaxbeard.immersivepetroleum.common.entity.SpeedboatEntity;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.MessageDebugSync;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;

public class DebugItem
extends IPItemBase {
    public DebugItem() {
        super("debug");
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new StringTextComponent("IP Debugging Tool").func_211708_a(TextFormatting.LIGHT_PURPLE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new StringTextComponent("[Shift + Scroll-UP/DOWN] Change mode.").func_211708_a(TextFormatting.GRAY));
        Modes mode = DebugItem.getMode(stack);
        if (mode == Modes.DISABLED) {
            tooltip.add(new StringTextComponent("  Disabled.").func_211708_a(TextFormatting.DARK_GRAY));
        } else {
            tooltip.add(new StringTextComponent("  " + mode.display).func_211708_a(TextFormatting.DARK_GRAY));
        }
        tooltip.add(new StringTextComponent("You're not supposed to have this.").func_211708_a(TextFormatting.DARK_RED));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            Modes mode = DebugItem.getMode(playerIn.func_184586_b(handIn));
            switch (mode) {
                case RESERVOIR_BIG_SCAN: {
                    BlockPos pos = playerIn.func_180425_c();
                    int r = 5;
                    int cx = pos.func_177958_n() >> 4;
                    int cz = pos.func_177952_p() >> 4;
                    ImmersivePetroleum.log.info((Object)worldIn.field_73011_w.func_186058_p());
                    for (int i = -r; i <= r; ++i) {
                        for (int j = -r; j <= r; ++j) {
                            int x = cx + i;
                            int z = cz + j;
                            DimensionChunkCoords coords = new DimensionChunkCoords(worldIn.field_73011_w.func_186058_p(), x, z);
                            PumpjackHandler.OilWorldInfo info = PumpjackHandler.getOrCreateOilWorldInfo(worldIn, coords, false);
                            if (info == null || info.getType() == null) continue;
                            PumpjackHandler.ReservoirType type = info.getType();
                            int cap = info.capacity;
                            int cur = info.current;
                            String out = String.format(Locale.ENGLISH, "%s %s:\t%.3f/%.3f Buckets of %s", coords.field_77276_a, coords.field_77275_b, (double)cur / 1000.0, (double)cap / 1000.0, type.name);
                            ImmersivePetroleum.log.info(out);
                        }
                    }
                    return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
                }
                case CLEAR_RESERVOIR_CACHE: {
                    int contentSize = PumpjackHandler.reservoirsCache.size();
                    PumpjackHandler.reservoirsCache.clear();
                    PumpjackHandler.recalculateChances(true);
                    IPSaveData.setDirty();
                    playerIn.func_146105_b((ITextComponent)new StringTextComponent("Cleared Oil Cache. (Removed " + contentSize + ")"), true);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
                }
                case RESERVOIR: {
                    boolean isNew;
                    BlockPos pos = playerIn.func_180425_c();
                    DimensionChunkCoords coords = new DimensionChunkCoords(worldIn.field_73011_w.func_186058_p(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
                    int last = PumpjackHandler.reservoirsCache.size();
                    PumpjackHandler.OilWorldInfo info = PumpjackHandler.getOrCreateOilWorldInfo(worldIn, coords, false);
                    boolean bl = isNew = PumpjackHandler.reservoirsCache.size() != last;
                    if (info != null) {
                        int cap = info.capacity;
                        int cur = info.current;
                        PumpjackHandler.ReservoirType type = info.getType();
                        if (type != null) {
                            String out = String.format(Locale.ENGLISH, "%s %s: %.3f/%.3f Buckets of %s%s%s", coords.field_77276_a, coords.field_77275_b, (double)cur / 1000.0, (double)cap / 1000.0, type.name, info.overrideType != null ? " [OVERRIDDEN]" : "", isNew ? " [NEW]" : "");
                            playerIn.func_146105_b((ITextComponent)new StringTextComponent(out), true);
                            return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
                        }
                    }
                    playerIn.func_146105_b((ITextComponent)new StringTextComponent(String.format(Locale.ENGLISH, "%s %s: Nothing.", coords.field_77276_a, coords.field_77275_b)), true);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
                }
            }
            return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack held = player.func_184586_b(context.func_221531_n());
        Modes mode = DebugItem.getMode(held);
        TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
        switch (mode) {
            case INFO_TE_DISTILLATION_TOWER: {
                if (te instanceof DistillationTowerTileEntity && !context.func_195991_k().field_72995_K) {
                    DistillationTowerTileEntity tower = (DistillationTowerTileEntity)te;
                    if (!tower.offsetToMaster.equals((Object)BlockPos.field_177992_a)) {
                        tower = (DistillationTowerTileEntity)tower.master();
                    }
                    StringTextComponent tankInText = new StringTextComponent("\nInputFluids: ");
                    MultiFluidTank tank = tower.tanks[1];
                    for (int i = 0; i < tank.fluids.size(); ++i) {
                        FluidStack fstack = (FluidStack)tank.fluids.get(i);
                        tankInText.func_150258_a(" ").func_150257_a(fstack.getDisplayName()).func_150258_a(" " + fstack.getAmount() + "mB,");
                    }
                    StringTextComponent tankOutText = new StringTextComponent("\nOutputFluids: ");
                    MultiFluidTank tank2 = tower.tanks[0];
                    for (int i = 0; i < tank2.fluids.size(); ++i) {
                        FluidStack fstack = (FluidStack)tank2.fluids.get(i);
                        tankOutText.func_150258_a(" ").func_150257_a(fstack.getDisplayName()).func_150258_a(" " + fstack.getAmount() + "mB,");
                    }
                    player.func_145747_a(new StringTextComponent("DistillationTower:\n").func_150257_a((ITextComponent)tankInText).func_150257_a((ITextComponent)tankOutText));
                }
                return ActionResultType.PASS;
            }
            case INFO_TE_DISTILLATION_TOWER_STEP: {
                if (te instanceof DistillationTowerTileEntity && !context.func_195991_k().field_72995_K) {
                    DistillationTowerTileEntity tower = (DistillationTowerTileEntity)te;
                    if (!tower.offsetToMaster.equals((Object)BlockPos.field_177992_a)) {
                        tower = (DistillationTowerTileEntity)tower.master();
                    }
                    if (!tower.enableStepping) {
                        tower.enableStepping = true;
                        player.func_145747_a((ITextComponent)new StringTextComponent("Enabled Stepping."));
                    } else {
                        ++tower.step;
                        player.func_145747_a((ITextComponent)new StringTextComponent("Ticked."));
                    }
                }
                return ActionResultType.PASS;
            }
            case INFO_TE_MULTIBLOCK: {
                if (!(te instanceof PoweredMultiblockTileEntity) || context.func_195991_k().field_72995_K) break;
                PoweredMultiblockTileEntity poweredMultiblock = (PoweredMultiblockTileEntity)te;
                BlockPos loc = poweredMultiblock.posInMultiblock;
                Set energyInputs = poweredMultiblock.getEnergyPos();
                Set redstoneInputs = poweredMultiblock.getRedstonePos();
                StringTextComponent out = new StringTextComponent("[" + loc.func_177958_n() + " " + loc.func_177956_o() + " " + loc.func_177952_p() + "]: ");
                for (BlockPos pos : energyInputs) {
                    if (!pos.equals((Object)loc)) continue;
                    out.func_150258_a("Energy Port.");
                }
                for (BlockPos pos : redstoneInputs) {
                    if (!pos.equals((Object)loc)) continue;
                    out.func_150258_a("Redstone Port.");
                }
                if (poweredMultiblock.offsetToMaster.equals((Object)BlockPos.field_177992_a)) {
                    out.func_150258_a("Master.");
                }
                out.func_150258_a(" (Facing: " + poweredMultiblock.getFacing() + ", Block-Face: " + context.func_196000_l() + ")");
                player.func_146105_b((ITextComponent)out, true);
                return ActionResultType.SUCCESS;
            }
            case INFO_TE_AUTOLUBE: {
                if (!(te instanceof AutoLubricatorTileEntity)) break;
                AutoLubricatorTileEntity lube = (AutoLubricatorTileEntity)te;
                StringTextComponent out = new StringTextComponent(context.func_195991_k().field_72995_K ? "CLIENT: " : "SERVER: ");
                out.func_150258_a(lube.facing + ", ");
                out.func_150258_a((lube.isActive ? "Active" : "Inactive") + ", ");
                out.func_150258_a((lube.isSlave ? "Slave" : "Master") + ", ");
                out.func_150258_a(lube.predictablyDraining ? "Predictably Draining, " : "");
                if (!lube.tank.isEmpty()) {
                    out.func_150257_a(lube.tank.getFluid().getDisplayName()).func_150258_a(" " + lube.tank.getFluidAmount() + "/" + lube.tank.getCapacity() + "mB");
                } else {
                    out.func_150258_a("Empty");
                }
                player.func_145747_a((ITextComponent)out);
                return ActionResultType.SUCCESS;
            }
            case INFO_TE_GASGEN: {
                if (!(te instanceof GasGeneratorTileEntity)) break;
                GasGeneratorTileEntity gas = (GasGeneratorTileEntity)te;
                StringTextComponent out = new StringTextComponent(context.func_195991_k().field_72995_K ? "CLIENT: " : "SERVER: ");
                out.func_150258_a(gas.getFacing() + ", ");
                out.func_150258_a(gas.getEnergyStored(null) + ", ");
                out.func_150258_a(gas.getMaxEnergyStored(null) + ", ");
                player.func_145747_a((ITextComponent)out);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void onSpeedboatClick(SpeedboatEntity speedboatEntity, PlayerEntity player, ItemStack debugStack) {
        if (speedboatEntity.field_70170_p.field_72995_K || DebugItem.getMode(debugStack) != Modes.INFO_SPEEDBOAT) {
            return;
        }
        StringTextComponent textOut = new StringTextComponent("-- Speedboat --\n");
        FluidStack fluid = speedboatEntity.getContainedFluid();
        if (fluid == FluidStack.EMPTY) {
            textOut.func_150258_a("Tank: Empty");
        } else {
            textOut.func_150258_a("Tank: " + fluid.getAmount() + "/" + speedboatEntity.getMaxFuel() + "mB of ").func_150257_a(fluid.getDisplayName());
        }
        StringTextComponent upgradesText = new StringTextComponent("\n");
        NonNullList<ItemStack> upgrades = speedboatEntity.getUpgrades();
        int i = 0;
        for (ItemStack upgrade : upgrades) {
            if (upgrade == null || upgrade == ItemStack.field_190927_a) {
                upgradesText.func_150258_a("Upgrade " + ++i + ": Empty\n");
                continue;
            }
            upgradesText.func_150258_a("Upgrade " + i++ + ": ").func_150257_a(upgrade.func_200301_q()).func_150258_a("\n");
        }
        textOut.func_150257_a((ITextComponent)upgradesText);
        player.func_145747_a((ITextComponent)textOut);
    }

    private void analyze(ItemUseContext context, BlockState state, PumpjackTileEntity te) {
    }

    public static void setModeServer(ItemStack stack, Modes mode) {
        CompoundNBT nbt = DebugItem.getSettings(stack);
        nbt.func_74768_a("mode", mode.ordinal());
    }

    public static void setModeClient(ItemStack stack, Modes mode) {
        CompoundNBT nbt = DebugItem.getSettings(stack);
        nbt.func_74768_a("mode", mode.ordinal());
        IPPacketHandler.sendToServer(new MessageDebugSync(nbt));
    }

    public static Modes getMode(ItemStack stack) {
        CompoundNBT nbt = DebugItem.getSettings(stack);
        if (nbt.func_74764_b("mode")) {
            int mode = nbt.func_74762_e("mode");
            if (mode < 0 || mode >= Modes.values().length) {
                mode = 0;
            }
            return Modes.values()[mode];
        }
        return Modes.DISABLED;
    }

    public static CompoundNBT getSettings(ItemStack stack) {
        return stack.func_190925_c("settings");
    }

    protected static enum Modes {
        DISABLED("Disabled"),
        INFO_SPEEDBOAT("Info: Speedboat."),
        INFO_TE_AUTOLUBE("Info: AutoLubricator."),
        INFO_TE_GASGEN("Info: Portable Generator."),
        INFO_TE_MULTIBLOCK("Info: Powered Multiblock."),
        INFO_TE_DISTILLATION_TOWER("Info: Distillation Tower."),
        INFO_TE_DISTILLATION_TOWER_STEP("Info: Manual DT Ticking."),
        RESERVOIR("Create/Get Reservoir"),
        RESERVOIR_BIG_SCAN("Scan 5 Block Radius Area"),
        CLEAR_RESERVOIR_CACHE("Clear Reservoir Cache");

        public final String display;

        private Modes(String display) {
            this.display = display;
        }
    }

    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientInputHandler {
        static boolean shiftHeld = false;

        @SubscribeEvent
        public static void handleScroll(InputEvent.MouseScrollEvent event) {
            double delta = event.getScrollDelta();
            if (shiftHeld && delta != 0.0) {
                boolean off;
                ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
                ItemStack mainItem = player.func_184614_ca();
                ItemStack secondItem = player.func_184592_cb();
                boolean main = !mainItem.func_190926_b() && mainItem.func_77973_b() == IPContent.debugItem;
                boolean bl = off = !secondItem.func_190926_b() && secondItem.func_77973_b() == IPContent.debugItem;
                if (main || off) {
                    ItemStack target = main ? mainItem : secondItem;
                    Modes mode = DebugItem.getMode(target);
                    int id = mode.ordinal() + (int)delta;
                    if (id < 0) {
                        id = Modes.values().length - 1;
                    }
                    if (id >= Modes.values().length) {
                        id = 0;
                    }
                    mode = Modes.values()[id];
                    DebugItem.setModeClient(target, mode);
                    player.func_146105_b((ITextComponent)new StringTextComponent(mode.display), true);
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void handleKey(InputEvent.KeyInputEvent event) {
            if (event.getKey() == 344 || event.getKey() == 340) {
                switch (event.getAction()) {
                    case 1: {
                        shiftHeld = true;
                        return;
                    }
                    case 0: {
                        shiftHeld = false;
                        return;
                    }
                }
            }
        }
    }
}

