/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.realmsclient.gui.ChatFormatting;
import flaxbeard.immersivepetroleum.api.event.SchematicPlaceBlockEvent;
import flaxbeard.immersivepetroleum.api.event.SchematicPlaceBlockPostEvent;
import flaxbeard.immersivepetroleum.api.event.SchematicRenderBlockEvent;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.client.ShaderUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.MessageRotateSchematic;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableInt;

@Mod.EventBusSubscriber(modid="immersivepetroleum")
public class ProjectorItem
extends IPItemBase {
    static final Map<Class<? extends MultiblockHandler.IMultiblock>, String> nameCache = new HashMap<Class<? extends MultiblockHandler.IMultiblock>, String>();
    private static Method METHOD_GETTEMPLATE;

    public ProjectorItem(String name) {
        super(name, new Item.Properties().func_200917_a(1));
    }

    protected static MultiblockHandler.IMultiblock getMultiblock(ItemStack stack) {
        return ProjectorItem.getMultiblock(ProjectorItem.getMultiblockIdentifierFrom(stack));
    }

    protected static MultiblockHandler.IMultiblock getMultiblock(ResourceLocation identifier) {
        if (identifier == null) {
            return null;
        }
        return MultiblockHandler.getByUniqueName((ResourceLocation)identifier);
    }

    protected static ResourceLocation getMultiblockIdentifierFrom(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblock")) {
            String tmp = ItemNBTHelper.getString((ItemStack)stack, (String)"multiblock");
            return new ResourceLocation(tmp);
        }
        return null;
    }

    protected static ItemStack putMultiblockIdentifier(ItemStack stack, MultiblockHandler.IMultiblock multiblock) {
        ItemNBTHelper.putString((ItemStack)stack, (String)"multiblock", (String)multiblock.getUniqueName().toString());
        return stack;
    }

    private static int processMultiblock(MultiblockHandler.IMultiblock multiblock, Rotation rotation, boolean flip, Predicate<BlockProcessInfo> consumer) {
        BlockPos transformedPos;
        Template.BlockInfo info;
        BlockPos offset;
        if (multiblock == null) {
            return 0;
        }
        Vec3i size = multiblock.getSize();
        int mWidth = size.func_177958_n();
        int mDepth = size.func_177952_p();
        boolean evenWidth = (float)mWidth / 2.0f - (float)(mWidth / 2) == 0.0f;
        boolean evenDepth = (float)mDepth / 2.0f - (float)(mDepth / 2) == 0.0f;
        int xa = evenWidth ? 1 : 0;
        int za = evenDepth ? 1 : 0;
        PlacementSettings setting = new PlacementSettings();
        setting.func_186214_a(flip ? Mirror.FRONT_BACK : Mirror.NONE);
        setting.func_186220_a(rotation);
        if (flip) {
            offset = new BlockPos(-mWidth / 2, 0, mDepth / 2);
            setting.func_207665_a(offset);
            switch (rotation) {
                case NONE: {
                    offset = offset.func_177982_a(xa, 0, 0);
                    break;
                }
                case CLOCKWISE_90: {
                    offset = offset.func_177982_a(xa, 0, za);
                    break;
                }
                case CLOCKWISE_180: {
                    offset = offset.func_177982_a(0, 0, za);
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    break;
                }
            }
        } else {
            offset = new BlockPos(mWidth / 2, 0, mDepth / 2);
            setting.func_207665_a(offset);
            switch (rotation) {
                case CLOCKWISE_90: {
                    offset = offset.func_177982_a(xa, 0, 0);
                    break;
                }
                case CLOCKWISE_180: {
                    offset = offset.func_177982_a(xa, 0, za);
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    offset = offset.func_177982_a(0, 0, za);
                    break;
                }
            }
        }
        Template multiblockTemplate = ProjectorItem.getMultiblockTemplate(multiblock);
        List blocks = (List)multiblockTemplate.field_204769_a.get(0);
        for (int i = 0; i < blocks.size() && !consumer.test(new BlockProcessInfo(setting, info = (Template.BlockInfo)blocks.get(i), multiblock, transformedPos = Template.func_186266_a((PlacementSettings)setting, (BlockPos)info.field_186242_a).func_177973_b((Vec3i)offset))); ++i) {
        }
        return blocks.size();
    }

    private static BlockPos alignHit(BlockPos hit, PlayerEntity playerIn, Rotation rotation, Vec3i multiblockSize, boolean flip) {
        int xd = rotation.ordinal() % 2 == 0 ? multiblockSize.func_177958_n() : multiblockSize.func_177952_p();
        int zd = rotation.ordinal() % 2 == 0 ? multiblockSize.func_177952_p() : multiblockSize.func_177958_n();
        Direction look = playerIn.func_174811_aO();
        if (multiblockSize.func_177952_p() > 1 && (look == Direction.NORTH || look == Direction.SOUTH)) {
            int a = zd / 2;
            if (look == Direction.NORTH) {
                ++a;
            }
            hit = hit.func_177982_a(0, 0, a);
        } else if (multiblockSize.func_177958_n() > 1 && (look == Direction.EAST || look == Direction.WEST)) {
            int a = xd / 2;
            if (look == Direction.WEST) {
                ++a;
            }
            hit = hit.func_177982_a(a, 0, 0);
        }
        if (multiblockSize.func_177952_p() > 1 && look == Direction.NORTH) {
            hit = hit.func_177982_a(0, 0, -zd);
        } else if (multiblockSize.func_177958_n() > 1 && look == Direction.WEST) {
            hit = hit.func_177982_a(-xd, 0, 0);
        }
        return hit;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        MultiblockHandler.IMultiblock mb;
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblock") && (mb = ProjectorItem.getMultiblock(stack)) != null) {
            String name = ProjectorItem.getActualMBName(mb);
            String build0 = I18n.func_135052_a((String)"chat.immersivepetroleum.info.schematic.build0", (Object[])new Object[0]);
            String build1 = I18n.func_135052_a((String)"chat.immersivepetroleum.info.schematic.build1", (Object[])new Object[]{I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock.IE:" + name), (Object[])new Object[0])});
            tooltip.add((ITextComponent)new StringTextComponent(build0));
            tooltip.add((ITextComponent)new StringTextComponent(build1));
            Vec3i size = mb.getSize();
            tooltip.add(new StringTextComponent(size.func_177958_n() + " x " + size.func_177956_o() + " x " + size.func_177952_p()).func_211708_a(TextFormatting.DARK_GRAY));
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"pos")) {
                CompoundNBT pos = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"pos");
                int x = pos.func_74762_e("x");
                int y = pos.func_74762_e("y");
                int z = pos.func_74762_e("z");
                tooltip.add(new TranslationTextComponent("chat.immersivepetroleum.info.schematic.center", new Object[]{x, y, z}).func_211708_a(TextFormatting.DARK_GRAY));
            }
            String rotation = I18n.func_135052_a((String)("chat.immersivepetroleum.info.projector.rotated." + Direction.func_176731_b((int)ProjectorItem.getRotation(stack).ordinal())), (Object[])new Object[0]);
            String flipped = I18n.func_135052_a((String)("chat.immersivepetroleum.info.projector.flipped." + (ProjectorItem.getFlipped(stack) ? "yes" : "no")), (Object[])new Object[0]);
            tooltip.add(new StringTextComponent(rotation).func_211708_a(TextFormatting.DARK_GRAY));
            tooltip.add(new StringTextComponent(I18n.func_135052_a((String)"chat.immersivepetroleum.info.projector.flipped", (Object[])new Object[]{flipped})).func_211708_a(TextFormatting.DARK_GRAY));
            ITextComponent ctrl0 = new TranslationTextComponent("chat.immersivepetroleum.info.schematic.controls1", new Object[0]).func_211708_a(TextFormatting.DARK_GRAY);
            ITextComponent ctrl1 = new TranslationTextComponent("chat.immersivepetroleum.info.schematic.controls2", new Object[]{ClientProxy.keybind_preview_flip.func_197978_k()}).func_211708_a(TextFormatting.DARK_GRAY);
            tooltip.add(ctrl0);
            tooltip.add(ctrl1);
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"chat.immersivepetroleum.info.schematic.noMultiblock", (Object[])new Object[0])));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        MultiblockHandler.IMultiblock mb;
        String selfKey = this.func_77667_c(stack);
        if (stack.func_77942_o() && ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblock") && (mb = ProjectorItem.getMultiblock(stack)) != null) {
            String name = ProjectorItem.getActualMBName(mb);
            return new TranslationTextComponent(selfKey + ".specific", new Object[]{I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock.IE:" + name), (Object[])new Object[0])});
        }
        return new TranslationTextComponent(selfKey, new Object[0]);
    }

    private static String getActualMBName(MultiblockHandler.IMultiblock multiblock) {
        if (!nameCache.containsKey(multiblock.getClass())) {
            String name = multiblock.getClass().getSimpleName();
            switch (name = name.substring(0, name.indexOf("Multiblock"))) {
                case "LightningRod": {
                    name = "Lightningrod";
                    break;
                }
                case "ImprovedBlastfurnace": {
                    name = "BlastFurnaceAdvanced";
                }
            }
            nameCache.put(multiblock.getClass(), name);
        }
        return nameCache.get(multiblock.getClass());
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this, 1));
            ArrayList multiblocks = MultiblockHandler.getMultiblocks();
            for (MultiblockHandler.IMultiblock multiblock : multiblocks) {
                ResourceLocation str = multiblock.getUniqueName();
                if (str.func_110623_a().equals("excavator_demo") || str.func_110623_a().contains("feedthrough")) continue;
                items.add((Object)ProjectorItem.putMultiblockIdentifier(new ItemStack((IItemProvider)this, 1), multiblock));
            }
        }
    }

    private static Template getMultiblockTemplate(MultiblockHandler.IMultiblock multiblock) {
        if (multiblock instanceof TemplateMultiblock) {
            try {
                if (METHOD_GETTEMPLATE == null) {
                    METHOD_GETTEMPLATE = TemplateMultiblock.class.getDeclaredMethod("getTemplate", new Class[0]);
                    METHOD_GETTEMPLATE.setAccessible(true);
                }
                return (Template)METHOD_GETTEMPLATE.invoke((Object)multiblock, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity playerIn = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        ItemStack stack = playerIn.func_184586_b(hand);
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"pos") && playerIn.func_70093_af()) {
            ItemNBTHelper.remove((ItemStack)stack, (String)"pos");
            return ActionResultType.SUCCESS;
        }
        MultiblockHandler.IMultiblock multiblock = ProjectorItem.getMultiblock(stack);
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"pos") && multiblock != null) {
            BlockState state = world.func_180495_p(pos);
            BlockPos hit = pos;
            if (!state.func_185904_a().func_76222_j() && facing == Direction.UP) {
                hit = hit.func_177982_a(0, 1, 0);
            }
            Vec3i size = multiblock.getSize();
            int mHeight = size.func_177956_o();
            int mWidth = size.func_177958_n();
            int mDepth = size.func_177952_p();
            Rotation rotation = ProjectorItem.getRotation(stack);
            boolean flip = ProjectorItem.getFlipped(stack);
            hit = ProjectorItem.alignHit(hit, playerIn, rotation, size, flip);
            if (playerIn.func_70093_af() && playerIn.func_184812_l_()) {
                if (multiblock.getUniqueName().func_110623_a().contains("excavator_demo") || multiblock.getUniqueName().func_110623_a().contains("bucket_wheel")) {
                    hit = hit.func_177982_a(0, -2, 0);
                }
                BlockPos hitCopy = new BlockPos((Vec3i)hit);
                ProjectorItem.processMultiblock(multiblock, rotation, flip, con -> {
                    SchematicPlaceBlockEvent event = new SchematicPlaceBlockEvent(multiblock, world, con.tPos, con.getInfoPos(), con.getInfoState(), con.getInfoNBT(), rotation);
                    if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                        world.func_175656_a(con.tPos.func_177971_a((Vec3i)hitCopy), con.getInfoState());
                        SchematicPlaceBlockPostEvent postevent = new SchematicPlaceBlockPostEvent(multiblock, world, con.tPos, con.getInfoPos(), con.getInfoState(), con.getInfoNBT(), rotation);
                        MinecraftForge.EVENT_BUS.post((Event)postevent);
                    }
                    return false;
                });
                return ActionResultType.SUCCESS;
            }
            CompoundNBT posTag = new CompoundNBT();
            posTag.func_74768_a("x", hit.func_177958_n());
            posTag.func_74768_a("y", hit.func_177956_o());
            posTag.func_74768_a("z", hit.func_177952_p());
            ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"pos", (CompoundNBT)posTag);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static Rotation getRotation(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"rotate")) {
            int index = ItemNBTHelper.getInt((ItemStack)stack, (String)"rotate") % 4;
            if (index < 0 || index >= Rotation.values().length) {
                index = 0;
            }
            return Rotation.values()[index];
        }
        return Rotation.NONE;
    }

    public static boolean getFlipped(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"flip")) {
            return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"flip");
        }
        return false;
    }

    public static void rotateClient(ItemStack stack, int direction) {
        int newRotate;
        boolean flip = ProjectorItem.getFlipped(stack);
        for (newRotate = (ProjectorItem.getRotation(stack).ordinal() + direction) % 4; newRotate < 0; newRotate += 4) {
        }
        ProjectorItem.setRotate(stack, newRotate);
        IPPacketHandler.sendToServer(new MessageRotateSchematic(newRotate, flip));
    }

    public static void flipClient(ItemStack stack) {
        int newRotate = ProjectorItem.getRotation(stack).ordinal();
        boolean flip = !ProjectorItem.getFlipped(stack);
        ProjectorItem.setFlipped(stack, flip);
        IPPacketHandler.sendToServer(new MessageRotateSchematic(newRotate, flip));
    }

    public static void setRotate(ItemStack stack, Rotation rotation) {
        ItemNBTHelper.putInt((ItemStack)stack, (String)"rotate", (int)rotation.ordinal());
    }

    public static void setRotate(ItemStack stack, int rotation) {
        ItemNBTHelper.putInt((ItemStack)stack, (String)"rotate", (int)rotation);
    }

    public static void setFlipped(ItemStack stack, boolean flip) {
        ItemNBTHelper.putBoolean((ItemStack)stack, (String)"flip", (boolean)flip);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"pos") && playerIn.func_70093_af()) {
            ItemNBTHelper.remove((ItemStack)stack, (String)"pos");
            return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    @SubscribeEvent
    public static void handleConveyorPlace(SchematicPlaceBlockPostEvent event) {
        TileEntity te;
        MultiblockHandler.IMultiblock mb = event.getMultiblock();
        BlockState state = event.getState();
        String mbName = mb.getUniqueName().func_110623_a();
        if (!mbName.equals("multiblocks/auto_workbench") && !mbName.equals("multiblocks/bottling_machine") && !mbName.equals("multiblocks/assembler") && !mbName.equals("multiblocks/metal_press") || state.func_177230_c() != IEBlocks.MetalDevices.CONVEYORS.get(BasicConveyor.NAME) || (te = event.getWorld().func_175625_s(event.getWorldPos())) instanceof ConveyorBeltTileEntity) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void handleConveyorsAndPipes(SchematicRenderBlockEvent event) {
        String mbName = event.getMultiblock().getUniqueName().func_110623_a();
        BlockState state = event.getState();
        Block block = state.func_177230_c();
        Rotation rotate = event.getRotate();
        if (state.func_206869_a().contains(IEProperties.MULTIBLOCKSLAVE) && ((Boolean)state.func_177229_b((IProperty)IEProperties.MULTIBLOCKSLAVE)).booleanValue()) {
            event.setCanceled(true);
            return;
        }
        if (mbName.equals("multiblocks/distillationtower") && block instanceof SlabBlock && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP) {
            GlStateManager.translated((double)0.0, (double)0.5, (double)0.0);
        }
        if (block == IEBlocks.MetalDevices.fluidPipe) {
            event.setState(IPContent.Blocks.dummyPipe.func_176223_P());
        } else if (block == IEBlocks.MetalDevices.CONVEYORS.get(BasicConveyor.NAME)) {
            Direction facing = (Direction)state.func_177229_b((IProperty)IEProperties.FACING_HORIZONTAL);
            switch (facing) {
                case NORTH: {
                    GlStateManager.rotated((double)0.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case SOUTH: {
                    GlStateManager.rotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case EAST: {
                    GlStateManager.rotated((double)270.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
            }
            switch (rotate) {
                case CLOCKWISE_90: {
                    GlStateManager.rotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case CLOCKWISE_180: {
                    GlStateManager.rotated((double)-180.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    GlStateManager.rotated((double)-270.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
            }
        } else if (block == Blocks.field_150331_J) {
            Direction facing = (Direction)state.func_177229_b((IProperty)PistonBlock.field_176387_N);
            if (facing == Direction.DOWN) {
                GlStateManager.rotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            } else if (facing == Direction.NORTH) {
                GlStateManager.rotated((double)270.0, (double)1.0, (double)0.0, (double)0.0);
            } else if (facing == Direction.SOUTH) {
                GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            } else if (facing == Direction.EAST) {
                GlStateManager.rotated((double)270.0, (double)0.0, (double)0.0, (double)1.0);
            } else if (facing == Direction.WEST) {
                GlStateManager.rotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
    }

    private static class RenderInfo {
        public final int layer;
        public final Template.BlockInfo blockInfo;
        public final BlockPos worldPos;
        public final PlacementSettings settings;

        public RenderInfo(int layer, Template.BlockInfo blockInfo, PlacementSettings settings, BlockPos worldPos) {
            this.layer = layer;
            this.blockInfo = blockInfo;
            this.worldPos = worldPos;
            this.settings = settings;
        }
    }

    protected static class BlockProcessInfo {
        public final Template.BlockInfo info;
        public final BlockPos tPos;
        public final PlacementSettings setting;
        public final MultiblockHandler.IMultiblock multiblock;

        public BlockProcessInfo(PlacementSettings setting, Template.BlockInfo info, MultiblockHandler.IMultiblock multiblock, BlockPos transformedPos) {
            this.info = info;
            this.tPos = transformedPos;
            this.setting = setting;
            this.multiblock = multiblock;
        }

        public Rotation getRotation() {
            return this.setting.func_186215_c();
        }

        public CompoundNBT getInfoNBT() {
            return this.info.field_186244_c;
        }

        public BlockPos getInfoPos() {
            return this.info.field_186242_a;
        }

        public BlockState getInfoState() {
            return this.info.field_186243_b;
        }

        public BlockState getState() {
            return this.info.field_186243_b.func_185907_a(this.getRotation());
        }
    }

    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientInputHandler {
        static boolean shiftHeld = false;

        @SubscribeEvent
        public static void handleScroll(InputEvent.MouseScrollEvent event) {
            double delta = event.getScrollDelta();
            if (shiftHeld && delta != 0.0) {
                boolean off;
                ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
                ItemStack mainItem = player.func_184614_ca();
                ItemStack secondItem = player.func_184592_cb();
                boolean main = !mainItem.func_190926_b() && mainItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)mainItem, (String)"multiblock");
                boolean bl = off = !secondItem.func_190926_b() && secondItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)secondItem, (String)"multiblock");
                if (main || off) {
                    ItemStack target = main ? mainItem : secondItem;
                    ProjectorItem.rotateClient(target, (int)delta);
                    Rotation rot = ProjectorItem.getRotation(target);
                    Direction facing = Direction.func_176731_b((int)rot.ordinal());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.info.projector.rotated." + facing, new Object[0]), true);
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void handleKey(InputEvent.KeyInputEvent event) {
            if (event.getKey() == 344 || event.getKey() == 340) {
                switch (event.getAction()) {
                    case 1: {
                        shiftHeld = true;
                        return;
                    }
                    case 0: {
                        shiftHeld = false;
                        return;
                    }
                }
            }
            if (shiftHeld && ClientProxy.keybind_preview_flip.func_151468_f()) {
                ClientInputHandler.doAFlip();
            }
        }

        @SubscribeEvent
        public static void handleMouseInput(InputEvent.MouseInputEvent event) {
            if (ClientProxy.keybind_preview_flip.func_151468_f()) {
                ClientInputHandler.doAFlip();
            }
        }

        private static void doAFlip() {
            ItemStack target;
            ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
            ItemStack mainItem = player.func_184614_ca();
            ItemStack secondItem = player.func_184592_cb();
            boolean main = !mainItem.func_190926_b() && mainItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)mainItem, (String)"multiblock");
            boolean off = !secondItem.func_190926_b() && secondItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)secondItem, (String)"multiblock");
            ItemStack itemStack = target = main ? mainItem : secondItem;
            if (main || off) {
                ProjectorItem.flipClient(target);
                boolean flipped = ProjectorItem.getFlipped(target);
                String yesno = flipped ? I18n.func_135052_a((String)"chat.immersivepetroleum.info.projector.flipped.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"chat.immersivepetroleum.info.projector.flipped.no", (Object[])new Object[0]);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.info.projector.flipped", new Object[]{yesno}), true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientRenderHandler {
        @SubscribeEvent
        public static void renderLast(RenderWorldLastEvent event) {
            Minecraft mc = ClientUtils.mc();
            GlStateManager.pushMatrix();
            if (mc.field_71439_g != null) {
                ItemStack secondItem = mc.field_71439_g.func_184592_cb();
                boolean off = !secondItem.func_190926_b() && secondItem.func_77973_b() == IPContent.Items.projector && ItemNBTHelper.hasKey((ItemStack)secondItem, (String)"multiblock");
                for (int i = 0; i <= 10; ++i) {
                    ItemStack stack;
                    ItemStack itemStack = stack = i == 10 ? secondItem : mc.field_71439_g.field_71071_by.func_70301_a(i);
                    if (stack.func_190926_b() || stack.func_77973_b() != IPContent.Items.projector || !ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblock")) continue;
                    GlStateManager.pushMatrix();
                    ClientRenderHandler.renderSchematic(stack, (PlayerEntity)mc.field_71439_g, mc.field_71439_g.field_70170_p, event.getPartialTicks(), i == mc.field_71439_g.field_71071_by.field_70461_c || i == 10 && off);
                    GlStateManager.popMatrix();
                }
            }
            GlStateManager.popMatrix();
        }

        public static void renderSchematic(ItemStack target, PlayerEntity player, World world, float partialTicks, boolean shouldRenderMoving) {
            Minecraft mc = ClientUtils.mc();
            MultiblockHandler.IMultiblock multiblock = ProjectorItem.getMultiblock(target);
            if (multiblock == null) {
                return;
            }
            BlockPos hit = null;
            Vec3i size = multiblock.getSize();
            Rotation rotation = ProjectorItem.getRotation(target);
            boolean flip = ProjectorItem.getFlipped(target);
            boolean isPlaced = false;
            if (ItemNBTHelper.hasKey((ItemStack)target, (String)"pos")) {
                CompoundNBT pos = ItemNBTHelper.getTagCompound((ItemStack)target, (String)"pos");
                int x = pos.func_74762_e("x");
                int y = pos.func_74762_e("y");
                int z = pos.func_74762_e("z");
                hit = new BlockPos(x, y, z);
                isPlaced = true;
            } else if (shouldRenderMoving && ClientUtils.mc().field_71476_x != null && ClientUtils.mc().field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockRTResult = (BlockRayTraceResult)ClientUtils.mc().field_71476_x;
                BlockPos pos = blockRTResult.func_216350_a();
                BlockState state = world.func_180495_p(pos);
                hit = state.func_185904_a().func_76222_j() || blockRTResult.func_216354_b() != Direction.UP ? pos : pos.func_177982_a(0, 1, 0);
                hit = ProjectorItem.alignHit(hit, (PlayerEntity)mc.field_71439_g, rotation, size, flip);
            }
            if (hit != null) {
                if (multiblock.getUniqueName().func_110623_a().contains("excavator_demo") || multiblock.getUniqueName().func_110623_a().contains("bucket_wheel")) {
                    hit = hit.func_177982_a(0, -2, 0);
                }
                boolean placedCopy = isPlaced;
                ArrayList toRender = new ArrayList();
                MutableInt currentSlice = new MutableInt();
                MutableInt badBlocks = new MutableInt();
                MutableInt goodBlocks = new MutableInt();
                BlockPos hitCopy = new BlockPos((Vec3i)hit);
                int blockListSize = ProjectorItem.processMultiblock(multiblock, rotation, flip, con -> {
                    if (badBlocks.getValue() == 0 && con.getInfoPos().func_177956_o() > currentSlice.getValue()) {
                        currentSlice.setValue(con.getInfoPos().func_177956_o());
                    } else if (con.getInfoPos().func_177956_o() != currentSlice.getValue().intValue()) {
                        return true;
                    }
                    if (placedCopy) {
                        if (con.getInfoPos().func_177956_o() == currentSlice.getValue().intValue()) {
                            boolean skip = false;
                            BlockState toCompare = world.func_180495_p(con.tPos.func_177971_a((Vec3i)hitCopy));
                            if (con.getInfoState().func_177230_c() == toCompare.func_177230_c()) {
                                toRender.add(new RenderInfo(2, con.info, con.setting, con.tPos));
                                goodBlocks.increment();
                                skip = true;
                            } else {
                                if (toCompare != Blocks.field_150350_a.func_176223_P()) {
                                    toRender.add(new RenderInfo(1, con.info, con.setting, con.tPos));
                                    skip = true;
                                }
                                badBlocks.increment();
                            }
                            if (!skip) {
                                toRender.add(new RenderInfo(0, con.info, con.setting, con.tPos));
                            }
                        }
                    } else {
                        toRender.add(new RenderInfo(0, con.info, con.setting, con.tPos));
                    }
                    return false;
                });
                boolean perfect = goodBlocks.getValue() == blockListSize;
                toRender.sort((a, b) -> {
                    if (a.layer > b.layer) {
                        return 1;
                    }
                    if (a.layer < b.layer) {
                        return -1;
                    }
                    return 0;
                });
                double px = TileEntityRendererDispatcher.field_147554_b;
                double py = TileEntityRendererDispatcher.field_147555_c;
                double pz = TileEntityRendererDispatcher.field_147552_d;
                GlStateManager.translated((double)((double)hit.func_177958_n() - px), (double)((double)hit.func_177956_o() - py), (double)((double)hit.func_177952_p() - pz));
                GlStateManager.disableLighting();
                GlStateManager.shadeModel((int)(Minecraft.func_71379_u() ? 7425 : 7424));
                GlStateManager.enableBlend();
                ClientUtils.bindAtlas();
                float flicker = world.field_73012_v.nextInt(10) == 0 ? 0.75f : (world.field_73012_v.nextInt(20) == 0 ? 0.5f : 1.0f);
                ItemStack heldStack = player.func_184614_ca();
                BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
                BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                toRender.forEach(rInfo -> {
                    Template.BlockInfo info = rInfo.blockInfo;
                    float alpha = heldStack.func_77973_b() == info.field_186243_b.func_177230_c().func_199767_j() ? 1.0f : 0.5f;
                    switch (rInfo.layer) {
                        case 0: {
                            GlStateManager.pushMatrix();
                            ClientRenderHandler.renderPhantom(multiblock, world, info, rInfo.worldPos, flicker, alpha, partialTicks, flip, rInfo.settings.func_186215_c());
                            GlStateManager.popMatrix();
                            break;
                        }
                        case 1: {
                            GlStateManager.pushMatrix();
                            GlStateManager.disableDepthTest();
                            ClientRenderHandler.renderCenteredOutlineBox((Vec3i)rInfo.worldPos, 1.0f, 0.0f, 0.0f, flicker, 1.005f);
                            GlStateManager.enableDepthTest();
                            GlStateManager.popMatrix();
                            break;
                        }
                        case 2: {
                            min.func_181079_c(rInfo.worldPos.func_177958_n() < min.func_177958_n() ? rInfo.worldPos.func_177958_n() : min.func_177958_n(), rInfo.worldPos.func_177956_o() < min.func_177956_o() ? rInfo.worldPos.func_177956_o() : min.func_177956_o(), rInfo.worldPos.func_177952_p() < min.func_177952_p() ? rInfo.worldPos.func_177952_p() : min.func_177952_p());
                            max.func_181079_c(rInfo.worldPos.func_177958_n() > max.func_177958_n() ? rInfo.worldPos.func_177958_n() : max.func_177958_n(), rInfo.worldPos.func_177956_o() > max.func_177956_o() ? rInfo.worldPos.func_177956_o() : max.func_177956_o(), rInfo.worldPos.func_177952_p() > max.func_177952_p() ? rInfo.worldPos.func_177952_p() : max.func_177952_p());
                        }
                    }
                });
                if (perfect) {
                    GlStateManager.pushMatrix();
                    ClientRenderHandler.renderOutlineBox((Vec3i)min, (Vec3i)max, 0.0f, 0.75f, 0.0f, flicker);
                    GlStateManager.popMatrix();
                }
            }
        }

        private static void renderPhantom(MultiblockHandler.IMultiblock multiblock, World world, Template.BlockInfo info, BlockPos wPos, float flicker, float alpha, float partialTicks, boolean flipXZ, Rotation rotation) {
            ItemRenderer itemRenderer = ClientUtils.mc().func_175599_af();
            GlStateManager.translated((double)((double)wPos.func_177958_n() + 0.5), (double)((double)wPos.func_177956_o() + 0.5), (double)((double)wPos.func_177952_p() + 0.5));
            ShaderUtil.alpha_static(flicker * alpha, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
            SchematicRenderBlockEvent renderEvent = new SchematicRenderBlockEvent(multiblock, world, wPos, info.field_186242_a, info.field_186243_b, info.field_186244_c, rotation);
            if (!MinecraftForge.EVENT_BUS.post((Event)renderEvent)) {
                ItemStack toRender = new ItemStack((IItemProvider)renderEvent.getState().func_177230_c());
                itemRenderer.func_180454_a(toRender, itemRenderer.func_204206_b(toRender));
            }
            ShaderUtil.releaseShader();
        }

        private static void renderOutlineBox(Vec3i min, Vec3i max, float r, float g, float b, float flicker) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            float alpha = 0.25f + 0.5f * flicker;
            float xMax = Math.abs(min.func_177958_n() - max.func_177958_n()) + 1;
            float yMax = Math.abs(min.func_177956_o() - max.func_177956_o()) + 1;
            float zMax = Math.abs(min.func_177952_p() - max.func_177952_p()) + 1;
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(0.0, 1.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 1.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 1.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 1.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 1.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 1.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 1.0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            GlStateManager.disableTexture();
            GlStateManager.enableBlend();
            GlStateManager.disableCull();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GlStateManager.shadeModel((int)7425);
            GlStateManager.lineWidth((float)2.5f);
            GlStateManager.translated((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p());
            GlStateManager.scalef((float)xMax, (float)yMax, (float)zMax);
            tessellator.func_78381_a();
            GlStateManager.shadeModel((int)7424);
            GlStateManager.enableCull();
            GlStateManager.disableBlend();
            GlStateManager.enableTexture();
        }

        private static void renderCenteredOutlineBox(Vec3i position, float r, float g, float b, float flicker, float xyzScale) {
            ClientRenderHandler.renderCenteredOutlineBox(position, r, g, b, flicker, xyzScale, xyzScale, xyzScale);
        }

        private static void renderCenteredOutlineBox(Vec3i position, float r, float g, float b, float flicker, float xScale, float yScale, float zScale) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            float alpha = 0.375f * flicker;
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(-0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
            GlStateManager.translated((double)((double)position.func_177958_n() + 0.5), (double)((double)position.func_177956_o() + 0.5), (double)((double)position.func_177952_p() + 0.5));
            GlStateManager.scalef((float)xScale, (float)yScale, (float)zScale);
            GlStateManager.disableTexture();
            GlStateManager.enableBlend();
            GlStateManager.disableCull();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GlStateManager.shadeModel((int)7425);
            GlStateManager.lineWidth((float)3.5f);
            tessellator.func_78381_a();
            GlStateManager.shadeModel((int)7424);
            GlStateManager.enableCull();
            GlStateManager.disableBlend();
            GlStateManager.enableTexture();
        }
    }
}

