/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.entity.SpeedboatEntity;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.IPItemStackHandler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SpeedboatItem
extends IPItemBase
implements IUpgradeableTool {
    static final String Upgrade_Type = "BOAT";

    public SpeedboatItem(String name) {
        super(name, new Item.Properties().func_200917_a(1).func_200916_a(ImmersivePetroleum.creativeTab));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new IPItemStackHandler();
    }

    public CompoundNBT getUpgrades(ItemStack stack) {
        return ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"upgrades");
    }

    public void clearUpgrades(ItemStack stack) {
        ItemNBTHelper.remove((ItemStack)stack, (String)"upgrades");
    }

    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    public boolean canModify(ItemStack stack) {
        return true;
    }

    public void recalculateUpgrades(ItemStack stack, World w, PlayerEntity player) {
        this.clearUpgrades(stack);
        CompoundNBT upgradeTag = (CompoundNBT)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(handler -> {
            CompoundNBT nbt = new CompoundNBT();
            for (int i = 0; i < handler.getSlots(); ++i) {
                IUpgrade upg;
                ItemStack u = handler.getStackInSlot(i);
                if (u.func_190926_b() || !(u.func_77973_b() instanceof IUpgrade) || !(upg = (IUpgrade)u.func_77973_b()).getUpgradeTypes(u).contains(Upgrade_Type) || !upg.canApplyUpgrades(stack, u)) continue;
                upg.applyUpgrades(stack, u, nbt);
            }
            return nbt;
        }).orElse(null);
        if (upgradeTag != null) {
            ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"upgrades", (CompoundNBT)upgradeTag);
        }
        this.finishUpgradeRecalculation(stack);
    }

    public void removeFromWorkbench(PlayerEntity player, ItemStack stack) {
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        float f8;
        float f6;
        float f5;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        float f1 = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C) * 1.0f;
        float f2 = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B) * 1.0f;
        double d0 = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q) * 1.0;
        double d1 = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) * 1.0 + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s) * 1.0;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180))));
        Vec3d vec3d1 = vec3d.func_72441_c((double)f7 * 5.0, (double)(f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)))) * 5.0, (double)(f8 = f3 * f5) * 5.0);
        BlockRayTraceResult raytraceresult = worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)playerIn));
        if (raytraceresult != null) {
            Vec3d vec3d2 = playerIn.func_70676_i(1.0f);
            boolean flag = false;
            AxisAlignedBB bb = playerIn.func_70046_E();
            if (bb == null) {
                bb = playerIn.func_174813_aQ();
            }
            if (bb != null) {
                List list = worldIn.func_72839_b((Entity)playerIn, bb.func_72321_a(vec3d2.field_72450_a * 5.0, vec3d2.field_72448_b * 5.0, vec3d2.field_72449_c * 5.0).func_186662_g(1.0));
                for (int i = 0; i < list.size(); ++i) {
                    AxisAlignedBB axisalignedbb;
                    Entity entity = (Entity)list.get(i);
                    if (!entity.func_70067_L() || (axisalignedbb = entity.func_70046_E()) == null || !axisalignedbb.func_186662_g((double)entity.func_70111_Y()).func_72318_a(vec3d)) continue;
                    flag = true;
                }
            }
            if (flag) {
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
            Vec3d hit = raytraceresult.func_216347_e();
            Block block = worldIn.func_180495_p(new BlockPos(hit.func_72441_c(0.0, 0.5, 0.0))).func_177230_c();
            boolean flag1 = block == Blocks.field_150355_j;
            SpeedboatEntity entityboat = new SpeedboatEntity(worldIn, hit.field_72450_a, flag1 ? hit.field_72448_b - 0.12 : hit.field_72448_b, hit.field_72449_c);
            entityboat.field_70177_z = playerIn.field_70177_z;
            entityboat.setUpgrades(this.getContainedItems(itemstack));
            entityboat.readTank(itemstack.func_77978_p());
            if (worldIn.func_223438_b((Entity)entityboat, entityboat.func_70046_E().func_186662_g(-0.1)).findFirst().isPresent()) {
                return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_217376_c((Entity)entityboat);
            }
            if (!playerIn.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemstack);
    }

    protected NonNullList<ItemStack> getContainedItems(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        if (handler == null) {
            ImmersivePetroleum.log.info("No valid inventory handler found for " + stack);
            return NonNullList.func_191196_a();
        }
        if (handler instanceof IPItemStackHandler) {
            return ((IPItemStackHandler)handler).getContainedItems();
        }
        ImmersivePetroleum.log.warn("Inefficiently getting contained items. Why does " + stack + " have a non-IE IItemHandler?");
        NonNullList inv = NonNullList.func_191197_a((int)handler.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < handler.getSlots(); ++i) {
            inv.set(i, (Object)handler.getStackInSlot(i));
        }
        return inv;
    }

    public void finishUpgradeRecalculation(ItemStack stack) {
    }

    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (inv != null) {
            return new Slot[]{new IESlot.Upgrades(container, inv, 0, 78, 30, Upgrade_Type, stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 1, 98, 40, Upgrade_Type, stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 2, 118, 30, Upgrade_Type, stack, true, getWorld, getPlayer)};
        }
        return new Slot[0];
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IItemHandler handler;
        FluidStack fs;
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"tank") && (fs = FluidStack.loadFluidStackFromNBT((CompoundNBT)ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"tank"))) != null) {
            tooltip.add(fs.getDisplayName().func_150258_a(": " + fs.getAmount() + "mB").func_211708_a(TextFormatting.GRAY));
        }
        if ((handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null)) != null && handler instanceof IPItemStackHandler) {
            boolean first = true;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack upgrade = handler.getStackInSlot(i);
                if (upgrade == null || upgrade == ItemStack.field_190927_a) continue;
                if (first) {
                    tooltip.add(new TranslationTextComponent("desc.immersivepetroleum.flavour.speedboat0", new Object[0]).func_211708_a(TextFormatting.GRAY));
                }
                tooltip.add(new StringTextComponent("  ").func_150257_a(upgrade.func_200301_q()).func_211708_a(TextFormatting.DARK_GRAY));
                first = false;
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

