/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.lubehandlers;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ExcavatorTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.ModelLubricantPipes;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.metal.AutoLubricatorTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExcavatorLubricationHandler
implements LubricatedHandler.ILubricationHandler<ExcavatorTileEntity> {
    private static Vec3i size = new Vec3i(3, 6, 3);
    private static ModelLubricantPipes.Excavator excavator;
    private static ModelLubricantPipes.Excavator excavatorM;

    @Override
    public Vec3i getStructureDimensions() {
        return size;
    }

    @Override
    public boolean isMachineEnabled(World world, ExcavatorTileEntity mbte) {
        BlockPos wheelPos = mbte.getWheelCenterPos();
        TileEntity center = world.func_175625_s(wheelPos);
        if (center instanceof BucketWheelTileEntity) {
            BucketWheelTileEntity wheel = (BucketWheelTileEntity)center;
            if (!wheel.offsetToMaster.equals((Object)BlockPos.field_177992_a)) {
                wheel = (BucketWheelTileEntity)wheel.master();
            }
            return wheel.active;
        }
        return false;
    }

    @Override
    public TileEntity isPlacedCorrectly(World world, AutoLubricatorTileEntity lubricator, Direction facing) {
        ExcavatorTileEntity master;
        BlockPos target = lubricator.func_174877_v().func_177972_a(facing);
        TileEntity te = world.func_175625_s(target);
        if (te instanceof ExcavatorTileEntity && (master = (ExcavatorTileEntity)((ExcavatorTileEntity)te).master()) != null) {
            Direction dir;
            Direction direction = dir = master.getIsMirrored() ? master.getFacing().func_176746_e() : master.getFacing().func_176735_f();
            if (dir == facing) {
                return master;
            }
        }
        return null;
    }

    @Override
    public void lubricate(World world, int ticks, ExcavatorTileEntity mbte) {
        BlockPos wheelPos = mbte.getWheelCenterPos();
        TileEntity center = world.func_175625_s(wheelPos);
        if (center instanceof BucketWheelTileEntity) {
            BucketWheelTileEntity wheel = (BucketWheelTileEntity)center;
            if (!wheel.offsetToMaster.equals((Object)BlockPos.field_177992_a)) {
                wheel = (BucketWheelTileEntity)wheel.master();
            }
            if (!world.field_72995_K && ticks % 4 == 0) {
                int consumed = (Integer)IEConfig.MACHINES.excavator_consumption.get();
                int extracted = mbte.energyStorage.extractEnergy(consumed, true);
                if (extracted >= consumed) {
                    mbte.energyStorage.extractEnergy(extracted, false);
                    wheel.rotation = (float)((double)wheel.rotation + (Double)IEConfig.MACHINES.excavator_speed.get() / 4.0);
                }
            } else {
                wheel.rotation = (float)((double)wheel.rotation + (Double)IEConfig.MACHINES.excavator_speed.get() / 4.0);
            }
        }
    }

    @Override
    public void spawnLubricantParticles(World world, AutoLubricatorTileEntity lubricator, Direction facing, ExcavatorTileEntity mbte) {
        Direction f = mbte.getIsMirrored() ? facing : facing.func_176734_d();
        float location = world.field_73012_v.nextFloat();
        boolean flip = f.func_176740_k() == Direction.Axis.Z ^ facing.func_176743_c() == Direction.AxisDirection.POSITIVE ^ !mbte.getIsMirrored();
        float xO = 1.2f;
        float zO = -0.5f;
        float yO = 0.5f;
        if (location > 0.5f) {
            xO = 0.9f;
            yO = 0.8f;
            zO = 1.75f;
        }
        if (facing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            xO = -xO + 1.0f;
        }
        if (!flip) {
            zO = -zO + 1.0f;
        }
        float x = (float)lubricator.func_174877_v().func_177958_n() + (f.func_176740_k() == Direction.Axis.X ? xO : zO);
        float y = (float)lubricator.func_174877_v().func_177956_o() + yO;
        float z = (float)lubricator.func_174877_v().func_177952_p() + (f.func_176740_k() == Direction.Axis.X ? zO : xO);
        for (int i = 0; i < 3; ++i) {
            float r1 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float r2 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float r3 = world.field_73012_v.nextFloat();
            BlockState n = IPContent.Fluids.lubricant.block.func_176223_P();
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, n), (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPipes(World world, AutoLubricatorTileEntity lubricator, Direction facing, ExcavatorTileEntity mbte) {
        if (excavator == null) {
            excavatorM = new ModelLubricantPipes.Excavator(true);
            excavator = new ModelLubricantPipes.Excavator(false);
        }
        GlStateManager.translatef((float)0.0f, (float)-1.0f, (float)0.0f);
        BlockPos offset = mbte.func_174877_v().func_177973_b((Vec3i)lubricator.func_174877_v());
        GlStateManager.translatef((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p());
        Direction rotation = mbte.getFacing();
        switch (rotation) {
            case NORTH: {
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-1.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-2.0f);
                break;
            }
            case EAST: {
                GlStateManager.rotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-1.0f, (float)0.0f, (float)-2.0f);
                break;
            }
        }
        ClientUtils.bindTexture((String)"immersivepetroleum:textures/block/lube_pipe12.png");
        if (mbte.getIsMirrored()) {
            excavatorM.render(0.0625f);
        } else {
            excavator.render(0.0625f);
        }
    }

    @Override
    public Tuple<BlockPos, Direction> getGhostBlockPosition(World world, ExcavatorTileEntity mbte) {
        if (!mbte.isDummy()) {
            BlockPos pos = mbte.func_174877_v().func_177967_a(mbte.getFacing(), 4).func_177967_a(mbte.getIsMirrored() ? mbte.getFacing().func_176735_f() : mbte.getFacing().func_176746_e(), 2);
            Direction f = mbte.getIsMirrored() ? mbte.getFacing().func_176746_e() : mbte.getFacing().func_176735_f();
            return new Tuple((Object)pos, (Object)f);
        }
        return null;
    }
}

