/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.lubehandlers;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.ModelLubricantPipes;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.metal.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.metal.PumpjackTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PumpjackLubricationHandler
implements LubricatedHandler.ILubricationHandler<PumpjackTileEntity> {
    private static Vec3i size = new Vec3i(4, 6, 3);
    private static ModelLubricantPipes.Pumpjack pumpjackM;
    private static ModelLubricantPipes.Pumpjack pumpjack;

    @Override
    public Vec3i getStructureDimensions() {
        return size;
    }

    @Override
    public boolean isMachineEnabled(World world, PumpjackTileEntity mbte) {
        return mbte.wasActive;
    }

    @Override
    public TileEntity isPlacedCorrectly(World world, AutoLubricatorTileEntity lubricator, Direction facing) {
        PumpjackTileEntity master;
        BlockPos target = lubricator.func_174877_v().func_177972_a(facing);
        TileEntity te = world.func_175625_s(target);
        if (te instanceof PumpjackTileEntity && (master = (PumpjackTileEntity)((PumpjackTileEntity)te).master()) != null) {
            Direction f;
            Direction direction = f = master.getIsMirrored() ? facing : facing.func_176734_d();
            if (master.getFacing().func_176746_e() == f) {
                return master;
            }
        }
        return null;
    }

    @Override
    public void lubricate(World world, int ticks, PumpjackTileEntity mbte) {
        if (!world.field_72995_K) {
            if (ticks % 4 == 0) {
                mbte.func_73660_a();
            }
        } else {
            mbte.activeTicks += 0.25f;
        }
    }

    @Override
    public void spawnLubricantParticles(World world, AutoLubricatorTileEntity lubricator, Direction facing, PumpjackTileEntity mbte) {
        Direction f = mbte.getIsMirrored() ? facing : facing.func_176734_d();
        float location = world.field_73012_v.nextFloat();
        boolean flip = f.func_176740_k() == Direction.Axis.Z ^ facing.func_176743_c() == Direction.AxisDirection.POSITIVE ^ !mbte.getIsMirrored();
        float xO = 2.5f;
        float zO = -0.15f;
        float yO = 2.25f;
        if (location > 0.5f) {
            xO = 1.7f;
            yO = 2.9f;
            zO = -1.5f;
        }
        if (facing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            xO = -xO + 1.0f;
        }
        if (!flip) {
            zO = -zO + 1.0f;
        }
        float x = (float)lubricator.func_174877_v().func_177958_n() + (f.func_176740_k() == Direction.Axis.X ? xO : zO);
        float y = (float)lubricator.func_174877_v().func_177956_o() + yO;
        float z = (float)lubricator.func_174877_v().func_177952_p() + (f.func_176740_k() == Direction.Axis.X ? zO : xO);
        for (int i = 0; i < 3; ++i) {
            float r1 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float r2 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float r3 = world.field_73012_v.nextFloat();
            BlockState n = IPContent.Fluids.lubricant.block.func_176223_P();
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, n), (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPipes(World world, AutoLubricatorTileEntity lubricator, Direction facing, PumpjackTileEntity mbte) {
        if (pumpjackM == null) {
            pumpjackM = new ModelLubricantPipes.Pumpjack(true);
            pumpjack = new ModelLubricantPipes.Pumpjack(false);
        }
        GlStateManager.translatef((float)0.0f, (float)-1.0f, (float)0.0f);
        BlockPos offset = mbte.func_174877_v().func_177973_b((Vec3i)lubricator.func_174877_v());
        GlStateManager.translatef((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p());
        Direction rotation = mbte.getFacing();
        switch (rotation) {
            case NORTH: {
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-6.0f, (float)1.0f, (float)-1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-5.0f, (float)1.0f, (float)-2.0f);
                break;
            }
            case EAST: {
                GlStateManager.rotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-5.0f, (float)1.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-6.0f, (float)1.0f, (float)-2.0f);
                break;
            }
        }
        ClientUtils.bindTexture((String)"immersivepetroleum:textures/block/lube_pipe12.png");
        if (mbte.getIsMirrored()) {
            pumpjackM.render(0.0625f);
        } else {
            pumpjack.render(0.0625f);
        }
    }

    @Override
    public Tuple<BlockPos, Direction> getGhostBlockPosition(World world, PumpjackTileEntity mbte) {
        if (!mbte.isDummy()) {
            Direction mbFacing = mbte.getFacing().func_176734_d();
            BlockPos pos = mbte.func_174877_v().func_177972_a(Direction.UP).func_177967_a(mbFacing, 4).func_177967_a(mbte.getIsMirrored() ? mbFacing.func_176746_e() : mbFacing.func_176735_f(), 2);
            Direction f = mbte.getIsMirrored() ? mbte.getFacing().func_176734_d() : mbte.getFacing();
            return new Tuple((Object)pos, (Object)f);
        }
        return null;
    }
}

