/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import blusunrize.immersiveengineering.common.network.IMessage;
import flaxbeard.immersivepetroleum.common.network.MessageCloseBook;
import flaxbeard.immersivepetroleum.common.network.MessageConsumeBoatFuel;
import flaxbeard.immersivepetroleum.common.network.MessageDebugSync;
import flaxbeard.immersivepetroleum.common.network.MessageRotateSchematic;
import flaxbeard.immersivepetroleum.common.network.MessageSyncReservoirs;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class IPPacketHandler {
    public static final String NET_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("immersivepetroleum", "main")).networkProtocolVersion(() -> "1").serverAcceptedVersions("1"::equals).clientAcceptedVersions("1"::equals).simpleChannel();
    private static int id = 0;

    public static void preInit() {
        IPPacketHandler.registerMessage(MessageDebugSync.class, MessageDebugSync::new);
        IPPacketHandler.registerMessage(MessageCloseBook.class, MessageCloseBook::new);
        IPPacketHandler.registerMessage(MessageRotateSchematic.class, MessageRotateSchematic::new);
        IPPacketHandler.registerMessage(MessageSyncReservoirs.class, MessageSyncReservoirs::new);
        IPPacketHandler.registerMessage(MessageConsumeBoatFuel.class, MessageConsumeBoatFuel::new);
    }

    public static <T extends IMessage> void registerMessage(Class<T> type, Function<PacketBuffer, T> decoder) {
        INSTANCE.registerMessage(id++, type, IMessage::toBytes, decoder, (t, ctx) -> {
            t.process(ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static <MSG> void sendToPlayer(PlayerEntity player, MSG message) {
        if (message == null || !(player instanceof ServerPlayerEntity)) {
            return;
        }
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), message);
    }

    public static <MSG> void sendToServer(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.SERVER.noArg(), message);
    }

    public static <MSG> void sendToDimension(DimensionType dim, MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> dim), message);
    }

    public static <MSG> void sendAll(MSG message) {
        if (message == null) {
            return;
        }
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }
}

