/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import blusunrize.immersiveengineering.common.network.IMessage;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncReservoirs
implements IMessage {
    final Map<ResourceLocation, PumpjackHandler.ReservoirType> map = new HashMap<ResourceLocation, PumpjackHandler.ReservoirType>();

    public MessageSyncReservoirs(HashMap<ResourceLocation, PumpjackHandler.ReservoirType> map) {
        for (Map.Entry<ResourceLocation, PumpjackHandler.ReservoirType> e : map.entrySet()) {
            this.map.put(e.getKey(), e.getValue());
        }
    }

    public MessageSyncReservoirs(PacketBuffer buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation loc = new ResourceLocation(buf.func_218666_n());
            PumpjackHandler.ReservoirType type = new PumpjackHandler.ReservoirType(buf.func_150793_b());
            this.map.put(loc, type);
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.map.size());
        for (Map.Entry<ResourceLocation, PumpjackHandler.ReservoirType> e : this.map.entrySet()) {
            buf.func_180714_a(e.getKey().toString());
            buf.func_150786_a(e.getValue().writeToNBT());
        }
    }

    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            NetworkEvent.Context con = (NetworkEvent.Context)context.get();
            if (con.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ImmersivePetroleum.log.info("Received SyncReservoirs Message.");
                PumpjackHandler.reservoirs.clear();
                for (Map.Entry<ResourceLocation, PumpjackHandler.ReservoirType> e : this.map.entrySet()) {
                    PumpjackHandler.reservoirs.put(e.getKey(), e.getValue());
                }
                PumpjackHandler.recalculateChances(true);
                ImmersivePetroleum.log.info("Reservoirs Synced.");
            }
        });
    }
}

