/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ReservoirCommand {
    private ReservoirCommand() {
    }

    public static LiteralArgumentBuilder<CommandSource> create() {
        LiteralArgumentBuilder lab = (LiteralArgumentBuilder)Commands.func_197057_a((String)"reservoir").requires(source -> source.func_197034_c(4));
        lab.then(Commands.func_197057_a((String)"list").executes(source -> ReservoirCommand.list(((CommandSource)source.getSource()).func_197035_h())));
        lab.then(Commands.func_197057_a((String)"get").executes(source -> ReservoirCommand.get(((CommandSource)source.getSource()).func_197035_h())));
        lab.then(ReservoirCommand.setReservoir());
        lab.then(Commands.func_197057_a((String)"setAmount").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> ReservoirCommand.setAmount(((CommandSource)context.getSource()).func_197035_h(), (Integer)context.getArgument("amount", Integer.class)))));
        lab.then(Commands.func_197057_a((String)"setCapacity").then(Commands.func_197056_a((String)"capacity", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> ReservoirCommand.setCapacity(((CommandSource)context.getSource()).func_197035_h(), (Integer)context.getArgument("capacity", Integer.class)))));
        return lab;
    }

    static int list(ServerPlayerEntity playerEntity) {
        String s = "";
        int i = 0;
        for (PumpjackHandler.ReservoirType res : PumpjackHandler.reservoirs.values()) {
            s = s + (i++ > 0 ? ", " : "") + res.name;
        }
        playerEntity.func_145747_a((ITextComponent)new StringTextComponent(s));
        return 1;
    }

    static int get(ServerPlayerEntity playerEntity) {
        PumpjackHandler.OilWorldInfo info = ReservoirCommand.getOilWorldInfo(playerEntity);
        String h = I18n.func_135052_a((String)"chat.immersivepetroleum.command.reservoir.get", (Object[])new Object[]{TextFormatting.GOLD + (info.type != null ? info.type.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + (info.overrideType != null ? info.overrideType.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + info.current + "/" + info.capacity + " mB" + TextFormatting.RESET});
        for (String g : h.split("<br>")) {
            playerEntity.func_145747_a((ITextComponent)new StringTextComponent(g));
        }
        return 1;
    }

    static LiteralArgumentBuilder<CommandSource> setReservoir() {
        RequiredArgumentBuilder nameArg = Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string());
        nameArg.suggests((context, builder) -> ISuggestionProvider.func_197013_a(PumpjackHandler.reservoirs.values().stream().map(type -> type.name), (SuggestionsBuilder)builder)).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            ReservoirCommand.setReservoir((CommandContext<CommandSource>)command, player.func_180425_c().func_177958_n() >> 4, player.func_180425_c().func_177952_p() >> 4);
            return 1;
        });
        nameArg.then(Commands.func_197056_a((String)"location", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(command -> {
            ColumnPos pos = (ColumnPos)command.getArgument("location", ColumnPos.class);
            ReservoirCommand.setReservoir((CommandContext<CommandSource>)command, pos.field_219439_a, pos.field_219440_b);
            return 1;
        }));
        LiteralArgumentBuilder set = Commands.func_197057_a((String)"setTest");
        set.then((ArgumentBuilder)nameArg);
        return set;
    }

    static void setReservoir(CommandContext<CommandSource> context, int xChunk, int zChunk) {
        CommandSource sender = (CommandSource)context.getSource();
        PumpjackHandler.OilWorldInfo info = PumpjackHandler.getOrCreateOilWorldInfo((World)sender.func_197023_e(), xChunk, zChunk);
        String name = (String)context.getArgument("name", String.class);
        PumpjackHandler.ReservoirType reservoir = null;
        for (PumpjackHandler.ReservoirType res : PumpjackHandler.reservoirs.values()) {
            if (!res.name.equalsIgnoreCase(name)) continue;
            reservoir = res;
        }
        if (reservoir == null) {
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.set.invalidReservoir", new Object[]{name}), true);
            return;
        }
        info.overrideType = reservoir;
        IPSaveData.setDirty();
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.set.sucess", new Object[]{reservoir.name}), true);
    }

    static int set(ServerPlayerEntity playerEntity, String name) {
        PumpjackHandler.OilWorldInfo info = ReservoirCommand.getOilWorldInfo(playerEntity);
        PumpjackHandler.ReservoirType reservoir = null;
        for (PumpjackHandler.ReservoirType res : PumpjackHandler.reservoirs.values()) {
            if (!res.name.equalsIgnoreCase(name)) continue;
            reservoir = res;
        }
        if (reservoir == null) {
            playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.set.invalidReservoir", new Object[]{name}));
            return 1;
        }
        info.overrideType = reservoir;
        playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.set.sucess", new Object[]{reservoir.name}));
        IPSaveData.setDirty();
        return 1;
    }

    static int setAmount(ServerPlayerEntity playerEntity, int amount) {
        PumpjackHandler.OilWorldInfo info = ReservoirCommand.getOilWorldInfo(playerEntity);
        info.current = amount = Math.min(info.capacity, Math.max(0, amount));
        playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.setAmount.sucess", new Object[]{Integer.toString(amount)}));
        IPSaveData.setDirty();
        return 1;
    }

    static int setCapacity(ServerPlayerEntity playerEntity, int amount) {
        PumpjackHandler.OilWorldInfo info = ReservoirCommand.getOilWorldInfo(playerEntity);
        info.capacity = amount = Math.max(0, amount);
        playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersivepetroleum.command.reservoir.setCapacity.sucess", new Object[]{Integer.toString(amount)}));
        IPSaveData.setDirty();
        return 1;
    }

    static PumpjackHandler.OilWorldInfo getOilWorldInfo(ServerPlayerEntity playerEntity) {
        ChunkPos coords = new ChunkPos(playerEntity.func_180425_c());
        return PumpjackHandler.getOrCreateOilWorldInfo(playerEntity.func_130014_f_(), coords.field_77276_a, coords.field_77275_b);
    }

    static ChunkPos getChunkCoords(ServerPlayerEntity playerEntity) {
        return new ChunkPos(playerEntity.func_180425_c());
    }

    @Deprecated
    static String getHelp(String subIdent) {
        return "chat.immersivepetroleum.command.reservoir" + subIdent + ".help";
    }
}

