/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.common.util.compat.crafttweaker.TweakerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.immersivepetroleum.DistillationTower")
public class DistillationRecipeTweaker {
    @ZenCodeType.Method
    public static boolean remove(String recipeName) {
        List test = DistillationRecipe.recipes.keySet().stream().filter(loc -> loc.func_110623_a().contains(recipeName)).collect(Collectors.toList());
        if (test.size() > 1) {
            CraftTweakerAPI.logError((String)"\u00c2\u00a7cMultiple results for \"%s\"\u00c2\u00a7r", (Object[])new Object[]{recipeName});
        } else if (test.size() == 1) {
            ResourceLocation id = (ResourceLocation)test.get(0);
            if (DistillationRecipe.recipes.containsKey(id)) {
                DistillationRecipe.recipes.remove(id);
                return true;
            }
            CraftTweakerAPI.logError((String)"\u00c2\u00a7c%s does not exist, or was already removed.\u00c2\u00a7r", (Object[])new Object[]{id});
        } else {
            CraftTweakerAPI.logInfo((String)"\"%s\" does not exist or could not be found.", (Object[])new Object[]{recipeName});
        }
        return false;
    }

    @ZenCodeType.Method
    public static void removeAll() {
        DistillationRecipe.recipes.clear();
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.immersivepetroleum.DistillationBuilder")
    public static class DistillationRecipeBuilder {
        private boolean isValid = true;
        private List<Tuple<ItemStack, Double>> byproducts = new ArrayList<Tuple<ItemStack, Double>>();
        private List<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        private Tag<Fluid> inputFluidTag = null;
        private int inputFluidAmount = 1;
        private int fluxEnergy = 2048;
        private int timeTicks = 1;

        @ZenCodeType.Constructor
        public DistillationRecipeBuilder() {
        }

        @ZenCodeType.Method
        public DistillationRecipeBuilder setOutputFluids(IFluidStack[] fluidsOutput) {
            if (fluidsOutput == null || fluidsOutput.length == 0) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cDistillationBuilder output fluids can not be null!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            } else {
                this.fluidOutputs = Arrays.asList(fluidsOutput).stream().map(f -> f.getInternal()).collect(Collectors.toList());
            }
            return this;
        }

        @ZenCodeType.Method
        public DistillationRecipeBuilder setInputFluid(MCTag tag, int amount) {
            if (tag.getFluidTag() == null) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cDistillationBuilder expected fluidtag as input fluid!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            } else if (amount <= 0) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7ccDistillationBuilder fluidtag amount must atleast be 1mB!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            } else {
                this.inputFluidTag = tag.getFluidTag();
                this.inputFluidAmount = amount;
            }
            return this;
        }

        @ZenCodeType.Method
        public DistillationRecipeBuilder addByproduct(IItemStack item, int chance) {
            return this.addByproduct(item, (double)chance / 100.0);
        }

        @ZenCodeType.Method
        public DistillationRecipeBuilder addByproduct(IItemStack item, double chance) {
            if (item == null) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cByproduct item can not be null!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            } else {
                chance = Math.max(Math.min(chance, 1.0), 0.0);
                this.byproducts.add((Tuple<ItemStack, Double>)new Tuple((Object)item.getInternal(), (Object)chance));
            }
            return this;
        }

        @ZenCodeType.Method
        public DistillationRecipeBuilder setEnergyAndTime(int flux, int ticks) {
            this.setEnergy(flux);
            this.setTime(ticks);
            return this;
        }

        @ZenCodeType.Method
        public DistillationRecipeBuilder setEnergy(int flux) {
            if (flux <= 0) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cEnergy usage must be atleast 1 flux/tick!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            } else {
                this.fluxEnergy = flux;
            }
            return this;
        }

        @ZenCodeType.Method
        public DistillationRecipeBuilder setTime(int ticks) {
            if (ticks <= 0) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cProcessing time must be atleast 1 tick!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            } else {
                this.timeTicks = ticks;
            }
            return this;
        }

        @ZenCodeType.Method
        public void build(String recipeName) {
            if (recipeName.isEmpty()) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cDistillation name can not be empty string!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            }
            FluidTagInput fluidInTag = null;
            if (this.inputFluidTag != null) {
                fluidInTag = new FluidTagInput(Lazy.of(() -> this.inputFluidTag), this.inputFluidAmount, null);
            } else {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cOutput fluid tag should not be null!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            }
            if (this.isValid) {
                ItemStack[] outStacks = new ItemStack[this.byproducts.size()];
                double[] chances = new double[this.byproducts.size()];
                if (!this.byproducts.isEmpty()) {
                    for (int i = 0; i < this.byproducts.size(); ++i) {
                        outStacks[i] = (ItemStack)this.byproducts.get(i).func_76341_a();
                        chances[i] = (Double)this.byproducts.get(i).func_76340_b();
                    }
                }
                FluidStack[] fluidOutStacks = new FluidStack[]{};
                if (!this.fluidOutputs.isEmpty()) {
                    fluidOutStacks = this.fluidOutputs.toArray(new FluidStack[0]);
                }
                ResourceLocation id = TweakerUtils.ctLoc("distillationtower/" + recipeName);
                DistillationRecipe recipe = new DistillationRecipe(id, fluidOutStacks, outStacks, fluidInTag, this.fluxEnergy, this.timeTicks, chances);
                DistillationRecipe.recipes.put(id, recipe);
            }
        }
    }
}

