/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.fluids;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPContent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class IPFluid
extends FlowingFluid {
    public static final List<IPFluid> LIST = new ArrayList<IPFluid>();
    protected final String fluidName;
    protected final ResourceLocation stillTexture;
    protected final ResourceLocation flowingTexture;
    protected IPFluid source;
    protected IPFluid flowing;
    public Block block;
    protected Item bucket;
    @Nullable
    protected final Consumer<FluidAttributes.Builder> buildAttributes;

    public IPFluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        this(name, stillTexture, flowingTexture, null, true);
    }

    public IPFluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable Consumer<FluidAttributes.Builder> buildAttributes) {
        this(name, stillTexture, flowingTexture, buildAttributes, true);
    }

    public IPFluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable Consumer<FluidAttributes.Builder> buildAttributes, boolean isSource) {
        this.fluidName = name;
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.buildAttributes = buildAttributes;
        IPContent.registeredIPFluids.add((Fluid)this);
        if (!isSource) {
            this.flowing = this;
            this.setRegistryName("immersivepetroleum", this.fluidName + "_flowing");
        } else {
            this.source = this;
            this.block = this.createBlock();
            this.block.setRegistryName(new ResourceLocation("immersivepetroleum", this.fluidName + "_fluid_block"));
            IPContent.registeredIPBlocks.add(this.block);
            this.bucket = this.createBucket();
            this.bucket.setRegistryName(new ResourceLocation("immersivepetroleum", this.fluidName + "_bucket"));
            IPContent.registeredIPItems.add(this.bucket);
            this.flowing = this.createFlowing();
            this.flowing.source = this;
            this.flowing.bucket = this.bucket;
            this.flowing.block = this.block;
            this.flowing.func_207183_f((IFluidState)((IFluidState)this.flowing.func_207182_e().func_177621_b()).func_206870_a((IProperty)field_207210_b, (Comparable)Integer.valueOf(7)));
            this.setRegistryName(new ResourceLocation("immersivepetroleum", this.fluidName));
            LIST.add(this);
        }
    }

    protected BucketItem createBucket() {
        BucketItem bucket = new BucketItem(() -> this.source, new Item.Properties().func_200917_a(1).func_200916_a(ImmersivePetroleum.creativeTab)){

            public ItemStack getContainerItem(ItemStack itemStack) {
                return new ItemStack((IItemProvider)Items.field_151133_ar);
            }

            public boolean hasContainerItem(ItemStack stack) {
                return true;
            }

            public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
                return new FluidBucketWrapper(stack);
            }
        };
        return bucket;
    }

    protected IPFluid createFlowing() {
        IPFluid flowing = new IPFluid(this.fluidName, this.stillTexture, this.flowingTexture, this.buildAttributes, false){

            protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
                super.func_207184_a(builder);
                builder.func_206894_a(new IProperty[]{field_207210_b});
            }
        };
        return flowing;
    }

    protected FlowingFluidBlock createBlock() {
        FlowingFluidBlock block = new FlowingFluidBlock(() -> this.source, Block.Properties.func_200945_a((Material)Material.field_151586_h)){

            protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(IPFluid.this.func_207182_e().func_177623_d().toArray(new IProperty[0]));
            }

            public IFluidState func_204507_t(BlockState state) {
                IFluidState baseState = super.func_204507_t(state);
                for (IProperty prop : IPFluid.this.func_207182_e().func_177623_d()) {
                    if (prop == FlowingFluidBlock.field_176367_b) continue;
                    baseState = this.withCopiedValue((IProperty)prop, (IStateHolder)baseState, (IStateHolder<?>)state);
                }
                return baseState;
            }

            private <T extends IStateHolder<T>, S extends Comparable<S>> T withCopiedValue(IProperty<S> prop, T oldState, IStateHolder<?> copyFrom) {
                return (T)((IStateHolder)oldState.func_206870_a(prop, copyFrom.func_177229_b(prop)));
            }
        };
        return block;
    }

    protected void func_205580_a(IWorld arg0, BlockPos arg1, BlockState arg2) {
    }

    protected boolean func_205579_d() {
        return false;
    }

    public Fluid func_210197_e() {
        return this.flowing;
    }

    public Fluid func_210198_f() {
        return this.source;
    }

    public Item func_204524_b() {
        return this.bucket;
    }

    protected int func_204528_b(IWorldReader arg0) {
        return 1;
    }

    protected int func_185698_b(IWorldReader arg0) {
        return 4;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    protected boolean func_215665_a(IFluidState p_215665_1_, IBlockReader p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return p_215665_5_ == Direction.DOWN && !this.func_207187_a(p_215665_4_);
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return 5;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    protected BlockState func_204527_a(IFluidState state) {
        return (BlockState)this.block.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(IPFluid.func_207205_e((IFluidState)state)));
    }

    public boolean func_207193_c(IFluidState state) {
        return state.func_206886_c() == this.source;
    }

    public int func_207192_d(IFluidState state) {
        if (this.func_207193_c(state)) {
            return 8;
        }
        return (Integer)state.func_177229_b((IProperty)field_207210_b);
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == this.source || fluidIn == this.flowing;
    }

    public static Consumer<FluidAttributes.Builder> createBuilder(int density, int viscosity) {
        return builder -> builder.viscosity(viscosity).density(density);
    }

    protected FluidAttributes createAttributes() {
        FluidAttributes.Builder builder = FluidAttributes.builder((ResourceLocation)this.stillTexture, (ResourceLocation)this.flowingTexture);
        if (this.buildAttributes != null) {
            this.buildAttributes.accept(builder);
        }
        return builder.build((Fluid)this);
    }
}

