/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa;

import com.github.sniffity.panthalassa.config.PanthalassaClientConfig;
import com.github.sniffity.panthalassa.config.PanthalassaCommonConfig;
import com.github.sniffity.panthalassa.server.entity.creature.EntityAcrolepis;
import com.github.sniffity.panthalassa.server.entity.creature.EntityAnglerfish;
import com.github.sniffity.panthalassa.server.entity.creature.EntityAnomalocaris;
import com.github.sniffity.panthalassa.server.entity.creature.EntityArchelon;
import com.github.sniffity.panthalassa.server.entity.creature.EntityBasilosaurus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityCeratodus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityCoelacanth;
import com.github.sniffity.panthalassa.server.entity.creature.EntityDunkleosteus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityGiantOrthocone;
import com.github.sniffity.panthalassa.server.entity.creature.EntityHelicoprion;
import com.github.sniffity.panthalassa.server.entity.creature.EntityKronosaurus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityLeedsichthys;
import com.github.sniffity.panthalassa.server.entity.creature.EntityMegalodon;
import com.github.sniffity.panthalassa.server.entity.creature.EntityMosasaurus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityThalassomedon;
import com.github.sniffity.panthalassa.server.entity.display.PanthalassaDisplayEntity;
import com.github.sniffity.panthalassa.server.network.PanthalassaPacketHandler;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlockEntities;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEffects;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import com.github.sniffity.panthalassa.server.registry.PanthalassaFeatures;
import com.github.sniffity.panthalassa.server.registry.PanthalassaItemGroup;
import com.github.sniffity.panthalassa.server.registry.PanthalassaItems;
import com.github.sniffity.panthalassa.server.registry.PanthalassaPOI;
import com.github.sniffity.panthalassa.server.registry.PanthalassaParticlesTypes;
import com.github.sniffity.panthalassa.server.registry.PanthalassaProcessors;
import com.github.sniffity.panthalassa.server.registry.PanthalassaSounds;
import com.github.sniffity.panthalassa.server.registry.PanthalassaStructures;
import com.github.sniffity.panthalassa.server.world.spawn.PanthalassaSpawns;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="panthalassa")
@Mod.EventBusSubscriber(modid="panthalassa", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Panthalassa {
    public static final String MODID = "panthalassa";
    public static final Logger LOGGER = LogManager.getLogger();

    public Panthalassa() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, PanthalassaDimension::worldTick);
        modBus.addListener(this::setup);
        modBus.addListener(this::registerEntityAttributes);
        PanthalassaBlockEntities.BLOCK_ENTITY_TYPES.register(modBus);
        PanthalassaEntityTypes.ENTITY_TYPES.register(modBus);
        PanthalassaItems.ITEMS.register(modBus);
        PanthalassaBlocks.BLOCKS.register(modBus);
        PanthalassaStructures.STRUCTURES.register(modBus);
        PanthalassaSounds.SOUND_EVENTS.register(modBus);
        PanthalassaPOI.POI.register(modBus);
        PanthalassaFeatures.FEATURES.register(modBus);
        PanthalassaEffects.EFFECTS.register(modBus);
        PanthalassaParticlesTypes.PARTICLE_TYPES.register(modBus);
        GeckoLib.initialize();
        forgeBus.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PanthalassaClientConfig.GENERAL_SPEC, "panthalassa-client-config.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PanthalassaCommonConfig.COMMON_CONFIG, "panthalassa-common-config.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        PanthalassaPacketHandler.register();
        event.enqueueWork(() -> {
            PanthalassaSpawns.registerSpawnPlacementTypes();
            PanthalassaProcessors.registerProcessors();
        });
    }

    @SubscribeEvent
    public void onBiomeLoading(BiomeLoadingEvent event) {
        PanthalassaSpawns.onBiomeLoading(event);
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)PanthalassaEntityTypes.KRONOSAURUS.get(), EntityKronosaurus.kronosaurusAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.MEGALODON.get(), EntityMegalodon.megalodonAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.ARCHELON.get(), EntityArchelon.archelonAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.MOSASAURUS.get(), EntityMosasaurus.mosasaurusAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.COELACANTH.get(), EntityCoelacanth.coelacanthAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.DUNKLEOSTEUS.get(), EntityDunkleosteus.dunkleosteusAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.LEEDSICHTHYS.get(), EntityLeedsichthys.leedsichthysAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.GIANT_ORTHOCONE.get(), EntityGiantOrthocone.giantOrthoconeAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.BASILOSAURUS.get(), EntityBasilosaurus.basilosaurusAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.THALASSOMEDON.get(), EntityThalassomedon.thalassomedonAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.ACROLEPIS.get(), EntityAcrolepis.acrolepisAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.CERATODUS.get(), EntityCeratodus.ceratodusAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.HELICOPRION.get(), EntityHelicoprion.helicoprionAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.ANGLERFISH.get(), EntityAnglerfish.anglerfishAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.ANOMALOCARIS.get(), EntityAnomalocaris.anomalocarisAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.GIANT_ORTHOCONE_SHELL.get(), PanthalassaDisplayEntity.displayAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.KRONOSAURUS_SKULL.get(), PanthalassaDisplayEntity.displayAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.ARCHELON_SHELL.get(), PanthalassaDisplayEntity.displayAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.MEGALODON_JAWS.get(), PanthalassaDisplayEntity.displayAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        RegistryObject[] exclusionArray = new RegistryObject[]{PanthalassaBlocks.PORTAL, PanthalassaBlocks.LIGHT_AIR, PanthalassaBlocks.LIGHT_WATER, PanthalassaBlocks.PANTHALASSA_WATER};
        List<RegistryObject> exclusionCollection = Arrays.asList(exclusionArray);
        PanthalassaBlocks.BLOCKS.getEntries().stream().filter(i -> !exclusionCollection.contains(i)).map(RegistryObject::get).forEach(block -> event.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(block, new Item.Properties().m_41491_(PanthalassaItemGroup.GROUP)).setRegistryName(block.getRegistryName()))));
    }
}

