/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.client;

import com.github.sniffity.panthalassa.client.events.CameraSetupEvent;
import com.github.sniffity.panthalassa.client.events.KeyInputEvent;
import com.github.sniffity.panthalassa.client.events.RenderTickEvent;
import com.github.sniffity.panthalassa.client.render.armor.RenderDivingSuit;
import com.github.sniffity.panthalassa.client.render.blockentity.RenderHydrothermalVent;
import com.github.sniffity.panthalassa.client.render.blockentity.RenderPressureEqualizer;
import com.github.sniffity.panthalassa.client.render.display.RenderArchelonShell;
import com.github.sniffity.panthalassa.client.render.display.RenderGiantOrthoconeShell;
import com.github.sniffity.panthalassa.client.render.display.RenderKronosaurusSkull;
import com.github.sniffity.panthalassa.client.render.display.RenderMegalodonJaws;
import com.github.sniffity.panthalassa.client.render.entity.RenderAcrolepis;
import com.github.sniffity.panthalassa.client.render.entity.RenderAnglerfish;
import com.github.sniffity.panthalassa.client.render.entity.RenderAnomalocaris;
import com.github.sniffity.panthalassa.client.render.entity.RenderArchelon;
import com.github.sniffity.panthalassa.client.render.entity.RenderBasilosaurus;
import com.github.sniffity.panthalassa.client.render.entity.RenderCeratodus;
import com.github.sniffity.panthalassa.client.render.entity.RenderCoelacanth;
import com.github.sniffity.panthalassa.client.render.entity.RenderDunkleosteus;
import com.github.sniffity.panthalassa.client.render.entity.RenderGiantOrthocone;
import com.github.sniffity.panthalassa.client.render.entity.RenderHelicoprion;
import com.github.sniffity.panthalassa.client.render.entity.RenderKronosaurus;
import com.github.sniffity.panthalassa.client.render.entity.RenderLeedsichthys;
import com.github.sniffity.panthalassa.client.render.entity.RenderMegalodon;
import com.github.sniffity.panthalassa.client.render.entity.RenderMosasaurus;
import com.github.sniffity.panthalassa.client.render.entity.RenderThalassomedon;
import com.github.sniffity.panthalassa.client.render.projectile.RenderBlastTorpedo;
import com.github.sniffity.panthalassa.client.render.projectile.RenderTranquilizingTorpedo;
import com.github.sniffity.panthalassa.client.render.vehicle.RenderAGII;
import com.github.sniffity.panthalassa.client.render.vehicle.RenderECSV;
import com.github.sniffity.panthalassa.client.render.vehicle.RenderMRSV;
import com.github.sniffity.panthalassa.client.render.vehicle.RenderPCSV;
import com.github.sniffity.panthalassa.server.item.armor.ItemDivingSuit;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlockEntities;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

@Mod.EventBusSubscriber(modid="panthalassa", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHandler {
    public static final KeyMapping KEY_VEHICLE_LIGHTS = new KeyMapping("key.vehicle.lights", 72, "key.panthalassa.category");
    public static final KeyMapping KEY_VEHICLE_SPECIAL = new KeyMapping("key.vehicle.special", 89, "key.panthalassa.category");
    public static final KeyMapping KEY_VEHICLE_SONAR = new KeyMapping("key.vehicle.sonar", 78, "key.panthalassa.category");

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputEvent());
        MinecraftForge.EVENT_BUS.register((Object)new RenderTickEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CameraSetupEvent());
        ClientHandler.registerKeybinds();
        ClientHandler.registerBlockColors();
        ClientHandler.registerItemColors();
        ClientHandler.registerBlockRenderers();
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.KRONOSAURUS.get(), RenderKronosaurus::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.MEGALODON.get(), RenderMegalodon::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.ARCHELON.get(), RenderArchelon::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.MOSASAURUS.get(), RenderMosasaurus::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.COELACANTH.get(), RenderCoelacanth::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.DUNKLEOSTEUS.get(), RenderDunkleosteus::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.LEEDSICHTHYS.get(), RenderLeedsichthys::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.GIANT_ORTHOCONE.get(), RenderGiantOrthocone::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.BASILOSAURUS.get(), RenderBasilosaurus::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.THALASSOMEDON.get(), RenderThalassomedon::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.ACROLEPIS.get(), RenderAcrolepis::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.CERATODUS.get(), RenderCeratodus::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.HELICOPRION.get(), RenderHelicoprion::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.ANGLERFISH.get(), RenderAnglerfish::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.ANOMALOCARIS.get(), RenderAnomalocaris::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.MRSV.get(), RenderMRSV::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.AGII.get(), RenderAGII::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.GIANT_ORTHOCONE_SHELL.get(), RenderGiantOrthoconeShell::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.KRONOSAURUS_SKULL.get(), RenderKronosaurusSkull::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.ARCHELON_SHELL.get(), RenderArchelonShell::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.MEGALODON_JAWS.get(), RenderMegalodonJaws::new);
        event.registerBlockEntityRenderer((BlockEntityType)PanthalassaBlockEntities.HYDROTHERMAL_VENT_TE.get(), RenderHydrothermalVent::new);
        event.registerBlockEntityRenderer((BlockEntityType)PanthalassaBlockEntities.PRESSURE_EQUALIZER_TE.get(), RenderPressureEqualizer::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.PCSV.get(), RenderPCSV::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.ECSV.get(), RenderECSV::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.BLAST_TORPEDO.get(), RenderBlastTorpedo::new);
        event.registerEntityRenderer((EntityType)PanthalassaEntityTypes.TRANQUILIZING_TORPEDO.get(), RenderTranquilizingTorpedo::new);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.AddLayers event) {
        GeoArmorRenderer.registerArmorRenderer(ItemDivingSuit.class, (GeoArmorRenderer)new RenderDivingSuit());
    }

    public static void registerKeybinds() {
        ClientRegistry.registerKeyBinding((KeyMapping)KEY_VEHICLE_LIGHTS);
        ClientRegistry.registerKeyBinding((KeyMapping)KEY_VEHICLE_SPECIAL);
        ClientRegistry.registerKeyBinding((KeyMapping)KEY_VEHICLE_SONAR);
    }

    private static void render(Supplier<? extends Block> block, RenderType render) {
        ItemBlockRenderTypes.setRenderLayer((Block)block.get(), (RenderType)render);
    }

    public static void registerBlockRenderers() {
        RenderType cutout = RenderType.m_110463_();
        RenderType mipped = RenderType.m_110457_();
        RenderType translucent = RenderType.m_110466_();
        ClientHandler.render(PanthalassaBlocks.KRETHROSS, cutout);
        ClientHandler.render(PanthalassaBlocks.KRETHROSS_PLANT, cutout);
        ClientHandler.render(PanthalassaBlocks.FROSTGRASS, cutout);
    }

    public static void registerBlockColors() {
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        colors.m_92589_((state, world, pos, tint) -> world != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos) : new Color(63, 101, 145).getRGB(), new Block[]{(Block)PanthalassaBlocks.KRETHROSS.get(), (Block)PanthalassaBlocks.KRETHROSS_PLANT.get(), (Block)PanthalassaBlocks.FROSTGRASS.get()});
    }

    public static void registerItemColors() {
        BlockColors bColors = Minecraft.m_91087_().m_91298_();
        ItemColors iColors = Minecraft.m_91087_().getItemColors();
        iColors.m_92689_((stack, tint) -> bColors.m_92577_(((BlockItem)stack.m_41720_()).m_40614_().m_49966_(), null, null, 0), new ItemLike[]{(ItemLike)PanthalassaBlocks.KRETHROSS.get(), (ItemLike)PanthalassaBlocks.KRETHROSS_PLANT.get(), (ItemLike)PanthalassaBlocks.FROSTGRASS.get()});
        iColors.m_92689_((stack, tint) -> {
            if (tint == 0) {
                return new Color(91, 117, 91).getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)PanthalassaBlocks.KRETHROSS.get(), ((GrowingPlantBlock)PanthalassaBlocks.KRETHROSS_PLANT.get()).m_5456_(), (ItemLike)PanthalassaBlocks.FROSTGRASS.get()});
    }
}

