/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.config;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;

public final class PanthalassaCommonConfig {
    public static ForgeConfigSpec COMMON_CONFIG;
    public static final Common COMMON;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    private static final Predicate<Object> STRING_PREDICATE;

    static {
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        STRING_PREDICATE = s -> s instanceof String;
        COMMON = new Common(COMMON_BUILDER);
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public static class Common {
        public final GeneralConfig GENERAL;
        public final EntitiesConfig ENTITIES;

        private Common(ForgeConfigSpec.Builder builder) {
            this.GENERAL = new GeneralConfig(builder);
            this.ENTITIES = new EntitiesConfig(builder);
        }
    }

    public static class EntitiesConfig {
        public final Kronosaurus KRONOSAURUS;
        public final Megalodon MEGALODON;
        public final Archelon ARCHELON;
        public final Mosasaurus MOSASAURUS;
        public final Coelacanth COELACANTH;
        public final Dunkleosteus DUNKLEOSTEUS;
        public final Leedischthys LEEDSICHTHYS;
        public final GiantOrthocone GIANT_ORTHOCONE;
        public final Basilosaurus BASILOSAURUS;
        public final Thalassomedon THALASSOMEDON;
        public final Acrolepis ACROLEPIS;
        public final Ceratodus CERATODUS;
        public final Helicoprion HELICOPRION;
        public final Anglerfish ANGLERFISH;
        public final Anomalocaris ANOMALOCARIS;

        EntitiesConfig(ForgeConfigSpec.Builder builder) {
            builder.push("entities");
            this.KRONOSAURUS = new Kronosaurus(builder);
            this.MEGALODON = new Megalodon(builder);
            this.ARCHELON = new Archelon(builder);
            this.MOSASAURUS = new Mosasaurus(builder);
            this.COELACANTH = new Coelacanth(builder);
            this.DUNKLEOSTEUS = new Dunkleosteus(builder);
            this.LEEDSICHTHYS = new Leedischthys(builder);
            this.GIANT_ORTHOCONE = new GiantOrthocone(builder);
            this.BASILOSAURUS = new Basilosaurus(builder);
            this.THALASSOMEDON = new Thalassomedon(builder);
            this.ACROLEPIS = new Acrolepis(builder);
            this.CERATODUS = new Ceratodus(builder);
            this.HELICOPRION = new Helicoprion(builder);
            this.ANGLERFISH = new Anglerfish(builder);
            this.ANOMALOCARIS = new Anomalocaris(builder);
            builder.pop();
        }
    }

    public static class Anomalocaris {
        public final ExternalSpawningConfig externalSpawning;

        Anomalocaris(ForgeConfigSpec.Builder builder) {
            builder.push("anomalocaris");
            this.externalSpawning = new ExternalSpawningConfig(builder, 3, 3, 5, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Anglerfish {
        public final ExternalSpawningConfig externalSpawning;

        Anglerfish(ForgeConfigSpec.Builder builder) {
            builder.push("anglerfish");
            this.externalSpawning = new ExternalSpawningConfig(builder, 3, 3, 5, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Helicoprion {
        public final ExternalSpawningConfig externalSpawning;

        Helicoprion(ForgeConfigSpec.Builder builder) {
            builder.push("helicoprion");
            this.externalSpawning = new ExternalSpawningConfig(builder, 3, 3, 5, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Ceratodus {
        public final ExternalSpawningConfig externalSpawning;

        Ceratodus(ForgeConfigSpec.Builder builder) {
            builder.push("ceratodus");
            this.externalSpawning = new ExternalSpawningConfig(builder, 3, 3, 5, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Acrolepis {
        public final ExternalSpawningConfig externalSpawning;

        Acrolepis(ForgeConfigSpec.Builder builder) {
            builder.push("acrolepis");
            this.externalSpawning = new ExternalSpawningConfig(builder, 3, 3, 5, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Thalassomedon {
        public final ExternalSpawningConfig externalSpawning;

        Thalassomedon(ForgeConfigSpec.Builder builder) {
            builder.push("thalassomedon");
            this.externalSpawning = new ExternalSpawningConfig(builder, 3, 1, 2, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Basilosaurus {
        public final ExternalSpawningConfig externalSpawning;

        Basilosaurus(ForgeConfigSpec.Builder builder) {
            builder.push("basilosaurus");
            this.externalSpawning = new ExternalSpawningConfig(builder, 3, 1, 2, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class GiantOrthocone {
        public final ExternalSpawningConfig externalSpawning;

        GiantOrthocone(ForgeConfigSpec.Builder builder) {
            builder.push("giant_orthocone");
            this.externalSpawning = new ExternalSpawningConfig(builder, 1, 1, 1, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Leedischthys {
        public final ExternalSpawningConfig externalSpawning;

        Leedischthys(ForgeConfigSpec.Builder builder) {
            builder.push("leedischthys");
            this.externalSpawning = new ExternalSpawningConfig(builder, 2, 1, 2, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Dunkleosteus {
        public final ExternalSpawningConfig externalSpawning;

        Dunkleosteus(ForgeConfigSpec.Builder builder) {
            builder.push("dunkleosteus");
            this.externalSpawning = new ExternalSpawningConfig(builder, 1, 1, 2, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Coelacanth {
        public final ExternalSpawningConfig externalSpawning;

        Coelacanth(ForgeConfigSpec.Builder builder) {
            builder.push("coelacanth");
            this.externalSpawning = new ExternalSpawningConfig(builder, 5, 3, 5, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Mosasaurus {
        public final ExternalSpawningConfig externalSpawning;

        Mosasaurus(ForgeConfigSpec.Builder builder) {
            builder.push("mosasaurus");
            this.externalSpawning = new ExternalSpawningConfig(builder, 1, 1, 1, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Archelon {
        public final ExternalSpawningConfig externalSpawning;

        Archelon(ForgeConfigSpec.Builder builder) {
            builder.push("archelon");
            this.externalSpawning = new ExternalSpawningConfig(builder, 3, 1, 2, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Megalodon {
        public final ExternalSpawningConfig externalSpawning;

        Megalodon(ForgeConfigSpec.Builder builder) {
            builder.push("megalodon");
            this.externalSpawning = new ExternalSpawningConfig(builder, 1, 1, 1, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class Kronosaurus {
        public final ExternalSpawningConfig externalSpawning;

        Kronosaurus(ForgeConfigSpec.Builder builder) {
            builder.push("kronosaurus");
            this.externalSpawning = new ExternalSpawningConfig(builder, 2, 1, 3, new BiomeSpawningConfig(builder, Collections.singletonList("minecraft:cold_ocean,minecraft:deep_cold_ocean,minecraft:deep_frozen_ocean,minecraft:deep_lukewarm_ocean,minecraft:deep_ocean,minecraft:frozen_ocean,minecraft:lukewarm_ocean,minecraft:ocean,minecraft:warm_ocean,minecraft:frozen_river,minecraft:river")));
            builder.pop();
        }
    }

    public static class BiomeSpawningConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> biomeWhitelist;

        BiomeSpawningConfig(ForgeConfigSpec.Builder builder, List<? extends String> biomeWhitelist) {
            builder.push("biome_config");
            this.biomeWhitelist = builder.comment("Allow spawns in these biomes").defineList("biome_whitelist", biomeWhitelist, STRING_PREDICATE);
            builder.pop();
        }
    }

    public static class ExternalSpawningConfig {
        public final ForgeConfigSpec.IntValue spawnRate;
        public final ForgeConfigSpec.IntValue minGroupSize;
        public final ForgeConfigSpec.IntValue maxGroupSize;
        public final BiomeSpawningConfig biomeSpawningConfig;

        ExternalSpawningConfig(ForgeConfigSpec.Builder builder, int spawnRate, int minGroupSize, int maxGroupSize, BiomeSpawningConfig biomeSpawningConfig) {
            builder.comment("This config will only take effect if external_spawning is set to TRUE");
            this.spawnRate = builder.comment("External Spawn Rates will be proportional to this value. Set to 0 to disable spawning").defineInRange("spawn_rate", spawnRate, 0, Integer.MAX_VALUE);
            this.minGroupSize = builder.comment("Minimum number of this entity that will spawn in each group").defineInRange("min_group_size", minGroupSize, 1, Integer.MAX_VALUE);
            this.maxGroupSize = builder.comment("Maximum number of this entity that will spawn in each group").defineInRange("max_group_size", maxGroupSize, 1, Integer.MAX_VALUE);
            this.biomeSpawningConfig = biomeSpawningConfig;
        }
    }

    public static class GeneralConfig {
        public final ForgeConfigSpec.BooleanValue giveJournal;
        public final ForgeConfigSpec.BooleanValue externalSpawningBoolean;
        public final ForgeConfigSpec.BooleanValue crushDepth;
        public final ForgeConfigSpec.BooleanValue randomSwimmingChecks;

        GeneralConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.giveJournal = builder.comment("This boolean value will determine whether or not the Panthalassa Journal (Guide Book) is given to players when they first join the server").define("give_journal", true);
            this.externalSpawningBoolean = builder.comment("This boolean value will determine whether Panthalassa's creatures spawn outside the Panthalassa Dimension").define("external_spawning", false);
            this.crushDepth = builder.comment("This boolean value will determine whether the crush depth mechanic is enabled within Panthalassa").define("crush_depth", false);
            this.randomSwimmingChecks = builder.comment("This boolean value will determine whether entities will try and avoid walls when randomly swimming").define("random_swimming_avoid", false);
            builder.pop();
        }
    }
}

