/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.block;

import com.github.sniffity.panthalassa.Panthalassa;
import com.github.sniffity.panthalassa.server.block.BlockPortalBlockEntity;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import com.github.sniffity.panthalassa.server.world.teleporter.PanthalassaTeleporter;
import com.github.sniffity.panthalassa.server.world.teleporter.TeleporterLogic;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockPortal
extends Block
implements EntityBlock {
    private static final VoxelShape portalShape = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public BlockPortal() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76298_, (MaterialColor)MaterialColor.f_76421_).m_60913_(-1.0f, 3600000.0f).m_60918_(SoundType.f_56744_).m_60953_(state -> 10).m_60977_());
    }

    public static void changeDimension(ServerLevel initialWorld, Entity entity, BlockPos portalBlockPos, PanthalassaTeleporter teleporter) {
        ServerLevel targetWorld;
        BlockEntity tileEntity = initialWorld.m_7702_(portalBlockPos);
        if (tileEntity instanceof BlockPortalBlockEntity) {
            BlockPortalBlockEntity portalTE = (BlockPortalBlockEntity)tileEntity;
            targetWorld = initialWorld.m_142572_().m_129880_(portalTE.destinationWorld);
            if (targetWorld != null && portalTE.destinationPos != null && targetWorld.m_8055_(portalTE.destinationPos).m_60713_((Block)PanthalassaBlocks.PORTAL.get())) {
                TeleporterLogic.teleport(entity, targetWorld, initialWorld, portalTE.destinationPos);
                return;
            }
        }
        ResourceKey<Level> targetWorldKey = initialWorld.m_46472_() == PanthalassaDimension.PANTHALASSA ? Level.f_46428_ : PanthalassaDimension.PANTHALASSA;
        targetWorld = initialWorld.m_142572_().m_129880_(targetWorldKey);
        if (targetWorld != null) {
            TeleporterLogic.teleportAndCreatePortal(entity, portalBlockPos, targetWorld, initialWorld, teleporter);
            entity.m_20091_();
        } else {
            Panthalassa.LOGGER.error("Panthalassa: Portal block is unable to find this dimension for teleporting to: {}", targetWorldKey);
        }
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BlockPortalBlockEntity(blockPos, blockState);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return 5.0f;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_() && this.trySpawnPortal(worldIn, pos)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return portalShape;
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean m_5946_(@Nonnull BlockState state, @Nonnull Fluid fluid) {
        return false;
    }

    public boolean trySpawnPortal(Level world, BlockPos pos) {
        matchShapeSize check = new matchShapeSize((LevelAccessor)world, pos);
        if (check.match) {
            check.createPortalCenter();
            return true;
        }
        return false;
    }

    public boolean tryDestoyPortal(Level world, BlockPos pos) {
        matchShapeSize check = new matchShapeSize((LevelAccessor)world, pos);
        if (check.match) {
            check.destroyPortalBlocks();
            return true;
        }
        return false;
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos, boolean isMoving) {
        matchShapeSize check = new matchShapeSize((LevelAccessor)world, pos);
        if ((neighborBlock == this || check.isPanthalassaPortalFrame(neighborBlock.m_49966_())) && !check.match) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public void m_7892_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (world instanceof ServerLevel && !entity.m_20092_()) {
            BlockPortal.changeDimension((ServerLevel)world, entity, pos, new PanthalassaTeleporter((ServerLevel)world));
        }
    }

    public static class matchShapeSize {
        private final LevelAccessor world;
        public boolean match = true;
        BlockPos centerPosition;
        float minPortalFrameRadius = 6.1f;
        float maxPortalFrameRadius = 7.5f;

        public matchShapeSize(LevelAccessor world, BlockPos pos, boolean createPortal) {
            this.world = world;
            if (createPortal) {
                this.centerPosition = pos;
                this.createPortalFrame();
                this.createPortalCenter();
                this.match = true;
            } else {
                int offsetN = this.centerPortal(pos, Direction.NORTH);
                int offsetS = this.centerPortal(pos, Direction.SOUTH);
                int offsetE = this.centerPortal(pos, Direction.EAST);
                int offsetW = this.centerPortal(pos, Direction.WEST);
                this.centerPosition = new BlockPos(pos.m_123341_() + (offsetE - offsetW) / 2, pos.m_123342_(), pos.m_123343_() - (offsetN - offsetS) / 2);
                if (this.match) {
                    this.match = this.checkIfValidPortalFrame(this.centerPosition);
                }
            }
        }

        public matchShapeSize(LevelAccessor world, BlockPos pos) {
            this(world, pos, false);
        }

        public static void recursivelyFindPortalPositions(LevelAccessor world, BlockPos portalCenter, BlockPos currentOffset, Set<BlockPos> savedOffsets) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction side : Direction.Plane.HORIZONTAL) {
                mutable.m_122190_((Vec3i)portalCenter).m_122193_((Vec3i)currentOffset).m_122173_(side);
                if (world.m_8055_((BlockPos)mutable).m_60713_((Block)PanthalassaBlocks.PORTAL_FRAME.get())) continue;
                mutable.m_122190_((Vec3i)currentOffset).m_122173_(side);
                if (savedOffsets.contains(mutable)) continue;
                savedOffsets.add(mutable.m_7949_());
                matchShapeSize.recursivelyFindPortalPositions(world, portalCenter, mutable.m_7949_(), savedOffsets);
            }
        }

        boolean isPanthalassaPortalFrame(BlockState state) {
            return state == ((Block)PanthalassaBlocks.PORTAL_FRAME.get()).m_49966_();
        }

        boolean isWaterOrPortal(BlockState state) {
            return state.m_60819_().m_205070_(FluidTags.f_13131_) || state == ((Block)PanthalassaBlocks.PORTAL.get()).m_49966_();
        }

        int centerPortal(BlockPos pos, Direction direction) {
            BlockPos blockpos;
            int distance;
            for (distance = 1; distance < 16 && !this.isPanthalassaPortalFrame(this.world.m_8055_(blockpos = pos.m_5484_(direction, distance))); ++distance) {
                if (distance != 15) continue;
                distance = 0;
                blockpos = pos.m_5484_(direction, distance);
                if (this.isPanthalassaPortalFrame(this.world.m_8055_(blockpos))) break;
                distance = 15;
                break;
            }
            return distance;
        }

        void destroyPortalBlocks() {
            HashSet<BlockPos> portalPositionsOffsets = new HashSet<BlockPos>();
            portalPositionsOffsets.add(BlockPos.f_121853_);
            matchShapeSize.recursivelyFindPortalPositions(this.world, this.centerPosition, BlockPos.f_121853_, portalPositionsOffsets);
            for (BlockPos pos : portalPositionsOffsets) {
                this.world.m_7731_(this.centerPosition.m_141952_((Vec3i)pos), Blocks.f_49990_.m_49966_(), 2);
            }
        }

        public boolean checkIfValidPortalFrame(BlockPos pos) {
            float minRadiusSq = this.minPortalFrameRadius * this.minPortalFrameRadius;
            float maxRadiusSq = this.maxPortalFrameRadius * this.maxPortalFrameRadius;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int x = (int)(-this.maxPortalFrameRadius);
            while ((float)x < this.maxPortalFrameRadius) {
                int z = (int)(-this.maxPortalFrameRadius);
                while ((float)z < this.maxPortalFrameRadius) {
                    int distSq = x * x + z * z;
                    if ((float)distSq > minRadiusSq && (float)distSq < maxRadiusSq) {
                        mutable.m_122190_((Vec3i)pos).m_122184_(x, 0, z);
                        if (!this.isPanthalassaPortalFrame(this.world.m_8055_((BlockPos)mutable))) {
                            return false;
                        }
                    } else if ((float)distSq <= minRadiusSq) {
                        mutable.m_122190_((Vec3i)pos).m_122184_(x, 0, z);
                        if (!this.isWaterOrPortal(this.world.m_8055_((BlockPos)mutable))) {
                            return false;
                        }
                    }
                    ++z;
                }
                ++x;
            }
            return true;
        }

        public void createPortalFrame() {
            float minRadiusSq = this.minPortalFrameRadius * this.minPortalFrameRadius;
            float maxRadiusSq = this.maxPortalFrameRadius * this.maxPortalFrameRadius;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int x = (int)(-this.maxPortalFrameRadius);
            while ((float)x < this.maxPortalFrameRadius) {
                int z = (int)(-this.maxPortalFrameRadius);
                while ((float)z < this.maxPortalFrameRadius) {
                    int distSq = x * x + z * z;
                    if ((float)distSq > minRadiusSq && (float)distSq < maxRadiusSq) {
                        mutable.m_122190_((Vec3i)this.centerPosition).m_122184_(x, 0, z);
                        this.world.m_7731_((BlockPos)mutable, ((Block)PanthalassaBlocks.PORTAL_FRAME.get()).m_49966_(), 2);
                        if (((ServerLevel)this.world).m_46472_() == PanthalassaDimension.PANTHALASSA) {
                            while (mutable.m_122173_(Direction.UP).m_123342_() < this.world.m_141928_() && !this.world.m_8055_((BlockPos)mutable).m_60713_(Blocks.f_50752_)) {
                                this.world.m_7731_((BlockPos)mutable, ((Block)PanthalassaBlocks.PANTHALASSA_ROCK.get()).m_49966_(), 2);
                            }
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }

        public void createPortalCenter() {
            float minRadiusSq = this.minPortalFrameRadius * this.minPortalFrameRadius;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int x = (int)(-this.minPortalFrameRadius);
            while ((float)x < this.minPortalFrameRadius) {
                int z = (int)(-this.minPortalFrameRadius);
                while ((float)z < this.minPortalFrameRadius) {
                    int distSq = x * x + z * z;
                    if ((float)distSq <= minRadiusSq) {
                        mutable.m_122190_((Vec3i)this.centerPosition).m_122184_(x, 0, z);
                        this.world.m_7731_((BlockPos)mutable, ((Block)PanthalassaBlocks.PORTAL.get()).m_49966_(), 2);
                        BlockEntity tileEntity = this.world.m_7702_((BlockPos)mutable);
                        if (tileEntity instanceof BlockPortalBlockEntity) {
                            ((BlockPortalBlockEntity)tileEntity).offsetFromCenter = new BlockPos(x, 0, z);
                            tileEntity.m_6596_();
                        }
                        if (((ServerLevel)this.world).m_46472_() == PanthalassaDimension.PANTHALASSA) {
                            while (mutable.m_122173_(Direction.UP).m_123342_() < this.world.m_141928_() && !this.world.m_8055_((BlockPos)mutable).m_60713_(Blocks.f_50752_) && mutable.m_123342_() < this.centerPosition.m_123342_() + 7) {
                                this.world.m_7731_((BlockPos)mutable, Blocks.f_49990_.m_49966_(), 2);
                            }
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }

        public void linkPortalCenters(LevelAccessor otherWorld, BlockPos centerOfOtherPortal) {
            float minRadiusSq = this.minPortalFrameRadius * this.minPortalFrameRadius;
            BlockPos.MutableBlockPos mutable1 = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
            int x = (int)(-this.maxPortalFrameRadius);
            while ((float)x < this.maxPortalFrameRadius) {
                int z = (int)(-this.maxPortalFrameRadius);
                while ((float)z < this.maxPortalFrameRadius) {
                    int distSq = x * x + z * z;
                    if ((float)distSq <= minRadiusSq) {
                        mutable1.m_122190_((Vec3i)this.centerPosition).m_122184_(x, 0, z);
                        mutable2.m_122190_((Vec3i)centerOfOtherPortal).m_122184_(x, 0, z);
                        BlockEntity tileEntity1 = this.world.m_7702_((BlockPos)mutable1);
                        BlockEntity tileEntity2 = otherWorld.m_7702_((BlockPos)mutable2);
                        if (tileEntity1 instanceof BlockPortalBlockEntity) {
                            BlockPortalBlockEntity portal1 = (BlockPortalBlockEntity)tileEntity1;
                            if (tileEntity2 instanceof BlockPortalBlockEntity) {
                                BlockPortalBlockEntity portal2 = (BlockPortalBlockEntity)tileEntity2;
                                portal1.destinationPos = portal2.m_58899_();
                                portal1.destinationWorld = portal2.m_58904_().m_46472_();
                                portal2.destinationPos = portal1.m_58899_();
                                portal2.destinationWorld = portal1.m_58904_().m_46472_();
                                portal1.m_6596_();
                                portal2.m_6596_();
                            }
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
    }
}

