/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature;

import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.IHungry;
import com.github.sniffity.panthalassa.server.entity.creature.ai.ISchoolable;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaDisorientGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaEscapeGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaFindWaterGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaRandomSwimmingGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaSmartAttackGoal;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityAnglerfish
extends PanthalassaEntity
implements IAnimatable,
Enemy,
ISchoolable,
IHungry {
    public static final int BLOCKED_DISTANCE = 3;
    protected static final EntityDataAccessor<Boolean> LEADER = SynchedEntityData.m_135353_(EntityAnglerfish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> HUNGER_COOLDOWN = SynchedEntityData.m_135353_(EntityAnglerfish.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public EntityAnglerfish(EntityType<? extends PanthalassaEntity> type, Level worldIn) {
        super(type, worldIn);
        this.adjustment = 0.25f;
        this.canBreatheOutsideWater = false;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(LEADER, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(HUNGER_COOLDOWN, (Object)Float.valueOf(0.0f));
        super.m_8097_();
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getAttackingState() && !this.f_20890_ && !((double)this.m_21223_() < 0.01) && !this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.anglerfish.attack", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.m_20096_() && !this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.anglerfish.beached", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, CompoundTag compound) {
        return super.m_6518_(world, difficulty, reason, livingdata, compound);
    }

    @Override
    public void m_8119_() {
        if (this.getHungerCooldown() > -1.0f) {
            this.setHungerCooldown(this.getHungerCooldown() - 1.0f);
        }
        super.m_8119_();
    }

    public static AttributeSupplier.Builder anglerfishAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)1.3f);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanthalassaDisorientGoal(this, 0.7));
        this.f_21345_.m_25352_(1, (Goal)new PanthalassaSmartAttackGoal(this, 2.0, false));
        this.f_21345_.m_25352_(3, (Goal)new PanthalassaEscapeGoal(this, 1.3f));
        this.f_21345_.m_25352_(3, (Goal)new PanthalassaFindWaterGoal(this, 0.15f));
        this.f_21345_.m_25352_(4, (Goal)new PanthalassaRandomSwimmingGoal(this, 0.7f, 10, 3));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> entity instanceof Player && this.f_19853_.m_46791_() != Difficulty.PEACEFUL && (entity.m_20069_() || entity.f_19853_.m_6425_(entity.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_))));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> !(entity instanceof Player) && !(entity instanceof EntityAnglerfish) && (entity.m_20069_() || entity.f_19853_.m_6425_(entity.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_))));
    }

    @Override
    public void setLeader(boolean leaderStatus) {
        this.f_19804_.m_135381_(LEADER, (Object)leaderStatus);
    }

    @Override
    public boolean getIsLeader() {
        return (Boolean)this.f_19804_.m_135370_(LEADER);
    }

    @Override
    public void setHungerCooldown(float hungerCooldown) {
        this.f_19804_.m_135381_(HUNGER_COOLDOWN, (Object)Float.valueOf(hungerCooldown));
    }

    @Override
    public float getHungerCooldown() {
        return ((Float)this.f_19804_.m_135370_(HUNGER_COOLDOWN)).floatValue();
    }
}

