/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature;

import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaSwimmingHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public abstract class PanthalassaEntity
extends PathfinderMob {
    public boolean isLandNavigator;
    public float rotationPitch;
    public float prevRotationPitch;
    public float prevYRot;
    public float deltaYRot;
    public float adjustYaw;
    public float adjustment;
    public boolean canBreatheOutsideWater;
    public float prevSetYaw;
    public float setYaw;
    protected static final EntityDataAccessor<Boolean> ATTACKING_STATE = SynchedEntityData.m_135353_(PanthalassaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> AIR_SUPPLY = SynchedEntityData.m_135353_(PanthalassaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PanthalassaEntity(EntityType<? extends PanthalassaEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_19811_ = true;
        this.switchNavigators(false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ATTACKING_STATE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(AIR_SUPPLY, (Object)150);
        super.m_8097_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.deltaYRot = this.f_19857_ - this.prevYRot;
        this.prevYRot = this.f_19857_;
        this.prevSetYaw = this.setYaw;
        if (this.adjustYaw > this.deltaYRot) {
            this.adjustYaw -= this.adjustment;
            this.adjustYaw = Math.max(this.adjustYaw, this.deltaYRot);
        } else if (this.adjustYaw < this.deltaYRot) {
            this.adjustYaw += this.adjustment;
            this.adjustYaw = Math.min(this.adjustYaw, this.deltaYRot);
        }
        this.setYaw = (float)((double)this.adjustYaw * (Math.PI / 180));
        this.prevRotationPitch = this.rotationPitch;
        this.rotationPitch = (float)Mth.m_14136_((double)this.m_20184_().f_82480_, (double)Mth.m_14116_((float)((float)(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_))));
        if (this.isLandNavigator) {
            if (this.m_20069_() && !this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60815_()) {
                this.switchNavigators(false);
            }
        } else if (this.m_20069_() && this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60815_() && this.f_19853_.m_8055_(this.m_142538_().m_7494_()).m_60713_(Blocks.f_50016_)) {
            this.switchNavigators(true);
        } else if (!this.m_20069_() && this.m_20096_()) {
            this.switchNavigators(true);
        }
        if (!this.canBreatheOutsideWater) {
            this.handleAirSupply(this.getAirSupplyLocal());
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag;
        float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        int i = 0;
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            i += EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if (flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), f)) {
            int j;
            if (i > 0) {
                ((Player)entityIn).m_147240_((double)((float)i * 0.5f), (double)Mth.m_14031_((float)(this.f_19857_ * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.f_19857_ * ((float)Math.PI / 180)))));
            }
            if ((j = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
                entityIn.m_20254_(j * 4);
            }
            if (entityIn instanceof Player) {
                ItemStack itemstack1;
                Player entityplayer = (Player)entityIn;
                ItemStack itemstack = this.m_21205_();
                ItemStack itemStack = itemstack1 = entityplayer.m_6117_() ? entityplayer.m_21211_() : ItemStack.f_41583_;
                if (!itemstack.m_41619_() && !itemstack1.m_41619_() && itemstack.m_41720_().canDisableShield(itemstack, itemstack1, (LivingEntity)entityplayer, (LivingEntity)this) && itemstack1.m_150930_(Items.f_42740_)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
                    if (this.f_19796_.nextFloat() < f1) {
                        entityplayer.m_36335_().m_41524_(itemstack1.m_41720_(), 100);
                        this.f_19853_.m_7605_((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public static boolean canPanthalassaEntitySpawn(EntityType<? extends PanthalassaEntity> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return randomIn.nextDouble() > 0.8;
    }

    public boolean m_6914_(LevelReader p_205019_1_) {
        return p_205019_1_.m_46855_(this.m_142469_());
    }

    public void m_6043_() {
    }

    public void switchNavigators(boolean isOnLand) {
        if (isOnLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21365_ = new LookControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new PanthalassaSwimmingHelper((Mob)this, 85, 0.02f, 0.1f, true);
            this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
            this.f_21344_ = new WaterBoundPathNavigation((Mob)this, this.f_19853_);
            this.isLandNavigator = false;
        }
    }

    protected void handleAirSupply(int p_209207_1_) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.setAirSupplyLocal(p_209207_1_ - 1);
            if (this.getAirSupplyLocal() == -20) {
                this.setAirSupplyLocal(0);
                this.m_6469_(DamageSource.f_19312_, 2.0f);
            }
        } else {
            this.setAirSupplyLocal(150);
        }
    }

    public void setAttackingState(boolean isAttacking) {
        this.f_19804_.m_135381_(ATTACKING_STATE, (Object)isAttacking);
    }

    public boolean getAttackingState() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING_STATE);
    }

    public void setAirSupplyLocal(int airSupply) {
        this.f_19804_.m_135381_(AIR_SUPPLY, (Object)airSupply);
    }

    public int getAirSupplyLocal() {
        return (Integer)this.f_19804_.m_135370_(AIR_SUPPLY);
    }
}

