/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.block.BlockPortalBlockEntity;
import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import com.github.sniffity.panthalassa.server.registry.PanthalassaPOI;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class PanthalassaEscapeGoal
extends Goal {
    protected final PanthalassaEntity creature;
    protected final double speed;
    private BlockPos targetPos;
    protected float tickCounter = 0.0f;

    public PanthalassaEscapeGoal(PanthalassaEntity creature, double speed) {
        this.creature = creature;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.creature.f_19853_.m_46472_() != PanthalassaDimension.PANTHALASSA) {
            return false;
        }
        if (this.creature.isLandNavigator) {
            return false;
        }
        if (this.creature.m_20160_()) {
            return false;
        }
        int searchRadius = 10;
        PoiManager pointofinterestmanager = ((ServerLevel)this.creature.f_19853_).m_8904_();
        Optional portalPOI = pointofinterestmanager.m_27181_(pointOfInterestType -> pointOfInterestType == PanthalassaPOI.PANTHALASSA_POI_PORTAL.get(), this.creature.m_142538_(), searchRadius, PoiManager.Occupancy.ANY).findFirst();
        if (portalPOI.isPresent()) {
            BlockPortalBlockEntity tempTE = this.getPortalTE((LevelAccessor)this.creature.f_19853_, ((PoiRecord)portalPOI.get()).m_27257_());
            if (tempTE != null && tempTE.offsetFromCenter != null) {
                BlockPortalBlockEntity centerTE = this.getPortalTE((LevelAccessor)this.creature.f_19853_, ((PoiRecord)portalPOI.get()).m_27257_().m_141950_((Vec3i)tempTE.offsetFromCenter));
                if (centerTE != null) {
                    this.targetPos = centerTE.m_58899_();
                    return true;
                }
            } else {
                this.targetPos = null;
                return false;
            }
        }
        this.targetPos = null;
        return false;
    }

    public boolean m_8045_() {
        if (this.creature.m_20160_()) {
            return false;
        }
        if (this.creature.f_19853_.m_46472_() != PanthalassaDimension.PANTHALASSA) {
            return false;
        }
        return !(this.tickCounter > 80.0f);
    }

    public void m_8056_() {
        this.creature.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), this.speed);
    }

    public void m_8037_() {
        if (this.creature.m_20275_(this.targetPos.m_123341_(), this.targetPos.m_123342_(), this.targetPos.m_123343_()) < 50.0) {
            Vec3 creaturePos = new Vec3(this.creature.m_20185_(), this.creature.m_20186_(), this.creature.m_20189_());
            Vec3 target = new Vec3((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_());
            Vec3 trajectory = target.m_82546_(creaturePos).m_82541_();
            this.creature.m_20256_(this.creature.m_20184_().m_82520_(trajectory.f_82479_, trajectory.f_82480_, trajectory.f_82481_));
        }
        float f = this.tickCounter;
        this.tickCounter = f + 1.0f;
        this.tickCounter = f;
    }

    public void m_8041_() {
        this.creature.m_21573_().m_26573_();
        super.m_8041_();
    }

    private BlockPortalBlockEntity getPortalTE(LevelAccessor world, BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof BlockPortalBlockEntity) {
            return (BlockPortalBlockEntity)tileEntity;
        }
        return null;
    }
}

