/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.ISchoolable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PanthalassaSchoolingGoal
extends Goal {
    PanthalassaEntity panthalassaEntity;
    ISchoolable panthalassaSchoolableEntity;
    float schoolSpeed;
    float schoolMaxSize;
    float schoolAvoidRadius;
    float rayTraceLength = 10.0f;
    int numViewDirections = 300;
    Vec3[] directions;
    List<? extends PanthalassaEntity> school;
    PanthalassaEntity leader;

    public PanthalassaSchoolingGoal(PanthalassaEntity creatureIn, float movementSpeedIn, float schoolMaxSize) {
        this.panthalassaEntity = creatureIn;
        this.panthalassaSchoolableEntity = (ISchoolable)((Object)creatureIn);
        this.schoolSpeed = movementSpeedIn;
        this.schoolMaxSize = schoolMaxSize;
        this.schoolAvoidRadius = schoolMaxSize;
    }

    public boolean m_8036_() {
        this.school = this.panthalassaEntity.f_19853_.m_45976_(((Object)((Object)this.panthalassaEntity)).getClass(), this.panthalassaEntity.m_142469_().m_82400_(10.0));
        if (this.school.size() <= 1) {
            return false;
        }
        if (!this.panthalassaEntity.m_20069_()) {
            return false;
        }
        for (int i = 0; i < this.school.size(); ++i) {
            PanthalassaEntity testEntity = this.school.get(i);
            if (!((ISchoolable)((Object)testEntity)).getIsLeader()) continue;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.leader == null || this.leader.m_21224_()) {
            return false;
        }
        if (!this.panthalassaEntity.m_20069_()) {
            return false;
        }
        return this.panthalassaEntity.m_5448_() == null && this.leader.m_5448_() == null;
    }

    public void m_8056_() {
        this.processLeader(this.school);
    }

    public void m_8037_() {
        Vec3 attract = new Vec3(0.0, 0.0, 0.0);
        Vec3 repel = new Vec3(0.0, 0.0, 0.0);
        Vec3 avoid = new Vec3(0.0, 0.0, 0.0);
        this.school.remove((Object)this.panthalassaEntity);
        if (!this.school.isEmpty()) {
            repel = this.processRepel(this.school);
            Vec3 follow = this.processFollow(this.school);
            avoid = this.processAvoid(this.panthalassaEntity);
            repel = repel.m_82541_().m_82490_(1.2);
            follow = follow.m_82541_().m_82490_(1.0);
            avoid = avoid.m_82541_().m_82490_(1.5);
            Vec3 newMovement = !this.panthalassaSchoolableEntity.getIsLeader() ? this.panthalassaEntity.m_20184_().m_82549_(repel).m_82549_(follow).m_82549_(avoid) : this.panthalassaEntity.m_20184_().m_82549_(repel);
            float leaderSpeed = 1.0f;
            if (this.leader != null) {
                leaderSpeed = (float)this.leader.m_20184_().m_82553_();
            }
            if (newMovement.m_82553_() > (double)leaderSpeed) {
                newMovement = newMovement.m_82541_().m_82490_((double)leaderSpeed);
            }
            this.panthalassaEntity.m_20256_(newMovement);
            if (this.leader != null && !this.panthalassaSchoolableEntity.getIsLeader()) {
                this.panthalassaEntity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.panthalassaEntity.m_20182_().m_82549_(this.panthalassaEntity.m_20184_()));
            }
        }
    }

    protected void processLeader(List<? extends PanthalassaEntity> school) {
        for (int i = 0; i < school.size(); ++i) {
            PanthalassaEntity testEntity = school.get(i);
            if (!((ISchoolable)((Object)testEntity)).getIsLeader()) continue;
            this.leader = testEntity;
            break;
        }
    }

    protected Vec3 processRepel(List<? extends PanthalassaEntity> school) {
        Vec3 separation = new Vec3(0.0, 0.0, 0.0);
        ArrayList<PanthalassaEntity> closeEntities = new ArrayList<PanthalassaEntity>();
        int schoolSize = school.size();
        for (int i = 0; i < schoolSize && i < 4; ++i) {
            PanthalassaEntity testEntity = school.get(i);
            float distanceToEntity = (float)this.panthalassaEntity.m_20182_().m_82546_(testEntity.m_20182_()).m_82553_();
            if (!(distanceToEntity < this.schoolAvoidRadius)) continue;
            closeEntities.add(testEntity);
        }
        if (closeEntities.isEmpty()) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        int closeSize = closeEntities.size();
        for (int i = 0; i < closeSize; ++i) {
            PanthalassaEntity testEntity = school.get(i);
            Vec3 difference = this.panthalassaEntity.m_20182_().m_82546_(testEntity.m_20182_());
            separation = separation.m_82549_(difference.m_82541_().m_82490_(1.0 / difference.m_82553_()));
        }
        separation = separation.m_82490_((double)(1.0f / (float)closeSize));
        Vec3 target = separation.m_82541_().m_82490_((double)this.schoolSpeed);
        return target.m_82546_(this.panthalassaEntity.m_20184_());
    }

    protected Vec3 processFollow(List<? extends PanthalassaEntity> school) {
        int size = school.size();
        Vec3 speedVector = new Vec3(0.0, 0.0, 0.0);
        for (int i = 0; i < size && i < 4; ++i) {
            PanthalassaEntity testEntity = school.get(i);
            if (!((ISchoolable)((Object)testEntity)).getIsLeader()) continue;
            speedVector = testEntity.m_20184_();
        }
        Vec3 target = speedVector.m_82541_().m_82490_((double)this.schoolSpeed);
        return target.m_82546_(this.panthalassaEntity.m_20184_());
    }

    protected Vec3 processAvoid(PanthalassaEntity entityIn) {
        AABB searchArea = new AABB(entityIn.m_20185_() - 3.0, entityIn.m_20186_() - 3.0, entityIn.m_20189_() - 3.0, entityIn.m_20185_() + 3.0, entityIn.m_20186_() + 3.0, entityIn.m_20189_() + 3.0);
        Set set = BlockPos.m_121921_((AABB)searchArea).map(pos -> new BlockPos((Vec3i)pos)).filter(state -> this.panthalassaEntity.f_19853_.m_8055_(state).m_60815_() || this.panthalassaEntity.f_19853_.m_8055_(state).m_60713_(Blocks.f_50016_)).collect(Collectors.toSet());
        Iterator it = set.iterator();
        if (!set.isEmpty()) {
            BlockPos closestPos = new BlockPos(0, 0, 0);
            float distanceToClosestPos = 100.0f;
            while (it.hasNext()) {
                BlockPos testPos = (BlockPos)it.next();
                float distanceToPos = (float)entityIn.m_20182_().m_82492_((double)testPos.m_123341_(), (double)testPos.m_123342_(), (double)testPos.m_123343_()).m_82553_();
                if (!(distanceToPos < distanceToClosestPos)) continue;
                distanceToClosestPos = distanceToPos;
                closestPos = new BlockPos(testPos.m_123341_(), testPos.m_123342_(), testPos.m_123343_());
            }
            Vec3 targetAwayFromClosestPos = entityIn.m_20182_().m_82492_((double)closestPos.m_123341_(), (double)closestPos.m_123342_(), (double)closestPos.m_123343_());
            targetAwayFromClosestPos = targetAwayFromClosestPos.m_82541_();
            return targetAwayFromClosestPos.m_82546_(entityIn.m_20184_());
        }
        return new Vec3(0.0, 0.0, 0.0);
    }

    public void m_8041_() {
        this.panthalassaEntity.m_20334_(0.0, 0.0, 0.0);
        super.m_8041_();
    }

    protected float rotlerp(float p_75639_1_, float p_75639_2_, float p_75639_3_) {
        float f1;
        float f = Mth.m_14177_((float)(p_75639_2_ - p_75639_1_));
        if (f > p_75639_3_) {
            f = p_75639_3_;
        }
        if (f < -p_75639_3_) {
            f = -p_75639_3_;
        }
        if ((f1 = p_75639_1_ + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    protected void collisionVectors() {
        this.directions = new Vec3[this.numViewDirections];
        float goldenRatio = (float)(1.0 + Math.sqrt(5.0)) / 2.0f;
        float angleIncrement = (float)Math.PI * 2 * goldenRatio;
        for (int i = 0; i < this.numViewDirections; ++i) {
            float t = (float)i / (float)this.numViewDirections;
            float inclination = (float)Math.acos(1.0f - 2.0f * t);
            float azimuth = angleIncrement * (float)i;
            float x = (float)(Math.sin(inclination) * Math.cos(azimuth));
            float y = (float)(Math.sin(inclination) * Math.sin(azimuth));
            float z = (float)Math.cos(inclination);
            this.directions[i] = new Vec3((double)x, (double)y, (double)z);
        }
    }
}

