/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.entity.creature.EntityAnglerfish;
import com.github.sniffity.panthalassa.server.entity.creature.EntityBasilosaurus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityDunkleosteus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityGiantOrthocone;
import com.github.sniffity.panthalassa.server.entity.creature.EntityHelicoprion;
import com.github.sniffity.panthalassa.server.entity.creature.EntityKronosaurus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityLeedsichthys;
import com.github.sniffity.panthalassa.server.entity.creature.EntityMegalodon;
import com.github.sniffity.panthalassa.server.entity.creature.EntityMosasaurus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityThalassomedon;
import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.IHungry;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEffects;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;

public class PanthalassaSmartAttackGoal
extends Goal {
    private IHungry hungryAttacker;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int delayCounter;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private PanthalassaEntity panthalassaEntity;
    private boolean killFlag;
    private boolean isHungryAttacker = false;

    public PanthalassaSmartAttackGoal(PanthalassaEntity creature, double speedIn, boolean useLongMemory) {
        this.panthalassaEntity = creature;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (creature instanceof IHungry) {
            this.hungryAttacker = (IHungry)((Object)creature);
            this.isHungryAttacker = true;
        }
    }

    public boolean m_8036_() {
        if (!this.panthalassaEntity.m_20069_() && !this.panthalassaEntity.f_19853_.m_8055_(new BlockPos(this.panthalassaEntity.m_20182_()).m_7495_()).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        if (this.panthalassaEntity.m_21023_((MobEffect)PanthalassaEffects.DISORIENT.get())) {
            return false;
        }
        if (this.panthalassaEntity.isLandNavigator) {
            return false;
        }
        long i = this.panthalassaEntity.f_19853_.m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.panthalassaEntity.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.isHungryAttacker && !this.isEntityThreat(livingentity)) {
            if (this.hungryAttacker.getHungerCooldown() < 0.0f) {
                this.path = this.panthalassaEntity.m_21573_().m_6570_((Entity)livingentity, 0);
                if (this.path != null) {
                    return true;
                }
                return this.getAttackReachSqr(livingentity) >= this.panthalassaEntity.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            }
            return false;
        }
        this.path = this.panthalassaEntity.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.panthalassaEntity.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.panthalassaEntity.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (this.panthalassaEntity.m_21023_((MobEffect)PanthalassaEffects.DISORIENT.get())) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.panthalassaEntity.m_21573_().m_26571_();
        }
        if (!this.panthalassaEntity.m_21444_(livingentity.m_142538_())) {
            return false;
        }
        if (this.panthalassaEntity.isLandNavigator) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.panthalassaEntity.m_21573_().m_26536_(this.path, this.speedTowardsTarget);
        this.panthalassaEntity.m_21561_(true);
        this.delayCounter = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.panthalassaEntity.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.panthalassaEntity.m_6710_(null);
        }
        if (this.killFlag) {
            this.hungryAttacker.setHungerCooldown(500.0f);
        }
        this.panthalassaEntity.m_21561_(false);
        this.panthalassaEntity.setAttackingState(false);
        this.panthalassaEntity.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.panthalassaEntity.m_5448_();
        this.panthalassaEntity.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.panthalassaEntity.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        this.delayCounter = Math.max(this.delayCounter - 1, 0);
        if ((this.longMemory || this.panthalassaEntity.m_21574_().m_148306_((Entity)livingentity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.panthalassaEntity.m_21187_().nextFloat() < 0.05f)) {
            this.targetX = livingentity.m_20185_();
            this.targetY = livingentity.m_20186_();
            this.targetZ = livingentity.m_20189_();
            this.delayCounter = 4 + this.panthalassaEntity.m_21187_().nextInt(7);
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.panthalassaEntity.m_21573_().m_5624_((Entity)livingentity, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        double d0 = this.getAttackReachSqr(enemy);
        if (distToEnemySqr <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.panthalassaEntity.m_6674_(InteractionHand.MAIN_HAND);
            this.panthalassaEntity.setAttackingState(true);
            this.panthalassaEntity.m_7327_((Entity)enemy);
            if (enemy.m_21224_()) {
                this.killFlag = true;
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 20;
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.panthalassaEntity.m_20205_() * 2.0f * this.panthalassaEntity.m_20205_() * 2.0f + attackTarget.m_20205_();
    }

    public boolean isEntityThreat(LivingEntity test) {
        if (test instanceof EntityBasilosaurus) {
            return true;
        }
        if (test instanceof EntityDunkleosteus) {
            return true;
        }
        if (test instanceof EntityGiantOrthocone) {
            return true;
        }
        if (test instanceof EntityKronosaurus) {
            return true;
        }
        if (test instanceof EntityLeedsichthys) {
            return true;
        }
        if (test instanceof EntityMegalodon) {
            return true;
        }
        if (test instanceof EntityMosasaurus) {
            return true;
        }
        if (test instanceof EntityThalassomedon) {
            return true;
        }
        if (test instanceof EntityHelicoprion) {
            return true;
        }
        if (test instanceof EntityAnglerfish) {
            return true;
        }
        return test instanceof Player;
    }
}

