/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.projectile;

import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ProjectileBlastTorpedo
extends Entity
implements IEntityAdditionalSpawnData,
IAnimatable {
    @Nullable
    public PanthalassaVehicle source;
    public Vec3 acceleration;
    public float life;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ProjectileBlastTorpedo(EntityType<?> type, Level level) {
        super(type, level);
    }

    public ProjectileBlastTorpedo(EntityType<? extends ProjectileBlastTorpedo> type, PanthalassaVehicle source, Vec3 position, Vec3 direction) {
        super(type, source.f_19853_);
        direction = direction.m_82549_(new Vec3(this.f_19796_.nextGaussian() * this.getAccelerationOffset(), this.f_19796_.nextGaussian() * this.getAccelerationOffset(), this.f_19796_.nextGaussian() * this.getAccelerationOffset()));
        double length = direction.m_82553_();
        this.acceleration = new Vec3(direction.f_82479_ / length * (double)this.getMotionFactor(), direction.f_82480_ / length * (double)this.getMotionFactor(), direction.f_82481_ / length * (double)this.getMotionFactor());
        this.source = source;
        this.life = 200.0f;
        this.m_20256_(this.acceleration);
        position = position.m_82549_(this.m_20184_()).m_82492_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        this.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, this.f_19857_, this.f_19858_);
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_ && (float)this.f_19797_ > this.life || !this.f_19853_.m_46805_(this.m_142538_())) {
            this.m_146870_();
            return;
        }
        ProjectileUtil.m_37284_((Entity)this, (float)1.0f);
        super.m_8119_();
        AABB boundingBox = this.m_142469_().m_82400_(0.05);
        List entities = this.f_19853_.m_6249_((Entity)this, boundingBox, this::canImpactEntity);
        if (!entities.isEmpty()) {
            this.impact(new BlockPos(this.m_20182_()));
        } else {
            Vec3 end;
            Vec3 position = this.m_20182_();
            BlockHitResult raytraceresult = this.f_19853_.m_45547_(new ClipContext(position, end = position.m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                this.impact(new BlockPos(this.m_20182_()));
            }
        }
        Vec3 motion = this.m_20184_();
        double x = this.m_20185_() + motion.f_82479_;
        double y = this.m_20186_() + motion.f_82480_;
        double z = this.m_20189_() + motion.f_82481_;
        this.m_20248_(x, y, z);
        if (this.f_19853_.f_46443_) {
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x - motion.f_82479_ * 0.25, y - motion.f_82480_ * 0.25, z - motion.f_82481_ * 0.25, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            } else {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x - motion.f_82479_ * 0.25, y - motion.f_82480_ * 0.25, z - motion.f_82481_ * 0.25, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
    }

    public boolean canImpactEntity(Entity entity) {
        if (entity == this.source) {
            return false;
        }
        if (!entity.m_6084_()) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity.m_20201_() == this.source) {
            return false;
        }
        if (entity.m_5833_() || !entity.m_6087_() || entity.f_19794_) {
            return false;
        }
        return this.source != null && !entity.m_7307_((Entity)this.source);
    }

    public void impact(BlockPos impactPos) {
        this.f_19853_.m_46518_(null, (double)impactPos.m_123341_(), (double)impactPos.m_123342_(), (double)impactPos.m_123343_(), 5.0f, true, Explosion.BlockInteraction.DESTROY);
        AABB boundingBox = this.m_142469_().m_82400_(4.0);
        List entities = this.f_19853_.m_6249_((Entity)this, boundingBox, this::canImpactEntity);
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                entity.m_6469_(DamageSource.m_19373_((LivingEntity)((LivingEntity)entity)), 50.0f);
            }
        }
        this.m_146870_();
    }

    public void m_20256_(Vec3 motionIn) {
        super.m_20256_(motionIn);
        ProjectileUtil.m_37284_((Entity)this, (float)1.0f);
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_142469_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    protected float getMotionFactor() {
        return 1.5f;
    }

    protected double getAccelerationOffset() {
        return 0.1;
    }

    public boolean m_20068_() {
        return true;
    }

    public float m_6073_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public float m_6143_() {
        return this.m_20205_();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.source.m_142049_());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.source = (PanthalassaVehicle)this.f_19853_.m_6815_(buffer.readInt());
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

