/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.vehicle;

import com.github.sniffity.panthalassa.server.entity.projectile.ProjectileTranquilizingTorpedo;
import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import com.github.sniffity.panthalassa.server.registry.PanthalassaItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class VehicleECSV
extends PanthalassaVehicle
implements IAnimatable {
    protected static final EntityDataAccessor<Float> TORPEDO_COOLDOWN = SynchedEntityData.m_135353_(VehicleECSV.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> TORPEDO_COUNT = SynchedEntityData.m_135353_(VehicleECSV.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public VehicleECSV(EntityType<? extends PanthalassaVehicle> type, Level world) {
        super(type, world);
        this.waterSpeed = 0.04f;
        this.landSpeed = 0.004f;
        this.itemStack = new ItemStack((ItemLike)PanthalassaItems.ECSV_VEHICLE.get(), 1);
    }

    public VehicleECSV(Level p_i1705_1_, double x, double y, double z) {
        this((EntityType<? extends PanthalassaVehicle>)((EntityType)PanthalassaEntityTypes.ECSV.get()), p_i1705_1_);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(MAX_HEALTH, (Object)Float.valueOf(300.0f));
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(300.0f));
        this.f_19804_.m_135372_(ARMOR, (Object)Float.valueOf(50.0f));
        this.f_19804_.m_135372_(TORPEDO_COOLDOWN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TORPEDO_COUNT, (Object)10);
        super.m_8097_();
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("torpedoCount")) {
            this.setTorpedoCount(compound.m_128451_("torpedoCount"));
        }
        if (compound.m_128441_("torpedoCooldown")) {
            this.setTorpedoCooldown(compound.m_128457_("torpedoCooldown"));
        }
        super.m_7378_(compound);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("torpedoCount", this.getTorpedoCount());
        compound.m_128350_("torpedoCooldown", this.getTorpedoCooldown());
        super.m_7380_(compound);
    }

    public double m_6048_() {
        return 0.15;
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void m_8119_() {
        if (this.getTorpedoCooldown() > -1.0f) {
            this.setTorpedoCooldown(this.getTorpedoCooldown() - 1.0f);
        }
        super.m_8119_();
    }

    @Override
    public void respondKeybindSpecial() {
        if (!this.f_19853_.f_46443_ && this.getTorpedoCooldown() < 0.0f && this.getTorpedoCount() > 0) {
            this.f_19853_.m_7967_((Entity)new ProjectileTranquilizingTorpedo((EntityType<? extends ProjectileTranquilizingTorpedo>)((EntityType)PanthalassaEntityTypes.TRANQUILIZING_TORPEDO.get()), this, this.m_146892_().m_82492_(0.0, 1.0, 0.0), Vec3.m_82498_((float)this.f_19858_, (float)this.f_19857_)));
            this.setTorpedoCooldown(100.0f);
            this.setTorpedoCount(this.getTorpedoCount() - 1);
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == PanthalassaItems.TRANQUILIZING_TORPEDO.get() && this.getTorpedoCount() < 10) {
            this.setTorpedoCount(this.getTorpedoCount() + 1);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    public void setTorpedoCount(int count) {
        this.f_19804_.m_135381_(TORPEDO_COUNT, (Object)count);
    }

    public int getTorpedoCount() {
        return (Integer)this.f_19804_.m_135370_(TORPEDO_COUNT);
    }

    public void setTorpedoCooldown(float cooldown) {
        this.f_19804_.m_135381_(TORPEDO_COOLDOWN, (Object)Float.valueOf(cooldown));
    }

    public float getTorpedoCooldown() {
        return ((Float)this.f_19804_.m_135370_(TORPEDO_COOLDOWN)).floatValue();
    }
}

