/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.vehicle;

import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import com.github.sniffity.panthalassa.server.registry.PanthalassaItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class VehicleMRSV
extends PanthalassaVehicle
implements IAnimatable {
    protected static final EntityDataAccessor<Boolean> IS_BOOSTING = SynchedEntityData.m_135353_(VehicleMRSV.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> BOOST_COOLDOWN = SynchedEntityData.m_135353_(VehicleMRSV.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> BOOSTING_TIMER = SynchedEntityData.m_135353_(VehicleMRSV.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(VehicleMRSV.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public VehicleMRSV(EntityType<? extends PanthalassaVehicle> type, Level world) {
        super(type, world);
        this.waterSpeed = 0.042f;
        this.landSpeed = 0.004f;
        this.itemStack = new ItemStack((ItemLike)PanthalassaItems.MRSV_VEHICLE.get(), 1);
    }

    public VehicleMRSV(Level p_i1705_1_, double x, double y, double z) {
        this((EntityType<? extends PanthalassaVehicle>)((EntityType)PanthalassaEntityTypes.MRSV.get()), p_i1705_1_);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(MAX_HEALTH, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(ARMOR, (Object)Float.valueOf(20.0f));
        this.f_19804_.m_135372_(IS_BOOSTING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(BOOST_COOLDOWN, (Object)Float.valueOf(20.0f));
        this.f_19804_.m_135372_(BOOSTING_TIMER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)11);
        super.m_8097_();
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("isBoosting")) {
            this.setIsBoosting(compound.m_128471_("isBoosting"));
        }
        if (compound.m_128441_("boostCooldown")) {
            this.setBoostCooldown(compound.m_128457_("boostCooldown"));
        }
        if (compound.m_128441_("boostingTimer")) {
            this.setBoostingTimer(compound.m_128457_("boostingTimer"));
        }
        if (compound.m_128441_("textureVariant")) {
            this.setTextureVariant(compound.m_128451_("textureVariant"));
        }
        super.m_7378_(compound);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("isBoosting", this.getIsBoosting());
        compound.m_128350_("boostCooldown", this.getBoostCooldown());
        compound.m_128350_("boostingTimer", this.getBoostingTimer());
        compound.m_128405_("textureVariant", this.getTextureVariant());
        super.m_7380_(compound);
    }

    public double m_6048_() {
        return 0.15;
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void m_8119_() {
        if (this.getBoostCooldown() > -1.0f) {
            this.setBoostCooldown(this.getBoostCooldown() - 1.0f);
        }
        if (this.getIsBoosting()) {
            this.setBoostingTimer(this.getBoostingTimer() + 1.0f);
            if (this.getBoostingTimer() > 50.0f) {
                this.setIsBoosting(false);
                this.setBoostingTimer(0.0f);
            }
        }
        super.m_8119_();
    }

    @Override
    public void respondKeybindSpecial() {
        if (!this.f_19853_.f_46443_ && this.getBoostCooldown() < 0.0f && this.m_20069_()) {
            this.setIsBoosting(true);
            this.setBoostCooldown(400.0f);
        }
    }

    @Override
    public float getTravelSpeed() {
        if (this.getIsBoosting() && this.m_20069_()) {
            return this.waterSpeed * 4.0f;
        }
        if (this.m_20069_()) {
            return this.waterSpeed;
        }
        return this.landSpeed;
    }

    public void setBoostingTimer(float cooldown) {
        this.f_19804_.m_135381_(BOOSTING_TIMER, (Object)Float.valueOf(cooldown));
    }

    public float getBoostingTimer() {
        return ((Float)this.f_19804_.m_135370_(BOOSTING_TIMER)).floatValue();
    }

    public void setIsBoosting(boolean isBoosting) {
        this.f_19804_.m_135381_(IS_BOOSTING, (Object)isBoosting);
    }

    public boolean getIsBoosting() {
        return (Boolean)this.f_19804_.m_135370_(IS_BOOSTING);
    }

    public void setBoostCooldown(float cooldown) {
        this.f_19804_.m_135381_(BOOST_COOLDOWN, (Object)Float.valueOf(cooldown));
    }

    public float getBoostCooldown() {
        return ((Float)this.f_19804_.m_135370_(BOOST_COOLDOWN)).floatValue();
    }

    public void setTextureVariant(int variant) {
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)variant);
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        int texture = 0;
        boolean flag = false;
        if (item == Items.f_42498_) {
            texture = 0;
            flag = true;
        } else if (item == Items.f_42497_) {
            texture = 1;
            flag = true;
        } else if (item == Items.f_42496_) {
            texture = 2;
            flag = true;
        } else if (item == Items.f_42495_) {
            texture = 3;
            flag = true;
        } else if (item == Items.f_42494_) {
            texture = 4;
            flag = true;
        } else if (item == Items.f_42493_) {
            texture = 5;
            flag = true;
        } else if (item == Items.f_42492_) {
            texture = 6;
            flag = true;
        } else if (item == Items.f_42491_) {
            texture = 7;
            flag = true;
        } else if (item == Items.f_42490_) {
            texture = 8;
            flag = true;
        } else if (item == Items.f_42489_) {
            texture = 9;
            flag = true;
        } else if (item == Items.f_42540_) {
            texture = 10;
            flag = true;
        } else if (item == Items.f_42539_) {
            texture = 11;
            flag = true;
        } else if (item == Items.f_42538_) {
            texture = 12;
            flag = true;
        } else if (item == Items.f_42537_) {
            texture = 13;
            flag = true;
        } else if (item == Items.f_42536_) {
            texture = 14;
            flag = true;
        } else if (item == Items.f_42535_) {
            texture = 15;
            flag = true;
        }
        if (flag) {
            this.setTextureVariant(texture);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6096_(player, hand);
    }
}

