/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;

public class PanthalassaWorldSavedData
extends SavedData {
    public static final String DATA_KEY = "panthalassa:world_data";
    private static final PanthalassaWorldSavedData CLIENT_DUMMY = new PanthalassaWorldSavedData();
    private List<PlayerTeleportEntry> playerTeleportQueue = new ArrayList<PlayerTeleportEntry>();
    private List<EntityTeleportEntry> entityTeleportQueue = new ArrayList<EntityTeleportEntry>();
    private List<VehicleCompundTeleportEntry> vehicleCompundTeleportQueue = new ArrayList<VehicleCompundTeleportEntry>();

    public static PanthalassaWorldSavedData create() {
        return new PanthalassaWorldSavedData();
    }

    public static PanthalassaWorldSavedData get(Level world) {
        if (!(world instanceof ServerLevel)) {
            return CLIENT_DUMMY;
        }
        DimensionDataStorage storage = ((ServerLevel)world).m_8895_();
        return (PanthalassaWorldSavedData)storage.m_164861_(PanthalassaWorldSavedData::load, PanthalassaWorldSavedData::new, DATA_KEY);
    }

    public static void tick(ServerLevel world) {
        ChunkPos entityChunkpos;
        ServerLevel originalWorld;
        ServerLevel targetWorld;
        MinecraftServer server = world.m_142572_();
        PanthalassaWorldSavedData data = PanthalassaWorldSavedData.get((Level)world);
        if (data == null) {
            return;
        }
        List<PlayerTeleportEntry> playerList = data.playerTeleportQueue;
        List<EntityTeleportEntry> entityList = data.entityTeleportQueue;
        List<VehicleCompundTeleportEntry> compoundList = data.vehicleCompundTeleportQueue;
        data.playerTeleportQueue = new ArrayList<PlayerTeleportEntry>();
        data.entityTeleportQueue = new ArrayList<EntityTeleportEntry>();
        data.vehicleCompundTeleportQueue = new ArrayList<VehicleCompundTeleportEntry>();
        for (VehicleCompundTeleportEntry vehicleCompundTeleportEntry : compoundList) {
            Entity vehicle = vehicleCompundTeleportEntry.entity;
            targetWorld = server.m_129880_(vehicleCompundTeleportEntry.targetWorld);
            originalWorld = server.m_129880_(vehicleCompundTeleportEntry.originalWorld);
            Vec3 targetVec = vehicleCompundTeleportEntry.targetVec;
            if (targetWorld == null || vehicle == null || originalWorld == null) continue;
            Entity vehicle2 = vehicle.m_6095_().m_20615_((Level)targetWorld);
            entityChunkpos = new ChunkPos(vehicle.m_142538_());
            targetWorld.m_7726_().m_8387_(TicketType.f_9448_, entityChunkpos, 1, (Object)vehicle.m_142049_());
            originalWorld.m_7726_().m_8387_(TicketType.f_9447_, entityChunkpos, 5, (Object)vehicle.m_142538_());
            if (vehicle2 == null) continue;
            vehicle2.m_20361_(vehicle);
            vehicle2.m_20035_(new BlockPos(targetVec.m_7096_(), targetVec.m_7098_(), targetVec.m_7094_()), vehicle.f_19857_, vehicle.f_19858_);
            vehicle2.m_20334_(0.0, 0.0, 0.0);
            targetWorld.m_143334_(vehicle2);
            vehicle2.m_20091_();
            originalWorld.m_8886_();
            targetWorld.m_8886_();
            while (vehicle.m_20197_().size() > 0) {
                Entity passenger = (Entity)vehicle.m_20197_().get(0);
                passenger.m_8127_();
                if (passenger instanceof Player) {
                    ServerPlayer player = (ServerPlayer)passenger;
                    ChunkPos playerChunkPos = new ChunkPos(passenger.m_142538_());
                    targetWorld.m_7726_().m_8387_(TicketType.f_9448_, playerChunkPos, 1, (Object)passenger.m_142049_());
                    originalWorld.m_7726_().m_8387_(TicketType.f_9447_, entityChunkpos, 5, (Object)vehicle.m_142538_());
                    player.f_19789_ = 0.0f;
                    player.f_19855_ = 0.0;
                    player.m_8999_(targetWorld, vehicleCompundTeleportEntry.targetVec.m_7096_(), vehicleCompundTeleportEntry.targetVec.m_7098_() + 0.2, vehicleCompundTeleportEntry.targetVec.m_7094_(), vehicleCompundTeleportEntry.yaw, vehicleCompundTeleportEntry.pitch);
                    player.m_20329_(vehicle2);
                    player.m_20091_();
                    continue;
                }
                Entity passenger2 = passenger.m_6095_().m_20615_((Level)targetWorld);
                ChunkPos entityChunkpos2 = new ChunkPos(passenger.m_142538_());
                targetWorld.m_7726_().m_8387_(TicketType.f_9448_, entityChunkpos2, 1, (Object)passenger.m_142049_());
                originalWorld.m_7726_().m_8387_(TicketType.f_9447_, entityChunkpos, 5, (Object)vehicle.m_142538_());
                if (passenger2 == null) continue;
                passenger2.m_20361_(passenger);
                passenger2.m_20035_(new BlockPos(targetVec.m_7096_(), targetVec.m_7098_(), targetVec.m_7094_()), passenger.f_19857_, passenger.f_19858_);
                passenger2.m_20334_(0.0, 0.0, 0.0);
                targetWorld.m_143334_(passenger2);
                passenger.m_146870_();
                originalWorld.m_8886_();
                targetWorld.m_8886_();
                passenger2.m_20329_(vehicle2);
                passenger2.m_20091_();
            }
            vehicle.m_146870_();
        }
        for (PlayerTeleportEntry playerTeleportEntry : playerList) {
            ServerPlayer player = server.m_6846_().m_11259_(playerTeleportEntry.playerUUID);
            targetWorld = server.m_129880_(playerTeleportEntry.targetWorld);
            if (player == null || targetWorld == null) continue;
            ChunkPos playerChunkPos = new ChunkPos(player.m_142538_());
            targetWorld.m_7726_().m_8387_(TicketType.f_9448_, playerChunkPos, 1, (Object)player.m_142049_());
            player.f_19789_ = 0.0f;
            player.f_19855_ = 0.0;
            player.m_8999_(targetWorld, playerTeleportEntry.targetVec.m_7096_(), playerTeleportEntry.targetVec.m_7098_() + 0.2, playerTeleportEntry.targetVec.m_7094_(), playerTeleportEntry.yaw, playerTeleportEntry.pitch);
            player.m_20091_();
        }
        for (EntityTeleportEntry entityTeleportEntry : entityList) {
            Entity entity2;
            Entity entity = entityTeleportEntry.entity;
            targetWorld = server.m_129880_(entityTeleportEntry.targetWorld);
            originalWorld = server.m_129880_(entityTeleportEntry.originalWorld);
            BlockPos targetBlock = entityTeleportEntry.targetBlock;
            if (targetWorld == null || originalWorld == null || (entity2 = entity.m_6095_().m_20615_((Level)targetWorld)) == null) continue;
            entityChunkpos = new ChunkPos(entity.m_142538_());
            targetWorld.m_7726_().m_8387_(TicketType.f_9448_, entityChunkpos, 1, (Object)entity.m_142049_());
            entity2.m_20361_(entity);
            entity2.m_20035_(targetBlock, entity.f_19857_, entity.f_19858_);
            entity2.m_20334_(0.0, 0.0, 0.0);
            entity2.m_20091_();
            targetWorld.m_143334_(entity2);
            entity.m_146870_();
            originalWorld.m_8886_();
            targetWorld.m_8886_();
        }
    }

    public void addPlayerTP(Player player, ResourceKey<Level> destination, Vec3 targetVec, float yaw, float pitch) {
        this.playerTeleportQueue.add(new PlayerTeleportEntry(Player.m_36198_((GameProfile)player.m_36316_()), destination, targetVec, yaw, pitch));
    }

    public void addEntityTP(Entity entity, ResourceKey<Level> destination, ResourceKey<Level> origin, Vec3 targetVec, float yaw, float pitch) {
        this.entityTeleportQueue.add(new EntityTeleportEntry(entity, destination, origin, targetVec, yaw, pitch));
    }

    public void addCompoundTP(Entity vehicle, ResourceKey<Level> destination, ResourceKey<Level> origin, Vec3 targetVec, float yaw, float pitch) {
        this.vehicleCompundTeleportQueue.add(new VehicleCompundTeleportEntry(vehicle, destination, origin, targetVec, yaw, pitch));
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        return null;
    }

    public static PanthalassaWorldSavedData load(CompoundTag tag) {
        PanthalassaWorldSavedData data = PanthalassaWorldSavedData.create();
        return data;
    }

    static class VehicleCompundTeleportEntry {
        final Entity entity;
        final ResourceKey<Level> targetWorld;
        final ResourceKey<Level> originalWorld;
        final BlockPos targetBlock;
        final Vec3 targetVec;
        final float yaw;
        final float pitch;

        public VehicleCompundTeleportEntry(Entity vehicle, ResourceKey<Level> targetWorld, ResourceKey<Level> originalWorld, Vec3 targetVec, float yaw, float pitch) {
            this.entity = vehicle;
            this.targetWorld = targetWorld;
            this.originalWorld = originalWorld;
            this.targetVec = targetVec;
            this.targetBlock = new BlockPos(targetVec.m_7096_(), targetVec.m_7098_(), targetVec.m_7094_());
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }

    static class PlayerTeleportEntry {
        final UUID playerUUID;
        final ResourceKey<Level> targetWorld;
        final Vec3 targetVec;
        final float yaw;
        final float pitch;

        public PlayerTeleportEntry(UUID playerUUID, ResourceKey<Level> targetWorld, Vec3 targetVec, float yaw, float pitch) {
            this.playerUUID = playerUUID;
            this.targetWorld = targetWorld;
            this.targetVec = targetVec;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }

    static class EntityTeleportEntry {
        final Entity entity;
        final ResourceKey<Level> targetWorld;
        final ResourceKey<Level> originalWorld;
        final BlockPos targetBlock;
        final float yaw;
        final float pitch;
        final Vec3 targetVec;

        public EntityTeleportEntry(Entity entity, ResourceKey<Level> targetWorld, ResourceKey<Level> originalWorld, Vec3 targetVec, float yaw, float pitch) {
            this.entity = entity;
            this.targetWorld = targetWorld;
            this.originalWorld = originalWorld;
            this.targetBlock = new BlockPos(targetVec.m_7096_(), targetVec.m_7098_(), targetVec.m_7094_());
            this.targetVec = targetVec;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }
}

