/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world.gen.structure;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class StructurePanthalassaLaboratory
extends StructureFeature<JigsawConfiguration> {
    public StructurePanthalassaLaboratory() {
        super(JigsawConfiguration.f_67756_, StructurePanthalassaLaboratory::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    protected static int determineYHeight(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos centerOfChunk = context.f_197355_().m_45615_();
        int landHeight = context.f_197352_().m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_197357_());
        BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
        if (topBlock.m_60819_().m_205070_(FluidTags.f_13131_)) {
            int i = 0;
            while (!topBlock.m_60815_() && centerOfChunk.m_6630_(landHeight - i).m_123342_() > 0) {
                topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_6630_(landHeight - ++i).m_123342_());
            }
            float yHeight = centerOfChunk.m_6630_(landHeight - i).m_123342_();
            return (int)yHeight;
        }
        return 100;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        int yHeight = StructurePanthalassaLaboratory.determineYHeight(context);
        if (yHeight > 42) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        BlockPos blockpos1 = new BlockPos(blockpos.m_123341_(), yHeight, blockpos.m_123343_());
        Optional structurePiecesGenerator = JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos1, (boolean)false, (boolean)false);
        return structurePiecesGenerator;
    }
}

