/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world.gen.structure;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class StructurePanthalassaObservatory
extends StructureFeature<JigsawConfiguration> {
    public StructurePanthalassaObservatory() {
        super(JigsawConfiguration.f_67756_, StructurePanthalassaObservatory::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    protected static int determineYHeight(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        int start = 70;
        BlockPos centerOfChunk = context.f_197355_().m_45615_();
        NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_197357_());
        BlockState topBlock = columnOfBlocks.m_183556_(start);
        int j = 0;
        boolean flag = false;
        while (!topBlock.m_60819_().m_205070_(FluidTags.f_13131_)) {
            topBlock = columnOfBlocks.m_183556_(start - ++j);
            if (start - j >= 0) continue;
            flag = true;
            break;
        }
        int i = 0;
        while (!topBlock.m_60815_()) {
            topBlock = columnOfBlocks.m_183556_(start - j - ++i);
            if (start - j - i >= 0) continue;
            flag = true;
            break;
        }
        if (i > 10 && !flag) {
            return start - j - i;
        }
        return 100;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        int yHeight = StructurePanthalassaObservatory.determineYHeight(context);
        if (yHeight == 100) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        BlockPos blockpos1 = new BlockPos(blockpos.m_123341_(), yHeight, blockpos.m_123343_());
        Optional structurePiecesGenerator = JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos1, (boolean)false, (boolean)false);
        return structurePiecesGenerator;
    }
}

