/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world.processors;

import com.github.sniffity.panthalassa.server.registry.PanthalassaProcessors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class LaboratorySupportProcessor
extends StructureProcessor {
    public static final Codec<LaboratorySupportProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122883_).forGetter(processor -> processor.processorListRegistry), (App)BlockState.f_61039_.fieldOf("start_block").forGetter(processor -> processor.startBlockState), (App)BlockState.f_61039_.fieldOf("support_block").forGetter(processor -> processor.supportBlockState)).apply((Applicative)instance, instance.stable(LaboratorySupportProcessor::new)));
    public final Registry<StructureProcessorList> processorListRegistry;
    public final BlockState startBlockState;
    public final BlockState supportBlockState;

    private LaboratorySupportProcessor(Registry<StructureProcessorList> processorListRegistry, BlockState startBlock, BlockState supportBlock) {
        this.processorListRegistry = processorListRegistry;
        this.startBlockState = startBlock;
        this.supportBlockState = supportBlock;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos templateOffset, BlockPos worldOffset, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.f_74676_;
        if (blockState == this.startBlockState) {
            BlockPos worldPos = structureBlockInfoWorld.f_74675_;
            BlockState replacementState = this.supportBlockState;
            BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)worldPos);
            BlockState currentBlock = levelReader.m_8055_(currentPos.m_7495_());
            while (currentBlock.m_60819_().m_205070_(FluidTags.f_13131_)) {
                StructureTemplate.StructureBlockInfo pillarState = new StructureTemplate.StructureBlockInfo(currentPos.m_7949_(), replacementState, null);
                levelReader.m_46865_((BlockPos)currentPos).m_6978_((BlockPos)currentPos, pillarState.f_74676_, false);
                currentPos.m_122173_(Direction.DOWN);
                currentBlock = levelReader.m_8055_((BlockPos)currentPos);
                if (currentPos.m_123342_() >= 0) continue;
                break;
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, replacementState, null);
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return PanthalassaProcessors.LABORATORY_SUPPORT_PROCESSOR;
    }
}

