/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world.spawn;

import com.github.sniffity.panthalassa.config.PanthalassaCommonConfig;
import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class PanthalassaSpawns {
    public static void registerSpawnPlacementTypes() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.KRONOSAURUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.MEGALODON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.ARCHELON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.MOSASAURUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.COELACANTH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.DUNKLEOSTEUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.LEEDSICHTHYS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.GIANT_ORTHOCONE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.BASILOSAURUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.THALASSOMEDON.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.ACROLEPIS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.CERATODUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.HELICOPRION.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.ANGLERFISH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)PanthalassaEntityTypes.ANOMALOCARIS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, PanthalassaEntity::canPanthalassaEntitySpawn);
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (((Boolean)PanthalassaCommonConfig.COMMON.GENERAL.externalSpawningBoolean.get()).booleanValue()) {
            ResourceLocation biomeName = event.getName();
            if (biomeName == null) {
                return;
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.KRONOSAURUS.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.KRONOSAURUS.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.KRONOSAURUS.get(), PanthalassaCommonConfig.COMMON.ENTITIES.KRONOSAURUS.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.MEGALODON.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.MEGALODON.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.MEGALODON.get(), PanthalassaCommonConfig.COMMON.ENTITIES.MEGALODON.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.ARCHELON.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.ARCHELON.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.ARCHELON.get(), PanthalassaCommonConfig.COMMON.ENTITIES.ARCHELON.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.MOSASAURUS.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.MOSASAURUS.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.MOSASAURUS.get(), PanthalassaCommonConfig.COMMON.ENTITIES.MOSASAURUS.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.COELACANTH.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.COELACANTH.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.COELACANTH.get(), PanthalassaCommonConfig.COMMON.ENTITIES.COELACANTH.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.DUNKLEOSTEUS.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.DUNKLEOSTEUS.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.DUNKLEOSTEUS.get(), PanthalassaCommonConfig.COMMON.ENTITIES.DUNKLEOSTEUS.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.LEEDSICHTHYS.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.LEEDSICHTHYS.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.LEEDSICHTHYS.get(), PanthalassaCommonConfig.COMMON.ENTITIES.LEEDSICHTHYS.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.GIANT_ORTHOCONE.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.GIANT_ORTHOCONE.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.GIANT_ORTHOCONE.get(), PanthalassaCommonConfig.COMMON.ENTITIES.GIANT_ORTHOCONE.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.BASILOSAURUS.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.BASILOSAURUS.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.BASILOSAURUS.get(), PanthalassaCommonConfig.COMMON.ENTITIES.BASILOSAURUS.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.THALASSOMEDON.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.THALASSOMEDON.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.THALASSOMEDON.get(), PanthalassaCommonConfig.COMMON.ENTITIES.THALASSOMEDON.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.ACROLEPIS.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.ACROLEPIS.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.ACROLEPIS.get(), PanthalassaCommonConfig.COMMON.ENTITIES.ACROLEPIS.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.CERATODUS.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.CERATODUS.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.CERATODUS.get(), PanthalassaCommonConfig.COMMON.ENTITIES.CERATODUS.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.HELICOPRION.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.HELICOPRION.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.HELICOPRION.get(), PanthalassaCommonConfig.COMMON.ENTITIES.HELICOPRION.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.ANGLERFISH.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.ANGLERFISH.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.ANGLERFISH.get(), PanthalassaCommonConfig.COMMON.ENTITIES.ANGLERFISH.externalSpawning, MobCategory.MONSTER, event);
            }
            if ((Integer)PanthalassaCommonConfig.COMMON.ENTITIES.ANOMALOCARIS.externalSpawning.spawnRate.get() > 0 && PanthalassaSpawns.isBiomeInConfig(PanthalassaCommonConfig.COMMON.ENTITIES.ANOMALOCARIS.externalSpawning.biomeSpawningConfig, biomeName)) {
                PanthalassaSpawns.registerEntityWorldSpawn((EntityType)PanthalassaEntityTypes.ANOMALOCARIS.get(), PanthalassaCommonConfig.COMMON.ENTITIES.ANOMALOCARIS.externalSpawning, MobCategory.MONSTER, event);
            }
        }
    }

    public static boolean isBiomeInConfig(PanthalassaCommonConfig.BiomeSpawningConfig biomeConfig, ResourceLocation biomeName) {
        String biomeComboString = ((List)biomeConfig.biomeWhitelist.get()).toString();
        String[] biomeStringArray = biomeComboString.toLowerCase().replace(" ", "").split(",");
        return Arrays.asList(biomeStringArray).contains(biomeName.toString());
    }

    private static void registerEntityWorldSpawn(EntityType<?> entity, PanthalassaCommonConfig.ExternalSpawningConfig spawnConfig, MobCategory classification, BiomeLoadingEvent event) {
        event.getSpawns().getSpawner(classification).add(new MobSpawnSettings.SpawnerData(entity, ((Integer)spawnConfig.spawnRate.get()).intValue(), ((Integer)spawnConfig.minGroupSize.get()).intValue(), ((Integer)spawnConfig.maxGroupSize.get()).intValue()));
    }
}

