/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class AccursedLordBoss
extends class_1588
implements IAnimatable,
IAnimationTickable {
    private final class_3213 bossBar;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final class_2940<Boolean> SWORDSLAM = class_2945.method_12791(AccursedLordBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FIREBALLS = class_2945.method_12791(AccursedLordBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> PULL = class_2945.method_12791(AccursedLordBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SPIN = class_2945.method_12791(AccursedLordBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HEATWAVE = class_2945.method_12791(AccursedLordBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> RANDOM = class_2945.method_12791(AccursedLordBoss.class, (class_2941)class_2943.field_13327);

    public AccursedLordBoss(class_1299<? extends AccursedLordBoss> entityType, class_1937 world) {
        super(entityType, world);
        this.bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795).method_5406(true);
        this.field_6194 = 100;
    }

    public boolean method_5753() {
        return true;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getSwordSlam()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.swordSlam"));
        } else if (this.getFireballs()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.shootFireMouth"));
        } else if (this.getPull()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.pull"));
        } else if (this.getSpin()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.spin"));
        } else if (this.getHeatwave()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.explosion"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle"));
        }
        return PlayState.CONTINUE;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new SwordSlamGoal(this));
        this.field_6201.method_6277(1, (class_1352)new ShootFireGoal(this));
        this.field_6201.method_6277(1, (class_1352)new PullAttackGoal(this));
        this.field_6201.method_6277(1, (class_1352)new SpinAttackGoal(this));
        this.field_6201.method_6277(1, (class_1352)new HeatwaveGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1639.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1528.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        super.method_5959();
    }

    public static class_5132.class_5133 createDemonAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23716, 800.0).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23722, 2.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWORDSLAM, (Object)Boolean.FALSE);
        this.field_6011.method_12784(FIREBALLS, (Object)Boolean.FALSE);
        this.field_6011.method_12784(PULL, (Object)Boolean.FALSE);
        this.field_6011.method_12784(SPIN, (Object)Boolean.FALSE);
        this.field_6011.method_12784(HEATWAVE, (Object)Boolean.FALSE);
        this.field_6011.method_12784(RANDOM, (Object)6);
    }

    public void setDataTrackerRandom(int lastAttack) {
        int nextAttack = this.field_5974.nextInt(6);
        if (nextAttack == lastAttack) {
            this.setDataTrackerRandom(lastAttack);
        } else {
            this.field_6011.method_12778(RANDOM, (Object)nextAttack);
        }
    }

    public int getDataTrackerRandom() {
        return (Integer)this.field_6011.method_12789(RANDOM);
    }

    public void setFireballs(boolean attacking) {
        if (!attacking) {
            this.setDataTrackerRandom(2);
        }
        this.field_6011.method_12778(FIREBALLS, (Object)attacking);
    }

    public boolean getFireballs() {
        return (Boolean)this.field_6011.method_12789(FIREBALLS);
    }

    public void setPull(boolean attacking) {
        if (!attacking) {
            this.setDataTrackerRandom(3);
        }
        this.field_6011.method_12778(PULL, (Object)attacking);
    }

    public boolean getPull() {
        return (Boolean)this.field_6011.method_12789(PULL);
    }

    public void setSpin(boolean attacking) {
        if (!attacking) {
            this.setDataTrackerRandom(0);
        }
        this.field_6011.method_12778(SPIN, (Object)attacking);
    }

    public boolean getSpin() {
        return (Boolean)this.field_6011.method_12789(SPIN);
    }

    public void setHeatwave(boolean attacking) {
        if (!attacking) {
            this.setDataTrackerRandom(1);
        }
        this.field_6011.method_12778(HEATWAVE, (Object)attacking);
    }

    public boolean getHeatwave() {
        return (Boolean)this.field_6011.method_12789(HEATWAVE);
    }

    public void setSwordSlam(boolean attacking) {
        if (!attacking) {
            this.setDataTrackerRandom(3);
        }
        this.field_6011.method_12778(SWORDSLAM, (Object)attacking);
    }

    public boolean getSwordSlam() {
        return (Boolean)this.field_6011.method_12789(SWORDSLAM);
    }

    public boolean method_5999() {
        return true;
    }

    public boolean method_17326() {
        return true;
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        ArrayList<class_1542> mainLoot = new ArrayList<class_1542>();
        mainLoot.add(this.method_5706((class_1935)WeaponRegistry.DARKIN_BLADE));
        mainLoot.add(this.method_5706((class_1935)ItemRegistry.LORD_SOUL_RED));
        mainLoot.add(this.method_5706((class_1935)ItemRegistry.WITHERED_DEMON_HEART));
        for (int i = 0; i < mainLoot.size(); ++i) {
            if (mainLoot.get(i) == null) continue;
            ((class_1542)mainLoot.get(i)).method_6976();
        }
    }

    public int tickTimer() {
        return this.field_6012;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void method_5958() {
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    protected class_3414 method_5994() {
        return SoundRegistry.DEMON_BOSS_IDLE_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundRegistry.DEMON_BOSS_HURT_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundRegistry.DEMON_BOSS_DEATH_EVENT;
    }

    static class SwordSlamGoal
    extends class_1352 {
        private final AccursedLordBoss boss;
        private int swordSlamCooldown;
        private int targetNotVisibleTicks;
        private boolean explosionSuccess;

        public SwordSlamGoal(AccursedLordBoss boss) {
            this.boss = boss;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.boss.method_5968();
            return target != null && target.method_5805() && this.boss.method_18395(target) && this.boss.getDataTrackerRandom() > 3;
        }

        public void method_6269() {
            this.explosionSuccess = false;
        }

        public void method_6270() {
            this.targetNotVisibleTicks = 0;
            this.explosionSuccess = false;
            this.boss.setSwordSlam(false);
        }

        public void method_6268() {
            --this.swordSlamCooldown;
            class_1309 target = this.boss.method_5968();
            if (target != null) {
                boolean entityInSight = this.boss.method_5985().method_6369((class_1297)target);
                this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
                double distanceToEntity = this.boss.method_5858((class_1297)target);
                if (distanceToEntity < 90.0) {
                    this.boss.setSwordSlam(true);
                    if (this.swordSlamCooldown == 7 && !this.explosionSuccess) {
                        double e = target.method_23317() - this.boss.method_23317();
                        double g = target.method_23321() - this.boss.method_23321();
                        float explosionPower = 3.0f;
                        this.boss.field_6002.method_8437((class_1297)this.boss, this.boss.method_23317() + e, this.boss.method_23323(0.5), this.boss.method_23321() + g, explosionPower, class_1927.class_4179.field_18685);
                        this.explosionSuccess = true;
                    } else if (target.method_5805() && this.swordSlamCooldown <= 0) {
                        this.swordSlamCooldown = 40;
                        this.boss.setSwordSlam(false);
                        this.explosionSuccess = false;
                    }
                    this.boss.method_5988().method_6226((class_1297)target, 10.0f, 10.0f);
                } else if (this.targetNotVisibleTicks < 5) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                    this.boss.setSwordSlam(false);
                    this.explosionSuccess = true;
                }
                if (distanceToEntity > 20.0) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                }
                super.method_6268();
            }
        }
    }

    static class ShootFireGoal
    extends class_1352 {
        private final AccursedLordBoss boss;
        private int fireballsFired;
        private int fireballCooldown;
        private int targetNotVisibleTicks;

        public ShootFireGoal(AccursedLordBoss boss) {
            this.boss = boss;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.boss.method_5968();
            return target != null && target.method_5805() && this.boss.method_18395(target) && this.boss.getDataTrackerRandom() == 2;
        }

        public void method_6269() {
            this.fireballsFired = 0;
        }

        public void method_6270() {
            this.targetNotVisibleTicks = 0;
            this.boss.setFireballs(false);
        }

        public void method_6268() {
            --this.fireballCooldown;
            class_1309 target = this.boss.method_5968();
            if (target != null) {
                boolean entityInSight = this.boss.method_5985().method_6369((class_1297)target);
                this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
                double distanceToEntity = this.boss.method_5858((class_1297)target);
                if (distanceToEntity < 4.0) {
                    if (!entityInSight) {
                        return;
                    }
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                } else if (distanceToEntity < this.getFollowRange() * this.getFollowRange() && entityInSight) {
                    int fireSprayCount = 8;
                    double e = target.method_23317() - this.boss.method_23317();
                    double f = target.method_23323(0.5) - this.boss.method_23323(1.0);
                    double g = target.method_23321() - this.boss.method_23321();
                    if (this.fireballCooldown <= 0) {
                        ++this.fireballsFired;
                        this.boss.setFireballs(true);
                        if (this.fireballsFired == 1) {
                            this.fireballCooldown = 30;
                        } else if (this.fireballsFired <= 10) {
                            this.fireballCooldown = 3;
                        } else {
                            this.fireballCooldown = 50;
                            this.fireballsFired = 0;
                            this.boss.setFireballs(false);
                        }
                        if (this.fireballsFired > 1) {
                            double h = Math.sqrt(Math.sqrt(distanceToEntity)) * 0.5;
                            this.boss.field_6002.method_8396(null, this.boss.method_24515(), class_3417.field_14970, class_3419.field_15248, 1.0f, 1.0f);
                            for (int i = 0; i < fireSprayCount; ++i) {
                                class_1677 smallFireballEntity = new class_1677(this.boss.field_6002, (class_1309)this.boss, e + this.boss.method_6051().nextGaussian() * h, f, g + this.boss.method_6051().nextGaussian() * h);
                                smallFireballEntity.method_5814(smallFireballEntity.method_23317(), this.boss.method_23323(1.0) - 1.5, smallFireballEntity.method_23321());
                                this.boss.field_6002.method_8649((class_1297)smallFireballEntity);
                            }
                        }
                    }
                    this.boss.method_5988().method_6226((class_1297)target, 10.0f, 10.0f);
                } else if (this.targetNotVisibleTicks < 5) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                }
                if (distanceToEntity > 10.0) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                }
                super.method_6268();
            }
        }

        private double getFollowRange() {
            return this.boss.method_26825(class_5134.field_23717);
        }
    }

    static class PullAttackGoal
    extends class_1352 {
        private final AccursedLordBoss boss;
        private int pullCooldown;
        private int targetNotVisibleTicks;

        public PullAttackGoal(AccursedLordBoss boss) {
            this.boss = boss;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.boss.method_5968();
            return target != null && target.method_5805() && this.boss.method_18395(target) && this.boss.getDataTrackerRandom() == 3;
        }

        public void method_6269() {
            this.pullCooldown = 50;
        }

        public void method_6270() {
            this.targetNotVisibleTicks = 0;
            this.boss.setPull(false);
        }

        public void method_6268() {
            --this.pullCooldown;
            class_1309 target = this.boss.method_5968();
            if (target != null) {
                boolean entityInSight = this.boss.method_5985().method_6369((class_1297)target);
                this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
                double distanceToEntity = this.boss.method_5858((class_1297)target);
                if (distanceToEntity < this.getFollowRange() * this.getFollowRange() && entityInSight) {
                    this.boss.setPull(true);
                    if (this.pullCooldown == 15) {
                        double x = target.method_23317() - this.boss.method_23317();
                        double z = target.method_23321() - this.boss.method_23321();
                        target.method_5643(class_1282.method_5511((class_1309)this.boss), 10.0f);
                        target.method_6005(5.0, x, z);
                    } else if (this.pullCooldown <= 0) {
                        this.boss.setPull(false);
                        this.pullCooldown = 50;
                    }
                    this.boss.method_5988().method_6226((class_1297)target, 10.0f, 10.0f);
                } else if (this.targetNotVisibleTicks < 5) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                    if (this.pullCooldown <= 0) {
                        this.boss.setPull(false);
                    }
                }
                if (distanceToEntity > 10.0) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                }
                super.method_6268();
            }
        }

        private double getFollowRange() {
            return this.boss.method_26825(class_5134.field_23717);
        }
    }

    static class SpinAttackGoal
    extends class_1352 {
        private final AccursedLordBoss boss;
        private int spinCooldown;
        private int targetNotVisibleTicks;

        public SpinAttackGoal(AccursedLordBoss boss) {
            this.boss = boss;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.boss.method_5968();
            return target != null && target.method_5805() && this.boss.method_18395(target) && this.boss.getDataTrackerRandom() == 0;
        }

        public void method_6269() {
            this.spinCooldown = 90;
        }

        public void method_6270() {
            this.targetNotVisibleTicks = 0;
            this.boss.setSpin(false);
        }

        public void method_6268() {
            --this.spinCooldown;
            class_1309 target = this.boss.method_5968();
            if (target != null) {
                boolean entityInSight = this.boss.method_5985().method_6369((class_1297)target);
                this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
                double distanceToEntity = this.boss.method_5858((class_1297)target);
                if (distanceToEntity < this.getFollowRange() * this.getFollowRange() && entityInSight) {
                    this.boss.setSpin(true);
                    if (this.spinCooldown <= 70 && this.spinCooldown >= 10) {
                        class_238 chunkBox = new class_238(this.boss.method_23317() - 7.0, this.boss.method_23318() - 1.0, this.boss.method_23321() - 7.0, this.boss.method_23317() + 7.0, this.boss.method_23318() + 1.0, this.boss.method_23321() + 7.0);
                        List nearbyEntities = this.boss.field_6002.method_8335((class_1297)this.boss, chunkBox);
                        for (int j = 0; j < nearbyEntities.size(); ++j) {
                            if (!(nearbyEntities.get(j) instanceof class_1309)) continue;
                            class_1309 closestTarget = (class_1309)nearbyEntities.get(j);
                            double x = closestTarget.method_23317() - this.boss.method_23317();
                            double z = closestTarget.method_23321() - this.boss.method_23321();
                            closestTarget.method_5643(class_1282.method_5511((class_1309)this.boss), 10.0f);
                            closestTarget.method_6005(7.0, -x, -z);
                        }
                    } else if (this.spinCooldown <= 0) {
                        this.boss.setSpin(false);
                        this.spinCooldown = 90;
                    }
                    this.boss.method_5988().method_6226((class_1297)target, 10.0f, 10.0f);
                } else if (this.targetNotVisibleTicks < 5) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                    if (this.spinCooldown <= 0) {
                        this.boss.setSpin(false);
                    }
                }
                if (distanceToEntity > 10.0) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                }
                super.method_6268();
            }
        }

        private double getFollowRange() {
            return this.boss.method_26825(class_5134.field_23717);
        }
    }

    static class HeatwaveGoal
    extends class_1352 {
        private final AccursedLordBoss boss;
        private int explosionCooldown;
        private int targetNotVisibleTicks;

        public HeatwaveGoal(AccursedLordBoss boss) {
            this.boss = boss;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.boss.method_5968();
            return target != null && target.method_5805() && this.boss.method_18395(target) && this.boss.getDataTrackerRandom() == 1;
        }

        public void method_6269() {
            this.explosionCooldown = 60;
        }

        public void method_6270() {
            this.targetNotVisibleTicks = 0;
            this.boss.setHeatwave(false);
        }

        public void method_6268() {
            --this.explosionCooldown;
            class_1309 target = this.boss.method_5968();
            if (target != null) {
                boolean entityInSight = this.boss.method_5985().method_6369((class_1297)target);
                this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
                double distanceToEntity = this.boss.method_5858((class_1297)target);
                if (distanceToEntity < this.getFollowRange() * this.getFollowRange() && entityInSight) {
                    this.boss.setHeatwave(true);
                    this.boss.method_6092(new class_1293(class_1294.field_5907, 1, 10));
                    if (this.explosionCooldown <= 30 && this.explosionCooldown >= 25) {
                        class_238 chunkBox = new class_238(this.boss.method_23317() - 3.0, this.boss.method_23318() - 1.0, this.boss.method_23321() - 3.0, this.boss.method_23317() + 3.0, this.boss.method_23318() + 1.0, this.boss.method_23321() + 3.0);
                        List nearbyEntities = this.boss.field_6002.method_8335((class_1297)this.boss, chunkBox);
                        for (int j = 0; j < nearbyEntities.size(); ++j) {
                            if (!(nearbyEntities.get(j) instanceof class_1309)) continue;
                            class_1309 closestTarget = (class_1309)nearbyEntities.get(j);
                            double x = closestTarget.method_23317() - this.boss.method_23317();
                            double z = closestTarget.method_23321() - this.boss.method_23321();
                            closestTarget.method_6005(20.0, -x, -z);
                            closestTarget.method_5643(class_1282.method_5511((class_1309)this.boss), 30.0f);
                        }
                        for (int i = 0; i < 4; ++i) {
                            this.boss.field_6002.method_8437((class_1297)this.boss, this.boss.method_23317() + (double)i - (double)this.boss.field_5974.nextInt(5), this.boss.method_23323(0.5) + (double)i, this.boss.method_23321() + (double)i - (double)this.boss.field_5974.nextInt(5), 5.0f, class_1927.class_4179.field_18685);
                        }
                    } else if (this.explosionCooldown <= 0) {
                        this.boss.setHeatwave(false);
                        this.explosionCooldown = 60;
                    }
                    this.boss.method_5988().method_6226((class_1297)target, 10.0f, 10.0f);
                } else if (this.targetNotVisibleTicks < 5) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                    if (this.explosionCooldown <= 0) {
                        this.boss.setHeatwave(false);
                    }
                }
                if (distanceToEntity > 10.0) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                }
                super.method_6268();
            }
        }

        private double getFollowRange() {
            return this.boss.method_26825(class_5134.field_23717);
        }
    }
}

