/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1811;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.soulsweaponry.entity.mobs.NightShade;
import net.soulsweaponry.registry.WeaponRegistry;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DraugrBoss
extends class_1588
implements IAnimatable,
IAnimationTickable {
    private final class_3213 bossBar;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final class_2940<Boolean> SHIELD_UP = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHIELD_DOWN = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHIELD_STANCE = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHIELD_BASH = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> COUNTER = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> POSTURE_BREAK = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13323);

    public DraugrBoss(class_1299<? extends DraugrBoss> entityType, class_1937 world) {
        super(entityType, world);
        this.bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795).method_5406(true);
        this.field_6194 = 100;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getPostureBreak()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("posture_break"));
        } else if (this.getShieldUp() && !this.getShieldStance()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("start_block"));
            this.setShieldStance(true);
        } else if (this.getShieldStance() && this.getShieldDown()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("stop_block"));
            this.setShieldDown(false);
            this.setShieldStance(false);
        } else if (this.getShieldBash() && !this.getCounter()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("shield_bash"));
        } else if (this.getCounter() && !this.getShieldBash()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("counter"));
        } else if (this.method_6510() && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            if (this.getShieldStance()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("block_stance"));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("walk"));
            }
        }
        return PlayState.CONTINUE;
    }

    public static class_5132.class_5133 createBossAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 60.0).method_26868(class_5134.field_23716, 200.0).method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 6.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHIELD_UP, (Object)Boolean.FALSE);
        this.field_6011.method_12784(SHIELD_DOWN, (Object)Boolean.FALSE);
        this.field_6011.method_12784(SHIELD_STANCE, (Object)Boolean.FALSE);
        this.field_6011.method_12784(SHIELD_BASH, (Object)Boolean.FALSE);
        this.field_6011.method_12784(COUNTER, (Object)Boolean.FALSE);
        this.field_6011.method_12784(POSTURE_BREAK, (Object)Boolean.FALSE);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new DraugrBossGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        super.method_5959();
    }

    public void setShieldUp(boolean bl) {
        this.field_6011.method_12778(SHIELD_UP, (Object)bl);
    }

    public boolean getShieldUp() {
        return (Boolean)this.field_6011.method_12789(SHIELD_UP);
    }

    public void setShieldDown(boolean bl) {
        this.field_6011.method_12778(SHIELD_DOWN, (Object)bl);
    }

    public boolean getShieldDown() {
        return (Boolean)this.field_6011.method_12789(SHIELD_DOWN);
    }

    public void setShieldStance(boolean bl) {
        this.field_6011.method_12778(SHIELD_STANCE, (Object)bl);
    }

    public boolean getShieldStance() {
        return (Boolean)this.field_6011.method_12789(SHIELD_STANCE);
    }

    public void setShieldBash(boolean bl) {
        this.field_6011.method_12778(SHIELD_BASH, (Object)bl);
    }

    public boolean getShieldBash() {
        return (Boolean)this.field_6011.method_12789(SHIELD_BASH);
    }

    public void setCounter(boolean bl) {
        this.field_6011.method_12778(COUNTER, (Object)bl);
    }

    public boolean getCounter() {
        return (Boolean)this.field_6011.method_12789(COUNTER);
    }

    public void setPostureBreak(boolean bl) {
        this.field_6011.method_12778(POSTURE_BREAK, (Object)bl);
    }

    public boolean getPostureBreak() {
        return (Boolean)this.field_6011.method_12789(POSTURE_BREAK);
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_6032() <= this.method_6063() / 2.0f) {
            this.method_6092(new class_1293(class_1294.field_5904, 10, 1));
            this.method_6092(new class_1293(class_1294.field_5910, 10, 1));
            for (int i = 0; i < 2; ++i) {
                this.field_6002.method_8406((class_2394)class_2398.field_11237, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean method_5999() {
        return true;
    }

    public boolean method_5753() {
        return true;
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        NightShade entity = new NightShade(this.field_6002);
        entity.method_23327(this.method_23317(), this.method_23318() + (double)0.1f, this.method_23321());
        this.field_6002.method_8649((class_1297)entity);
    }

    public int tickTimer() {
        return this.field_6012;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean method_17326() {
        return true;
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        class_1542 soul = this.method_5706((class_1935)WeaponRegistry.DRAUGR);
        if (soul != null) {
            soul.method_6976();
        }
    }

    protected void method_5958() {
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    protected class_3414 method_5994() {
        return class_3417.field_15214;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15027;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15122;
    }

    class_3414 getStepSound() {
        return class_3417.field_14955;
    }

    static class DraugrBossGoal
    extends class_1352 {
        private final DraugrBoss boss;
        private int targetNotVisibleTicks;
        private int attackCooldown;
        private int shieldTimer;
        private int postureBreakTimer;
        private double attackRange;
        private boolean hasAttacked;
        private boolean hasShielded;
        private boolean hasPostureBroken;

        public DraugrBossGoal(DraugrBoss boss) {
            this.boss = boss;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.boss.method_5968();
            return target != null && target.method_5805() && this.boss.method_18395(target);
        }

        public void method_6268() {
            class_1309 target;
            --this.attackCooldown;
            --this.shieldTimer;
            --this.postureBreakTimer;
            if (this.attackCooldown < -50) {
                this.attackCooldown = 50;
            }
            if (this.shieldTimer < -50) {
                this.shieldTimer = -5;
            }
            if (this.postureBreakTimer < -50) {
                this.postureBreakTimer = -5;
            }
            if ((target = this.boss.method_5968()) != null) {
                this.boss.method_19540(true);
                boolean entityInSight = this.boss.method_5985().method_6369((class_1297)target);
                this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
                if (this.boss.method_6032() <= this.boss.method_6063() / 1.5f && !this.hasShielded) {
                    this.shieldTimer = 300;
                    this.hasShielded = true;
                }
                if (this.boss.method_6032() <= this.boss.method_6063() / 2.0f && !this.hasPostureBroken) {
                    this.hasPostureBroken = true;
                    this.postureBreakTimer = 50;
                    this.boss.setPostureBreak(true);
                    this.boss.method_6092(new class_1293(class_1294.field_5909, 50, 20));
                }
                if (this.postureBreakTimer < 0) {
                    this.boss.setPostureBreak(false);
                }
                if (target.method_6047().method_7909() instanceof class_1811 || this.shieldTimer > 0) {
                    this.boss.setShieldUp(true);
                    this.boss.setShieldDown(false);
                    this.boss.method_6092(new class_1293(class_1294.field_5909, 1, 1));
                    this.boss.method_6092(new class_1293(class_1294.field_5907, 1, 5));
                } else {
                    this.boss.setShieldUp(false);
                    this.boss.setShieldDown(true);
                }
                double distanceToEntity = this.boss.method_5858((class_1297)target);
                this.attackRange = this.boss.getShieldDown() ? 6.0 : 14.0;
                if (this.targetNotVisibleTicks < 5 && distanceToEntity > this.attackRange) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                }
                if (distanceToEntity > this.attackRange) {
                    this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
                    this.boss.setShieldBash(false);
                    this.boss.setCounter(false);
                } else if (this.attackCooldown < 0 && this.postureBreakTimer < 0) {
                    if (this.boss.getShieldDown()) {
                        this.boss.setShieldBash(false);
                        this.boss.method_6121((class_1297)target);
                        this.attackCooldown = 20;
                    } else {
                        int random = this.boss.field_5974.nextInt(2);
                        if (random == 0) {
                            this.boss.setCounter(false);
                            if (!this.hasAttacked) {
                                this.attackCooldown = 20;
                                this.hasAttacked = true;
                            }
                            this.boss.setShieldBash(true);
                            if (this.attackCooldown < 12) {
                                double x = target.method_23317() - this.boss.method_23317();
                                double z = target.method_23321() - this.boss.method_23321();
                                target.method_5643(class_1282.method_5511((class_1309)this.boss), 8.0f);
                                target.method_6005(4.0, -x, -z);
                                this.boss.setShieldBash(false);
                                this.attackCooldown = 20;
                                this.hasAttacked = false;
                            }
                        } else {
                            this.boss.setShieldBash(false);
                            if (!this.hasAttacked) {
                                this.attackCooldown = 20;
                                this.hasAttacked = true;
                            }
                            this.boss.setCounter(true);
                            if (this.attackCooldown < 12) {
                                double x = target.method_23317() - this.boss.method_23317();
                                double z = target.method_23321() - this.boss.method_23321();
                                target.method_5643(class_1282.method_5511((class_1309)this.boss), 20.0f);
                                target.method_6005(1.0, -x, -z);
                                this.boss.setCounter(false);
                                this.attackCooldown = 20;
                                this.hasAttacked = false;
                            }
                        }
                    }
                }
                super.method_6268();
            }
        }
    }
}

