/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus;

import com.alexander.endermenplus.entities.BarrenerEntity;
import com.alexander.endermenplus.entities.CrimsonSporeEntity;
import com.alexander.endermenplus.entities.CrimsonerEntity;
import com.alexander.endermenplus.entities.DreamlanderEntity;
import com.alexander.endermenplus.entities.FortresserEntity;
import com.alexander.endermenplus.entities.GrasslanderEntity;
import com.alexander.endermenplus.entities.JungleerEntity;
import com.alexander.endermenplus.entities.MarshlanderEntity;
import com.alexander.endermenplus.entities.SeasiderEntity;
import com.alexander.endermenplus.entities.TundramanEntity;
import com.alexander.endermenplus.entities.UndermanEntity;
import com.alexander.endermenplus.entities.WarplanderEntity;
import com.alexander.endermenplus.entities.WastelanderChieftainEntity;
import com.alexander.endermenplus.entities.WastelanderEntity;
import com.alexander.endermenplus.events.CustomSpawnsEvent;
import com.alexander.endermenplus.init.ConfiguredStructureInit;
import com.alexander.endermenplus.init.EntityTypeInit;
import com.alexander.endermenplus.init.ItemInit;
import com.alexander.endermenplus.init.SoundEventInit;
import com.alexander.endermenplus.init.StructureInit;
import com.alexander.endermenplus.items.CustomSpawnEggItem;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="endermenplus")
@Mod.EventBusSubscriber(modid="endermenplus", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EndermenPlus {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "endermenplus";
    private static Method GETCODEC_METHOD;

    public EndermenPlus() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        GeckoLib.initialize();
        SoundEventInit.SOUNDS.register(bus);
        EntityTypeInit.ENTITY_TYPES.register(bus);
        ItemInit.ITEMS.register(bus);
        StructureInit.DEFERRED_REGISTRY_STRUCTURE.register(bus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(CustomSpawnsEvent::initSpawnPlacements);
        DeferredWorkQueue.runLater(() -> {
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.GRASSLANDER.get()), (AttributeModifierMap)GrasslanderEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.BARRENER.get()), (AttributeModifierMap)BarrenerEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.UNDERMAN.get()), (AttributeModifierMap)UndermanEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.MARSHLANDER.get()), (AttributeModifierMap)MarshlanderEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.TUNDRAMAN.get()), (AttributeModifierMap)TundramanEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.SEASIDER.get()), (AttributeModifierMap)SeasiderEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.DREAMLANDER.get()), (AttributeModifierMap)DreamlanderEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.WASTELANDER.get()), (AttributeModifierMap)WastelanderEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.WASTELANDER_CHIEFTAIN.get()), (AttributeModifierMap)WastelanderChieftainEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.FORTRESSER.get()), (AttributeModifierMap)FortresserEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.WARPLANDER.get()), (AttributeModifierMap)WarplanderEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.CRIMSONER.get()), (AttributeModifierMap)CrimsonerEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.JUNGLEER.get()), (AttributeModifierMap)JungleerEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.CRIMSON_SPORE.get()), (AttributeModifierMap)CrimsonSporeEntity.createAttributes().func_233813_a_());
        });
        event.enqueueWork(() -> {
            StructureInit.setupStructures();
            ConfiguredStructureInit.registerConfiguredStructures();
        });
    }

    @SubscribeEvent
    public static void onRegisterEntities(RegistryEvent.Register<EntityType<?>> event) {
        CustomSpawnEggItem.initSpawnEggs();
    }

    public void biomeModification(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.ICY) {
            event.getGeneration().getStructures().add(() -> ConfiguredStructureInit.CONFIGURED_TUNDRAMAN_BULB);
        }
        if (event.getCategory() == Biome.Category.SWAMP) {
            event.getGeneration().getStructures().add(() -> ConfiguredStructureInit.CONFIGURED_MARSH_MOUND);
        }
        if (event.getCategory() == Biome.Category.NETHER && event.getName() != Biomes.field_235251_aB_.getRegistryName()) {
            event.getGeneration().getStructures().add(() -> ConfiguredStructureInit.CONFIGURED_WASTELANDER_VILLAGE);
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(StructureInit.TUNDRAMAN_BULB.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.TUNDRAMAN_BULB.get()));
            tempMap.putIfAbsent(StructureInit.MARSH_MOUND.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.MARSH_MOUND.get()));
            tempMap.putIfAbsent(StructureInit.WASTELANDER_VILLAGE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.WASTELANDER_VILLAGE.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

