/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.entities;

import com.alexander.endermenplus.entities.MarshlanderEntity;
import com.alexander.endermenplus.entities.TundramanEntity;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;

public abstract class AbstractEndermanVariant
extends MonsterEntity
implements IAngerable,
IAnimatable {
    public static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    public static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    public static final DataParameter<Optional<BlockState>> DATA_CARRY_STATE = EntityDataManager.func_187226_a(AbstractEndermanVariant.class, (IDataSerializer)DataSerializers.field_187197_g);
    public static final DataParameter<Boolean> DATA_CREEPY = EntityDataManager.func_187226_a(AbstractEndermanVariant.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> DATA_STARED_AT = EntityDataManager.func_187226_a(AbstractEndermanVariant.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> ATTACKING = EntityDataManager.func_187226_a(AbstractEndermanVariant.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Predicate<LivingEntity> ENDERMITE_SELECTOR = p_213626_0_ -> p_213626_0_ instanceof EndermiteEntity && ((EndermiteEntity)p_213626_0_).func_175495_n();
    public int lastStareSound = Integer.MIN_VALUE;
    private int targetChangeTime;
    private static final RangedInteger PERSISTENT_ANGER_TIME = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public AbstractEndermanVariant(EntityType<? extends AbstractEndermanVariant> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233824_g_, 1.75).func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    public void func_70624_b(@Nullable LivingEntity p_70624_1_) {
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (p_70624_1_ == null) {
            this.targetChangeTime = 0;
            this.field_70180_af.func_187227_b(DATA_CREEPY, (Object)false);
            this.field_70180_af.func_187227_b(DATA_STARED_AT, (Object)false);
            modifiableattributeinstance.func_111124_b(SPEED_MODIFIER_ATTACKING);
        } else {
            this.targetChangeTime = this.field_70173_aa;
            this.field_70180_af.func_187227_b(DATA_CREEPY, (Object)true);
            if (!modifiableattributeinstance.func_180374_a(SPEED_MODIFIER_ATTACKING) && this.shouldChangeSpeed()) {
                modifiableattributeinstance.func_233767_b_(SPEED_MODIFIER_ATTACKING);
            }
        }
        super.func_70624_b(p_70624_1_);
    }

    public boolean shouldChangeSpeed() {
        return true;
    }

    public boolean shouldAttackOnStare() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_CARRY_STATE, Optional.empty());
        this.field_70180_af.func_187214_a(DATA_CREEPY, (Object)false);
        this.field_70180_af.func_187214_a(DATA_STARED_AT, (Object)false);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)0);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.isAttacking() > 0) {
            this.setAttacking(this.isAttacking() - 1);
        }
    }

    public int isAttacking() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)p_189794_1_);
    }

    public void func_230258_H__() {
        this.func_230260_a__(PERSISTENT_ANGER_TIME.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int p_230260_1_) {
        this.remainingPersistentAngerTime = p_230260_1_;
    }

    public int func_230256_F__() {
        return this.remainingPersistentAngerTime;
    }

    public void func_230259_a_(@Nullable UUID p_230259_1_) {
        this.persistentAngerTarget = p_230259_1_;
    }

    public UUID func_230257_G__() {
        return this.persistentAngerTarget;
    }

    public void playStareSound() {
        if (this.field_70173_aa >= this.lastStareSound + 400) {
            this.lastStareSound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (DATA_CREEPY.equals(p_184206_1_) && this.hasBeenStaredAt() && this.field_70170_p.field_72995_K) {
            this.playStareSound();
        }
        super.func_184206_a(p_184206_1_);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        BlockState blockstate = this.getCarriedBlock();
        if (blockstate != null) {
            p_213281_1_.func_218657_a("carriedBlockState", (INBT)NBTUtil.func_190009_a((BlockState)blockstate));
        }
        this.func_233682_c_(p_213281_1_);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        BlockState blockstate = null;
        if (p_70037_1_.func_150297_b("carriedBlockState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)p_70037_1_.func_74775_l("carriedBlockState"))).func_196958_f()) {
            blockstate = null;
        }
        this.setCarriedBlock(blockstate);
        if (!this.field_70170_p.field_72995_K) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, p_70037_1_);
        }
    }

    private boolean isLookingAtMe(PlayerEntity p_70821_1_) {
        ItemStack itemstack = (ItemStack)p_70821_1_.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() == Items.field_221689_cG || !this.shouldAttackOnStare()) {
            return false;
        }
        Vector3d vector3d = p_70821_1_.func_70676_i(1.0f).func_72432_b();
        Vector3d vector3d1 = new Vector3d(this.func_226277_ct_() - p_70821_1_.func_226277_ct_(), this.func_226280_cw_() - p_70821_1_.func_226280_cw_(), this.func_226281_cx_() - p_70821_1_.func_226281_cx_());
        double d0 = vector3d1.func_72433_c();
        double d1 = vector3d.func_72430_b(vector3d1 = vector3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? p_70821_1_.func_70685_l((Entity)this) : false;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 2.55f;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.field_70703_bu = false;
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
        super.func_70636_d();
    }

    public boolean func_230270_dK_() {
        return true;
    }

    public boolean shouldTeleportInDay() {
        return true;
    }

    protected void func_70619_bc() {
        float f;
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.targetChangeTime + 600 && this.shouldTeleportInDay() && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_226660_f_(this.func_233580_cy_()) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.teleport();
        }
        super.func_70619_bc();
    }

    protected boolean teleport() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vector3d vector3d = new Vector3d(this.func_226277_ct_() - p_70816_1_.func_226277_ct_(), this.func_226283_e_(0.5) - p_70816_1_.func_226280_cw_(), this.func_226281_cx_() - p_70816_1_.func_226281_cx_());
        vector3d = vector3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72450_a * 16.0;
        double d2 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - vector3d.field_72448_b * 16.0;
        double d3 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72449_c * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, p_70825_1_, p_70825_3_, p_70825_5_, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.isCreepy() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.func_213333_a(p_213333_1_, p_213333_2_, p_213333_3_);
        BlockState blockstate = this.getCarriedBlock();
        if (blockstate != null) {
            this.func_199703_a((IItemProvider)blockstate.func_177230_c());
        }
    }

    public void setCarriedBlock(@Nullable BlockState p_195406_1_) {
        this.field_70180_af.func_187227_b(DATA_CARRY_STATE, Optional.ofNullable(p_195406_1_));
    }

    @Nullable
    public BlockState getCarriedBlock() {
        return ((Optional)this.field_70180_af.func_187225_a(DATA_CARRY_STATE)).orElse(null);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (p_70097_1_ instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.func_70097_a(p_70097_1_, p_70097_2_);
        if (!this.field_70170_p.func_201670_d() && !(p_70097_1_.func_76346_g() instanceof LivingEntity) && this.field_70146_Z.nextInt(10) != 0) {
            this.teleport();
        }
        return flag;
    }

    public boolean isCreepy() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_CREEPY);
    }

    public boolean hasBeenStaredAt() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_STARED_AT);
    }

    public void setBeingStaredAt() {
        this.field_70180_af.func_187227_b(DATA_STARED_AT, (Object)true);
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.getCarriedBlock() != null;
    }

    public static class TakeBlockGoal
    extends Goal {
        private final AbstractEndermanVariant enderman;

        public TakeBlockGoal(AbstractEndermanVariant p_i45841_1_) {
            this.enderman = p_i45841_1_;
        }

        public boolean func_75250_a() {
            if (this.enderman.getCarriedBlock() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(20) == 0;
        }

        public void func_75246_d() {
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.func_226277_ct_() - 2.0 + random.nextDouble() * 4.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.func_226278_cu_() + random.nextDouble() * 3.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.func_226281_cx_() - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            Vector3d vector3d = new Vector3d((double)MathHelper.func_76128_c((double)this.enderman.func_226277_ct_()) + 0.5, (double)j + 0.5, (double)MathHelper.func_76128_c((double)this.enderman.func_226281_cx_()) + 0.5);
            Vector3d vector3d1 = new Vector3d((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockRayTraceResult blockraytraceresult = world.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.enderman));
            boolean flag = blockraytraceresult.func_216350_a().equals((Object)blockpos);
            if (block.func_203417_a((ITag)BlockTags.field_201151_l) && flag) {
                world.func_217377_a(blockpos, false);
                this.enderman.setCarriedBlock(blockstate.func_177230_c().func_176223_P());
            }
        }
    }

    public static class StareGoal
    extends Goal {
        private final AbstractEndermanVariant enderman;
        private LivingEntity target;

        public StareGoal(AbstractEndermanVariant p_i50520_1_) {
            this.enderman = p_i50520_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.target = this.enderman.func_70638_az();
            if (!(this.target instanceof PlayerEntity)) {
                return false;
            }
            double d0 = this.target.func_70068_e((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.isLookingAtMe((PlayerEntity)this.target);
        }

        public void func_75249_e() {
            this.enderman.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.enderman.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
        }
    }

    public static class PlaceBlockGoal
    extends Goal {
        private final AbstractEndermanVariant enderman;

        public PlaceBlockGoal(AbstractEndermanVariant p_i45843_1_) {
            this.enderman = p_i45843_1_;
        }

        public boolean func_75250_a() {
            if (this.enderman.getCarriedBlock() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.func_226277_ct_() - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.func_226278_cu_() + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.func_226281_cx_() - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate1 = world.func_180495_p(blockpos1);
            BlockState blockstate2 = this.enderman.getCarriedBlock();
            if (blockstate2 != null && this.canPlaceBlock(world, blockpos, blockstate2 = Block.func_199770_b((BlockState)blockstate2, (IWorld)this.enderman.field_70170_p, (BlockPos)blockpos), blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.enderman, (BlockSnapshot)BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)blockpos1), (Direction)Direction.UP)) {
                world.func_180501_a(blockpos, blockstate2, 3);
                this.enderman.setCarriedBlock(null);
            }
        }

        private boolean canPlaceBlock(World p_220836_1_, BlockPos p_220836_2_, BlockState p_220836_3_, BlockState p_220836_4_, BlockState p_220836_5_, BlockPos p_220836_6_) {
            return p_220836_4_.isAir((IBlockReader)p_220836_1_, p_220836_2_) && !p_220836_5_.isAir((IBlockReader)p_220836_1_, p_220836_6_) && !p_220836_5_.func_203425_a(Blocks.field_150357_h) && !p_220836_5_.func_235714_a_((ITag)Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST) && p_220836_5_.func_235785_r_((IBlockReader)p_220836_1_, p_220836_6_) && p_220836_3_.func_196955_c((IWorldReader)p_220836_1_, p_220836_2_) && p_220836_1_.func_72839_b((Entity)this.enderman, AxisAlignedBB.func_241549_a_((Vector3d)Vector3d.func_237491_b_((Vector3i)p_220836_2_))).isEmpty();
        }
    }

    public static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final AbstractEndermanVariant enderman;
        private PlayerEntity pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final EntityPredicate startAggroTargetConditions;
        private final EntityPredicate continueAggroTargetConditions = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(AbstractEndermanVariant p_i241912_1_, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((MobEntity)p_i241912_1_, PlayerEntity.class, 10, false, false, p_i241912_2_);
            this.enderman = p_i241912_1_;
            this.startAggroTargetConditions = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> p_i241912_1_.isLookingAtMe((PlayerEntity)p_220790_1_));
        }

        public boolean func_75250_a() {
            this.pendingTarget = this.enderman.field_70170_p.func_217370_a(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.setBeingStaredAt();
        }

        public void func_75251_c() {
            this.pendingTarget = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.pendingTarget != null) {
                if (!this.enderman.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.enderman.func_70625_a((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.continueAggroTargetConditions.func_221015_a((LivingEntity)this.enderman, this.field_75309_a) ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.enderman.func_70638_az() == null) {
                super.func_234054_a_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.pendingTarget;
                    this.pendingTarget = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.enderman.func_184218_aH()) {
                    if (this.enderman.isLookingAtMe((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)this.enderman) < 16.0) {
                            this.enderman.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportTowards((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public final EntityPredicate slimePredicate;

        public AttackGoal() {
            super((CreatureEntity)AbstractEndermanVariant.this, 1.0, true);
            this.slimePredicate = new EntityPredicate().func_221013_a(20.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return this.field_75441_b.func_213311_cf() * 3.0f * this.field_75441_b.func_213311_cf() * 3.0f + p_179512_1_.func_213311_cf();
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (AbstractEndermanVariant.this.field_70170_p.func_217374_a(SlimeEntity.class, this.slimePredicate, (LivingEntity)AbstractEndermanVariant.this, AbstractEndermanVariant.this.func_174813_aQ().func_186662_g(20.0)).size() < 5 && AbstractEndermanVariant.this instanceof MarshlanderEntity && ((MarshlanderEntity)AbstractEndermanVariant.this).getSummonTime() <= -40 && ((AbstractEndermanVariant)((MarshlanderEntity)AbstractEndermanVariant.this)).field_70146_Z.nextInt(100) == 0) {
                ((MarshlanderEntity)AbstractEndermanVariant.this).setSummonTime(70);
                ((MarshlanderEntity)AbstractEndermanVariant.this).func_184185_a(SoundEvents.field_187810_eg, 3.0f, 0.5f);
            }
            if (AbstractEndermanVariant.this instanceof TundramanEntity && ((TundramanEntity)AbstractEndermanVariant.this).getSummonTime() <= -40 && ((AbstractEndermanVariant)((TundramanEntity)AbstractEndermanVariant.this)).field_70146_Z.nextInt(75) == 0) {
                ((TundramanEntity)AbstractEndermanVariant.this).setSummonTime(80);
                ((TundramanEntity)AbstractEndermanVariant.this).func_184185_a(SoundEvents.field_191244_bn, 3.0f, 1.0f);
            }
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                if (!(AbstractEndermanVariant.this instanceof MarshlanderEntity) && !(AbstractEndermanVariant.this instanceof TundramanEntity) || AbstractEndermanVariant.this instanceof MarshlanderEntity && ((MarshlanderEntity)AbstractEndermanVariant.this).getSummonTime() <= 0 || AbstractEndermanVariant.this instanceof TundramanEntity && ((TundramanEntity)AbstractEndermanVariant.this).getSummonTime() <= 0) {
                    this.field_75441_b.func_70652_k((Entity)p_190102_1_);
                }
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 30) {
                    AbstractEndermanVariant.this.setAttacking(30);
                }
            } else {
                this.func_234039_g_();
            }
        }
    }
}

