/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.entities;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CrimsonerEntity
extends AbstractEndermanVariant
implements IAnimatable {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final DataParameter<Float> AGE = EntityDataManager.func_187226_a(CrimsonerEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MAX_AGE = EntityDataManager.func_187226_a(CrimsonerEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public CrimsonerEntity(EntityType<? extends CrimsonerEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getAge() < this.getMaxAge()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("crimsoner_growing", Boolean.valueOf(true)));
        } else if (this.isAttacking() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("crimsoner_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            if (this.isCreepy()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("crimsoner_run", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("crimsoner_walk", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("crimsoner_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AbstractEndermanVariant.StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AbstractEndermanVariant.AttackGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new AbstractEndermanVariant.PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new AbstractEndermanVariant.TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AbstractEndermanVariant.FindPlayerGoal(this, arg_0 -> ((CrimsonerEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, ENDERMITE_SELECTOR));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, ILivingEntityData p_213386_4_, CompoundNBT p_213386_5_) {
        this.setMaxAge(0.75f + (float)this.field_70146_Z.nextInt(75) / 100.0f);
        this.setAge(1.0f * this.getMaxAge());
        this.func_213323_x_();
        this.func_226264_Z_();
        System.out.print("\r\nAge: " + this.getMaxAge());
        System.out.print("\r\nMax Age: " + this.getMaxAge());
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.getAge() < this.getMaxAge()) {
            this.setAge(this.getAge() + 3.3333333E-4f);
            this.func_213323_x_();
            this.func_226264_Z_();
        }
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return super.func_213305_a(p_213305_1_).func_220313_a(1.0f * this.getAge());
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(MAX_AGE, (Object)Float.valueOf(1.0f));
    }

    @Override
    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (AGE.equals(p_184206_1_)) {
            this.func_213323_x_();
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(p_184206_1_);
    }

    public float getAge() {
        return ((Float)this.field_70180_af.func_187225_a(AGE)).floatValue();
    }

    public void setAge(float p_191997_1_) {
        this.field_70180_af.func_187227_b(AGE, (Object)Float.valueOf(p_191997_1_));
    }

    public float getMaxAge() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_AGE)).floatValue();
    }

    public void setMaxAge(float p_191997_1_) {
        this.field_70180_af.func_187227_b(MAX_AGE, (Object)Float.valueOf(p_191997_1_));
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74776_a("Age", this.getAge());
        p_213281_1_.func_74776_a("MaxAge", this.getMaxAge());
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setAge(p_70037_1_.func_74760_g("Age"));
        this.setMaxAge(p_70037_1_.func_74760_g("MaxAge"));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    @Override
    public boolean shouldAttackOnStare() {
        return false;
    }

    @Override
    public boolean shouldTeleportInDay() {
        return false;
    }

    @Override
    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 3.7f * this.getAge();
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

