/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.entities;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import com.alexander.endermenplus.entities.DreamBoltEntity;
import com.alexander.endermenplus.init.DamageSourceInit;
import com.alexander.endermenplus.init.EntityTypeInit;
import com.alexander.endermenplus.init.SoundEventInit;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DreamlanderEntity
extends AbstractEndermanVariant
implements IAnimatable {
    private final EntityPredicate vexCountTargeting = new EntityPredicate().func_221013_a(100.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static final DataParameter<Integer> THROW_SLEEP_POWDER_TIME = EntityDataManager.func_187226_a(DreamlanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SPLIT_TIME = EntityDataManager.func_187226_a(DreamlanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int rangedAttackInterval = 40;

    public DreamlanderEntity(EntityType<? extends DreamlanderEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getSplitTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dreamlander_split", Boolean.valueOf(true)));
        } else if (this.getThrowSleepPowderTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dreamlander_throw_sleep_powder", Boolean.valueOf(true)));
        } else if (this.isAttacking() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dreamlander_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dreamlander_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dreamlander_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AbstractEndermanVariant.StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AbstractEndermanVariant.AttackGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new AbstractEndermanVariant.PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new AbstractEndermanVariant.TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AbstractEndermanVariant.FindPlayerGoal(this, arg_0 -> ((DreamlanderEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, ENDERMITE_SELECTOR));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true, false));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(500) == 0) {
            this.func_70106_y();
        }
        if (this.func_70638_az() != null && this.rangedAttackInterval > 0) {
            --this.rangedAttackInterval;
        }
        if (this.func_70638_az() != null && this.rangedAttackInterval == 0) {
            this.rangedAttackInterval = 40;
            this.setAttacking(45);
        }
        if (this.func_70638_az() != null && this.isAttacking() == 15) {
            this.performRangedAttack(this.func_70638_az());
        }
        if (this.getThrowSleepPowderTime() > 0) {
            this.setThrowSleepPowderTime(this.getThrowSleepPowderTime() - 1);
        }
        if (this.getSplitTime() > 0) {
            this.setSplitTime(this.getSplitTime() - 1);
        }
        if (this.func_70638_az() != null && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_217374_a(DreamlanderEntity.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_186662_g(100.0)).size() < 5) {
            this.setSplitTime(40);
        }
        if (this.func_70638_az() != null && this.getSplitTime() == 20 && !this.field_70170_p.field_72995_K) {
            ServerWorld serverworld = (ServerWorld)this.field_70170_p;
            DreamlanderEntity vexentity = (DreamlanderEntity)((EntityType)EntityTypeInit.DREAMLANDER.get()).func_200721_a(this.field_70170_p);
            vexentity.func_174828_a(this.func_233580_cy_(), 0.0f, 0.0f);
            vexentity.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
            vexentity.func_70624_b(this.func_70638_az());
            serverworld.func_242417_l((Entity)vexentity);
        }
        if (this.func_70638_az() != null && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_217374_a(LivingEntity.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_186662_g(15.0)).size() > 0) {
            this.setThrowSleepPowderTime(110);
        }
        if (this.getThrowSleepPowderTime() == 75) {
            for (LivingEntity entity : this.field_70170_p.func_217374_a(LivingEntity.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_186662_g(15.0))) {
                if (entity.func_70608_bn()) continue;
                entity.func_213342_e(entity.func_233580_cy_());
                entity.func_70097_a(DamageSourceInit.dreamlanderAttack((LivingEntity)this), 10.0f);
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 2));
                entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 100, 1));
                entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 100, 1));
            }
        }
    }

    private void performRangedAttack(LivingEntity p_82216_2_) {
        this.performRangedAttack(p_82216_2_.func_226277_ct_(), p_82216_2_.func_226278_cu_() + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.func_226281_cx_());
    }

    private void performRangedAttack(double p_82209_2_, double p_82209_4_, double p_82209_6_) {
        this.func_184185_a(SoundEvents.field_193777_bb, this.func_70599_aP(), this.func_70647_i());
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226280_cw_();
        double d2 = this.func_226281_cx_();
        double d3 = p_82209_2_ - d0;
        double d4 = p_82209_4_ - d1;
        double d5 = p_82209_6_ - d2;
        DreamBoltEntity witherskullentity = new DreamBoltEntity(this.field_70170_p, (LivingEntity)this, d3, d4, d5);
        witherskullentity.func_212361_a((Entity)this);
        witherskullentity.func_226288_n_(d0, d1, d2);
        this.field_70170_p.func_217376_c((Entity)witherskullentity);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(THROW_SLEEP_POWDER_TIME, (Object)0);
        this.field_70180_af.func_187214_a(SPLIT_TIME, (Object)0);
    }

    public int getThrowSleepPowderTime() {
        return (Integer)this.field_70180_af.func_187225_a(THROW_SLEEP_POWDER_TIME);
    }

    public void setThrowSleepPowderTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(THROW_SLEEP_POWDER_TIME, (Object)p_189794_1_);
    }

    public int getSplitTime() {
        return (Integer)this.field_70180_af.func_187225_a(SPLIT_TIME);
    }

    public void setSplitTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(SPLIT_TIME, (Object)p_189794_1_);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187531_aU;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    @Override
    public boolean shouldAttackOnStare() {
        return false;
    }

    @Override
    public boolean shouldTeleportInDay() {
        return false;
    }

    @Override
    public boolean shouldChangeSpeed() {
        return false;
    }

    @Override
    public void playStareSound() {
        if (this.field_70173_aa >= this.lastStareSound + 400) {
            this.lastStareSound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_STARE_ORIGINAL.get(), this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

