/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.entities;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import com.alexander.endermenplus.init.SoundEventInit;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.InteractDoorGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class JungleerEntity
extends AbstractEndermanVariant
implements IAnimatable {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static final DataParameter<Integer> LEAP_TIME = EntityDataManager.func_187226_a(JungleerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = p_213697_0_ -> p_213697_0_ != Difficulty.EASY;

    public JungleerEntity(EntityType<? extends JungleerEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getLeapTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jungleer_leap", Boolean.valueOf(true)));
        } else if (this.isAttacking() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("barrener_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jungleer_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jungleer_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new BreakDoorGoal((MobEntity)this, DOOR_BREAKING_PREDICATE));
        this.field_70714_bg.func_75776_a(1, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.6f));
        this.field_70714_bg.func_75776_a(1, (Goal)new AbstractEndermanVariant.StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AbstractEndermanVariant.AttackGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new AbstractEndermanVariant.PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new AbstractEndermanVariant.TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AbstractEndermanVariant.FindPlayerGoal(this, arg_0 -> ((JungleerEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, ENDERMITE_SELECTOR));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LEAP_TIME, (Object)0);
    }

    public int getLeapTime() {
        return (Integer)this.field_70180_af.func_187225_a(LEAP_TIME);
    }

    public void setLeapTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(LEAP_TIME, (Object)p_189794_1_);
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    @Override
    public void func_70030_z() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        super.func_70030_z();
        if (this.getLeapTime() > 0) {
            this.setLeapTime(this.getLeapTime() - 1);
        }
        if (JungleerEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(1) == 0 && !(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_())))).isAir((IBlockReader)this.field_70170_p, pos)) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187571_bR, 0.5f, this.func_70647_i());
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.45f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.isCreepy() ? (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_SCREAM_ORIGINAL.get() : null;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_HURT_ORIGINAL.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_DEATH_ORIGINAL.get();
    }

    @Override
    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 1.4f;
    }

    @Override
    public boolean shouldChangeSpeed() {
        return false;
    }

    @Override
    public boolean shouldTeleportInDay() {
        return false;
    }

    @Override
    public boolean shouldAttackOnStare() {
        return false;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public class LeapAtTargetGoal
    extends Goal {
        private final MobEntity mob;
        private LivingEntity target;
        private final float yd;

        public LeapAtTargetGoal(MobEntity p_i1630_1_, float p_i1630_2_) {
            this.mob = p_i1630_1_;
            this.yd = p_i1630_2_;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.mob.func_184207_aI()) {
                return false;
            }
            this.target = this.mob.func_70638_az();
            if (this.target == null) {
                return false;
            }
            if (!this.mob.func_70685_l((Entity)this.target)) {
                return false;
            }
            double d0 = this.mob.func_70068_e((Entity)this.target);
            if (!(d0 < 4.0) && !(d0 > 20.0)) {
                if (!this.mob.func_233570_aj_()) {
                    return false;
                }
                return this.mob.func_70681_au().nextInt(5) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return !this.mob.func_233570_aj_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.mob.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(this.target.func_226277_ct_() - this.mob.func_226277_ct_(), 0.0, this.target.func_226281_cx_() - this.mob.func_226281_cx_());
            JungleerEntity.this.setLeapTime(20);
            if (vector3d1.func_189985_c() > 1.0E-7) {
                vector3d1 = vector3d1.func_72432_b().func_186678_a(0.4).func_178787_e(vector3d.func_186678_a(0.2));
            }
            this.mob.func_213293_j(vector3d1.field_72450_a, (double)this.yd, vector3d1.field_72449_c);
        }
    }

    public class WaterAvoidingRandomWalkingGoal
    extends RandomWalkingGoal {
        protected final float probability;

        public WaterAvoidingRandomWalkingGoal(CreatureEntity p_i47301_1_, double p_i47301_2_) {
            this(p_i47301_1_, p_i47301_2_, 0.001f);
        }

        public WaterAvoidingRandomWalkingGoal(CreatureEntity p_i47302_1_, double p_i47302_2_, float p_i47302_4_) {
            super(p_i47302_1_, p_i47302_2_);
            this.probability = p_i47302_4_;
        }

        @Nullable
        protected Vector3d func_190864_f() {
            if (this.field_75457_a.func_203005_aq()) {
                Vector3d vector3d = RandomPositionGenerator.func_191377_b((CreatureEntity)this.field_75457_a, (int)30, (int)10);
                return vector3d == null ? super.func_190864_f() : vector3d;
            }
            return this.field_75457_a.func_70681_au().nextFloat() >= this.probability ? RandomPositionGenerator.func_191377_b((CreatureEntity)this.field_75457_a, (int)30, (int)10) : super.func_190864_f();
        }
    }

    public class BreakDoorGoal
    extends InteractDoorGoal {
        private final Predicate<Difficulty> validDifficulties;
        protected int breakTime;
        protected int lastBreakProgress;
        protected int doorBreakTime;

        public BreakDoorGoal(MobEntity p_i50332_1_, Predicate<Difficulty> p_i50332_2_) {
            super(p_i50332_1_);
            this.lastBreakProgress = -1;
            this.doorBreakTime = -1;
            this.validDifficulties = p_i50332_2_;
        }

        public BreakDoorGoal(MobEntity p_i50333_1_, int p_i50333_2_, Predicate<Difficulty> p_i50333_3_) {
            this(p_i50333_1_, p_i50333_3_);
            this.doorBreakTime = p_i50333_2_;
        }

        protected int getDoorBreakTime() {
            return Math.max(240, this.doorBreakTime);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (!ForgeHooks.canEntityDestroy((World)this.field_75356_a.field_70170_p, (BlockPos)this.field_179507_b, (LivingEntity)this.field_75356_a)) {
                return false;
            }
            return this.isValidDifficulty(this.field_75356_a.field_70170_p.func_175659_aa()) && !this.func_195922_f();
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.breakTime = 0;
        }

        public boolean func_75253_b() {
            return this.breakTime <= this.getDoorBreakTime() && !this.func_195922_f() && this.field_179507_b.func_218137_a((IPosition)this.field_75356_a.func_213303_ch(), 2.0) && this.isValidDifficulty(this.field_75356_a.field_70170_p.func_175659_aa());
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.field_75356_a.field_70170_p.func_175715_c(this.field_75356_a.func_145782_y(), this.field_179507_b, -1);
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.field_75356_a.func_70681_au().nextInt(20) == 0) {
                this.field_75356_a.field_70170_p.func_217379_c(1019, this.field_179507_b, 0);
                if (!this.field_75356_a.field_82175_bq) {
                    ((AbstractEndermanVariant)this.field_75356_a).setAttacking(30);
                    this.field_75356_a.func_184609_a(this.field_75356_a.func_184600_cs());
                }
            }
            ++this.breakTime;
            int i = (int)((float)this.breakTime / (float)this.getDoorBreakTime() * 10.0f);
            if (i != this.lastBreakProgress) {
                this.field_75356_a.field_70170_p.func_175715_c(this.field_75356_a.func_145782_y(), this.field_179507_b, i);
                this.lastBreakProgress = i;
            }
            if (this.breakTime == this.getDoorBreakTime() && this.isValidDifficulty(this.field_75356_a.field_70170_p.func_175659_aa())) {
                this.field_75356_a.field_70170_p.func_217377_a(this.field_179507_b, false);
                this.field_75356_a.field_70170_p.func_217379_c(1021, this.field_179507_b, 0);
                this.field_75356_a.field_70170_p.func_217379_c(2001, this.field_179507_b, Block.func_196246_j((BlockState)this.field_75356_a.field_70170_p.func_180495_p(this.field_179507_b)));
            }
        }

        private boolean isValidDifficulty(Difficulty p_220696_1_) {
            return this.validDifficulties.test(p_220696_1_);
        }
    }
}

