/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.entities;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MarshlanderEntity
extends AbstractEndermanVariant
implements IAnimatable {
    public final EntityPredicate slimePredicate = new EntityPredicate().func_221013_a(20.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
    public static final DataParameter<Integer> SUMMON_TIME = EntityDataManager.func_187226_a(MarshlanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> CIRCLING = EntityDataManager.func_187226_a(MarshlanderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> CIRCLE_PROGRESS = EntityDataManager.func_187226_a(MarshlanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public MarshlanderEntity(EntityType<? extends MarshlanderEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getSummonTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("marshlander_summon_slimes", Boolean.valueOf(true)));
        } else if (this.isAttacking() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("marshlander_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            if (this.isCreepy() && !this.getCircling()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("tundraman_run", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("marshlander_walk", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("marshlander_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AbstractEndermanVariant.StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new AbstractEndermanVariant.PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new AbstractEndermanVariant.TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AbstractEndermanVariant.FindPlayerGoal(this, arg_0 -> ((MarshlanderEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, ENDERMITE_SELECTOR));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMON_TIME, (Object)0);
        this.field_70180_af.func_187214_a(CIRCLING, (Object)false);
        this.field_70180_af.func_187214_a(CIRCLE_PROGRESS, (Object)0);
    }

    public int getCircleProgress() {
        return (Integer)this.field_70180_af.func_187225_a(CIRCLE_PROGRESS);
    }

    public void setCircleProgress(int p_189794_1_) {
        this.field_70180_af.func_187227_b(CIRCLE_PROGRESS, (Object)p_189794_1_);
    }

    public boolean getCircling() {
        return (Boolean)this.field_70180_af.func_187225_a(CIRCLING);
    }

    public void setCircling(boolean p_191997_1_) {
        this.field_70180_af.func_187227_b(CIRCLING, (Object)p_191997_1_);
    }

    public int getSummonTime() {
        return (Integer)this.field_70180_af.func_187225_a(SUMMON_TIME);
    }

    public void setSummonTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(SUMMON_TIME, (Object)p_189794_1_);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof AbstractMinecartEntity) {
            this.func_184187_bx().func_184226_ay();
        }
        if (this.func_70638_az() != null && this.field_70170_p.func_217374_a(SlimeEntity.class, this.slimePredicate, (LivingEntity)this, this.func_174813_aQ().func_186662_g(20.0)).size() < 5 && this.getSummonTime() <= -40 && this.field_70146_Z.nextInt(100) == 0) {
            this.setSummonTime(70);
            this.func_184185_a(SoundEvents.field_187810_eg, 3.0f, 0.5f);
        }
        if (this.func_70638_az() != null && this.field_70146_Z.nextInt(125) == 0) {
            this.setCircling(!this.getCircling());
        }
        if (this.func_70638_az() != null && this.getCircling() && this.field_70173_aa % 40 == 0) {
            int k = this.getCircleProgress();
            LivingEntity livingentity = this.func_70638_az();
            float f = (float)MathHelper.func_181159_b((double)(this.func_226281_cx_() - livingentity.func_226281_cx_()), (double)(this.func_226277_ct_() - livingentity.func_226277_ct_()));
            float f2 = (float)k * (float)Math.PI * 0.4f;
            double d0 = Math.min(livingentity.func_226278_cu_(), this.func_226278_cu_());
            this.field_70699_by.func_75492_a(this.func_70638_az().func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 7.0, d0, this.func_70638_az().func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 7.0, 0.75);
            this.setCircleProgress(this.getCircleProgress() + 1);
            this.func_70624_b(this.func_70638_az());
            this.func_70671_ap().func_220679_a(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226280_cw_(), this.func_70638_az().func_226281_cx_());
        }
        if (this.getSummonTime() == 20 && !this.field_70170_p.field_72995_K) {
            ServerWorld serverworld = (ServerWorld)this.field_70170_p;
            SlimeEntity slime = (SlimeEntity)EntityType.field_200743_ai.func_200721_a(this.field_70170_p);
            slime.func_174828_a(this.func_233580_cy_().func_177985_f(2).func_177970_e(2), 0.0f, 0.0f);
            slime.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
            serverworld.func_242417_l((Entity)slime);
            SlimeEntity slime2 = (SlimeEntity)EntityType.field_200743_ai.func_200721_a(this.field_70170_p);
            slime2.func_174828_a(this.func_233580_cy_().func_177985_f(2).func_177964_d(2), 0.0f, 0.0f);
            slime2.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
            serverworld.func_242417_l((Entity)slime2);
            SlimeEntity slime3 = (SlimeEntity)EntityType.field_200743_ai.func_200721_a(this.field_70170_p);
            slime3.func_174828_a(this.func_233580_cy_().func_177965_g(2).func_177970_e(2), 0.0f, 0.0f);
            slime3.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
            serverworld.func_242417_l((Entity)slime3);
            SlimeEntity slime4 = (SlimeEntity)EntityType.field_200743_ai.func_200721_a(this.field_70170_p);
            slime4.func_174828_a(this.func_233580_cy_().func_177965_g(2).func_177964_d(2), 0.0f, 0.0f);
            slime4.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
            serverworld.func_242417_l((Entity)slime4);
        }
        if (this.getSummonTime() > -40) {
            this.setSummonTime(this.getSummonTime() - 1);
        }
        if (this.getSummonTime() > 0) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.2f);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187529_aS;
    }

    @Override
    public boolean shouldAttackOnStare() {
        return false;
    }

    @Override
    public boolean func_230270_dK_() {
        return false;
    }

    @Override
    public boolean shouldTeleportInDay() {
        return false;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((CreatureEntity)MarshlanderEntity.this, 1.05, true);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !MarshlanderEntity.this.getCircling();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !MarshlanderEntity.this.getCircling();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return this.field_75441_b.func_213311_cf() * 3.0f * this.field_75441_b.func_213311_cf() * 3.0f + p_179512_1_.func_213311_cf();
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 30) {
                    MarshlanderEntity.this.setAttacking(30);
                }
            } else {
                this.func_234039_g_();
            }
        }
    }

    public class WaterAvoidingRandomWalkingGoal
    extends RandomWalkingGoal {
        protected final float probability;

        public WaterAvoidingRandomWalkingGoal(CreatureEntity p_i47301_1_, double p_i47301_2_) {
            this(p_i47301_1_, p_i47301_2_, 0.001f);
        }

        public WaterAvoidingRandomWalkingGoal(CreatureEntity p_i47302_1_, double p_i47302_2_, float p_i47302_4_) {
            super(p_i47302_1_, p_i47302_2_);
            this.probability = p_i47302_4_;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !MarshlanderEntity.this.getCircling();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !MarshlanderEntity.this.getCircling();
        }

        @Nullable
        protected Vector3d func_190864_f() {
            if (this.field_75457_a.func_203005_aq()) {
                Vector3d vector3d = RandomPositionGenerator.func_191377_b((CreatureEntity)this.field_75457_a, (int)15, (int)7);
                return vector3d == null ? super.func_190864_f() : vector3d;
            }
            return this.field_75457_a.func_70681_au().nextFloat() >= this.probability ? RandomPositionGenerator.func_191377_b((CreatureEntity)this.field_75457_a, (int)10, (int)7) : super.func_190864_f();
        }
    }
}

