/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.entities;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import com.alexander.endermenplus.init.SoundEventInit;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SeasiderEntity
extends AbstractEndermanVariant
implements IAnimatable,
IRangedAttackMob {
    private boolean searchingForLand;
    protected final SwimmerPathNavigator waterNavigation;
    protected final GroundPathNavigator groundNavigation;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final DataParameter<Integer> DATA_VARIANT_ID = EntityDataManager.func_187226_a(SeasiderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SHELL_THROW_TIME = EntityDataManager.func_187226_a(SeasiderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> TRIDENT_USING = EntityDataManager.func_187226_a(SeasiderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public SeasiderEntity(EntityType<? extends SeasiderEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
        this.func_184644_a(PathNodeType.WATER, 1.0f);
        this.field_70138_W = 1.0f;
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.waterNavigation = new SwimmerPathNavigator((MobEntity)this, p_i50210_2_);
        this.groundNavigation = new GroundPathNavigator((MobEntity)this, p_i50210_2_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getShellThrowTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("seasider_throw_shell", Boolean.valueOf(true)));
        } else if (this.func_70090_H()) {
            if (this.isAttacking() > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("seasider_throw_trident", Boolean.valueOf(true)));
            } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("seasider_swim", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("seasider_idle", Boolean.valueOf(true)));
            }
        } else if (this.isAttacking() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("tundraman_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            if (this.isCreepy()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("tundraman_run", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("tundraman_walk", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("tundraman_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (item != Items.field_221739_dF) {
            return ActionResultType.PASS;
        }
        this.setShellThrowTime(20);
        if (!p_230254_1_.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    private void throwItemsTowardPlayer(SeasiderEntity p_234472_0_, PlayerEntity p_234472_1_, ItemStack p_234472_2_) {
        this.throwItemsTowardPos(p_234472_0_, p_234472_2_, p_234472_1_.func_213303_ch());
    }

    private void throwItemsTowardPos(SeasiderEntity p_234476_0_, ItemStack p_234476_1_, Vector3d p_234476_2_) {
        if (!p_234476_1_.func_190926_b()) {
            p_234476_0_.func_184609_a(Hand.OFF_HAND);
            BrainUtil.func_233865_a_((LivingEntity)p_234476_0_, (ItemStack)p_234476_1_, (Vector3d)p_234476_2_.func_72441_c(0.0, 1.0, 0.0));
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new TridentMoveGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new GoToBeachGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new SwimUpGoal(this, 1.0, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(1, (Goal)new AbstractEndermanVariant.StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new AbstractEndermanVariant.PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new AbstractEndermanVariant.TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AbstractEndermanVariant.FindPlayerGoal(this, arg_0 -> ((SeasiderEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, ENDERMITE_SELECTOR));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public boolean func_205019_a(IWorldReader p_205019_1_) {
        return p_205019_1_.func_226668_i_((Entity)this);
    }

    public boolean func_213380_a(IWorld p_213380_1_, SpawnReason p_213380_2_) {
        if (this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c() != Blocks.field_150355_j && this.field_70146_Z.nextInt(5) == 0) {
            return super.func_213380_a(p_213380_1_, p_213380_2_);
        }
        return super.func_213380_a(p_213380_1_, p_213380_2_);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.isCreepy() ? (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_SCREAM_ORIGINAL.get() : (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_AMBIENT_ORIGINAL.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_HURT_ORIGINAL.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_DEATH_ORIGINAL.get();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.setVariant(this.field_70146_Z.nextInt(5));
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_203184_eO));
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHELL_THROW_TIME, (Object)0);
        this.field_70180_af.func_187214_a(DATA_VARIANT_ID, (Object)0);
        this.field_70180_af.func_187214_a(TRIDENT_USING, (Object)false);
    }

    public int getVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(DATA_VARIANT_ID)), (int)0, (int)4);
    }

    public void setVariant(int p_191997_1_) {
        this.field_70180_af.func_187227_b(DATA_VARIANT_ID, (Object)p_191997_1_);
    }

    public boolean getTridentUsing() {
        return (Boolean)this.field_70180_af.func_187225_a(TRIDENT_USING);
    }

    public void setTridentUsing(boolean p_191997_1_) {
        this.field_70180_af.func_187227_b(TRIDENT_USING, (Object)p_191997_1_);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("Variant", this.getVariant());
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setVariant(p_70037_1_.func_74762_e("Variant"));
    }

    public int getShellThrowTime() {
        return (Integer)this.field_70180_af.func_187225_a(SHELL_THROW_TIME);
    }

    public void setShellThrowTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(SHELL_THROW_TIME, (Object)p_189794_1_);
    }

    @Override
    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 2.1f;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.getTridentUsing() && this.isAttacking() == 5 && this.func_70638_az() != null) {
            this.throwTrident(this.func_70638_az(), 0.0f);
        }
        if (this.getShellThrowTime() > 0) {
            this.setShellThrowTime(this.getShellThrowTime() - 1);
        }
        if (this.getShellThrowTime() == 10) {
            this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
            this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_205157_eZ));
        }
        if (this.func_70638_az() == null) {
            this.setTridentUsing(false);
        } else if (this.func_70638_az() != null && this.field_70146_Z.nextInt(100) == 0) {
            this.setTridentUsing(!this.getTridentUsing());
        }
        if (this.func_70638_az() != null && this.getTridentUsing() && this.field_70173_aa % 80 == 0) {
            this.func_82196_d(this.func_70638_az(), 0.0f);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    @Override
    public boolean shouldAttackOnStare() {
        return false;
    }

    @Override
    public boolean shouldTeleportInDay() {
        return false;
    }

    @Override
    public boolean func_230270_dK_() {
        return false;
    }

    protected int func_70682_h(int p_70682_1_) {
        return p_70682_1_;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    private boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        LivingEntity livingentity = this.func_70638_az();
        return livingentity != null && livingentity.func_70090_H();
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H() && this.wantsToSwim()) {
            this.func_213309_a(0.01f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.925));
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H() && this.wantsToSwim()) {
                this.field_70699_by = this.waterNavigation;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigation;
                this.func_204711_a(false);
            }
        }
    }

    protected boolean closeToNextPos() {
        double d0;
        BlockPos blockpos;
        Path path = this.func_70661_as().func_75505_d();
        return path != null && (blockpos = path.func_224770_k()) != null && (d0 = this.func_70092_e(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p())) < 4.0;
    }

    public void func_82196_d(LivingEntity p_82196_1_, float p_82196_2_) {
        this.setAttacking(20);
    }

    public void throwTrident(LivingEntity p_82196_1_, float p_82196_2_) {
        TridentEntity tridententity = new TridentEntity(this.field_70170_p, (LivingEntity)this, new ItemStack((IItemProvider)Items.field_203184_eO));
        double d0 = p_82196_1_.func_226277_ct_() - this.func_226277_ct_();
        double d1 = p_82196_1_.func_226283_e_(0.3333333333333333) - tridententity.func_226278_cu_();
        double d2 = p_82196_1_.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        tridententity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_204780_be, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)tridententity);
    }

    public void setSearchingForLand(boolean p_204713_1_) {
        this.searchingForLand = p_204713_1_;
    }

    class TridentMoveGoal
    extends Goal {
        public TridentMoveGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public void func_75246_d() {
            super.func_75246_d();
            SeasiderEntity.this.func_70671_ap().func_220679_a(SeasiderEntity.this.func_70638_az().func_226277_ct_(), SeasiderEntity.this.func_70638_az().func_226280_cw_(), SeasiderEntity.this.func_70638_az().func_226281_cx_());
        }

        public boolean func_75250_a() {
            return SeasiderEntity.this.getTridentUsing() && SeasiderEntity.this.func_70638_az() != null;
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final SeasiderEntity drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public SwimUpGoal(SeasiderEntity p_i48908_1_, double p_i48908_2_, int p_i48908_4_) {
            this.drowned = p_i48908_1_;
            this.speedModifier = p_i48908_2_;
            this.seaLevel = p_i48908_4_;
        }

        public boolean func_75250_a() {
            return this.drowned.func_70090_H() && this.drowned.func_226278_cu_() < (double)(this.seaLevel - 2);
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && !this.stuck;
        }

        public void func_75246_d() {
            if (this.drowned.func_226278_cu_() < (double)(this.seaLevel - 1) && (this.drowned.func_70661_as().func_75500_f() || this.drowned.closeToNextPos())) {
                Vector3d vector3d = RandomPositionGenerator.func_75464_a((CreatureEntity)this.drowned, (int)4, (int)8, (Vector3d)new Vector3d(this.drowned.func_226277_ct_(), (double)(this.seaLevel - 1), this.drowned.func_226281_cx_()));
                if (vector3d == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.func_70661_as().func_75492_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, this.speedModifier);
            }
        }

        public void func_75249_e() {
            this.drowned.setSearchingForLand(true);
            this.stuck = false;
        }

        public void func_75251_c() {
            this.drowned.setSearchingForLand(false);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final SeasiderEntity drowned;

        public MoveHelperController(SeasiderEntity p_i48909_1_) {
            super((MobEntity)p_i48909_1_);
            this.drowned = p_i48909_1_;
        }

        public void func_75641_c() {
            LivingEntity livingentity = this.drowned.func_70638_az();
            if (this.drowned.wantsToSwim() && this.drowned.func_70090_H()) {
                if (livingentity != null && livingentity.func_226278_cu_() > this.drowned.func_226278_cu_() || this.drowned.searchingForLand) {
                    this.drowned.func_213317_d(this.drowned.func_213322_ci().func_72441_c(0.0, 0.002, 0.0));
                }
                if (this.field_188491_h != MovementController.Action.MOVE_TO || this.drowned.func_70661_as().func_75500_f()) {
                    this.drowned.func_70659_e(0.0f);
                    return;
                }
                double d0 = this.field_75646_b - this.drowned.func_226277_ct_();
                double d1 = this.field_75647_c - this.drowned.func_226278_cu_();
                double d2 = this.field_75644_d - this.drowned.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.field_70761_aq = this.drowned.field_70177_z = this.func_75639_a(this.drowned.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.drowned.func_233637_b_(Attributes.field_233821_d_));
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.drowned.func_70689_ay(), (float)f1);
                this.drowned.func_70659_e(f2);
                this.drowned.func_213317_d(this.drowned.func_213322_ci().func_72441_c((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.field_70122_E) {
                    this.drowned.func_213317_d(this.drowned.func_213322_ci().func_72441_c(0.0, -0.008, 0.0));
                }
                super.func_75641_c();
            }
        }
    }

    static class GoToBeachGoal
    extends MoveToBlockGoal {
        private final SeasiderEntity drowned;

        public GoToBeachGoal(SeasiderEntity p_i48911_1_, double p_i48911_2_) {
            super((CreatureEntity)p_i48911_1_, p_i48911_2_, 8, 2);
            this.drowned = p_i48911_1_;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.drowned.func_70090_H() && this.drowned.func_226278_cu_() >= (double)(this.drowned.field_70170_p.func_181545_F() - 3);
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected boolean func_179488_a(IWorldReader p_179488_1_, BlockPos p_179488_2_) {
            BlockPos blockpos = p_179488_2_.func_177984_a();
            return p_179488_1_.func_175623_d(blockpos) && p_179488_1_.func_175623_d(blockpos.func_177984_a()) ? p_179488_1_.func_180495_p(p_179488_2_).func_235719_a_((IBlockReader)p_179488_1_, p_179488_2_, (Entity)this.drowned) : false;
        }

        public void func_75249_e() {
            this.drowned.setSearchingForLand(false);
            this.drowned.field_70699_by = (PathNavigator)this.drowned.groundNavigation;
            super.func_75249_e();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public final EntityPredicate slimePredicate;

        public AttackGoal() {
            super((CreatureEntity)SeasiderEntity.this, 1.0, true);
            this.slimePredicate = new EntityPredicate().func_221013_a(20.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !SeasiderEntity.this.getTridentUsing();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !SeasiderEntity.this.getTridentUsing();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return this.field_75441_b.func_213311_cf() * 3.0f * this.field_75441_b.func_213311_cf() * 3.0f + p_179512_1_.func_213311_cf();
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 30) {
                    SeasiderEntity.this.setAttacking(30);
                }
            } else {
                this.func_234039_g_();
            }
        }
    }
}

