/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.entities;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import com.alexander.endermenplus.entities.WastelanderEntity;
import com.alexander.endermenplus.init.SoundEventInit;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WastelanderChieftainEntity
extends AbstractEndermanVariant
implements IAnimatable {
    private final EntityPredicate vexCountTargeting = new EntityPredicate().func_221013_a(30.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static final DataParameter<Integer> ITEM_THROW_TIME = EntityDataManager.func_187226_a(WastelanderChieftainEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SUMMON_FIREBALL_TIME = EntityDataManager.func_187226_a(WastelanderChieftainEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> BUFF_ENDERMEN_TIME = EntityDataManager.func_187226_a(WastelanderChieftainEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public ItemStack[] itemPool = new ItemStack[]{new ItemStack((IItemProvider)Items.field_221693_cI, 7), new ItemStack((IItemProvider)Items.field_221691_cH, 14), new ItemStack((IItemProvider)Items.field_234708_K_, 5), new ItemStack((IItemProvider)Items.field_234798_v_, 9), new ItemStack((IItemProvider)Items.field_151065_br, 3), new ItemStack((IItemProvider)Items.field_221655_bP, 4)};
    public BlockPos anchorPos;

    public WastelanderChieftainEntity(EntityType<? extends WastelanderChieftainEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getItemThrowTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wastelander_chieftain_throw_item", Boolean.valueOf(true)));
        } else if (this.getSummonFireballTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wastelander_chieftain_summon_fireball", Boolean.valueOf(true)));
        } else if (this.getBuffEndermenTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wastelander_chieftain_buff_endermen", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wastelander_chieftain_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{WastelanderEntity.class}).func_220794_a(new Class[]{WastelanderEntity.class}));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, ENDERMITE_SELECTOR));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, ILivingEntityData p_213386_4_, CompoundNBT p_213386_5_) {
        this.anchorPos = this.func_233580_cy_();
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    @Override
    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 1.4f;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        if (this.hasAnchorPos()) {
            p_213281_1_.func_218657_a("HivePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getAnchorPos()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        this.anchorPos = null;
        if (p_70037_1_.func_74764_b("AnchorPos")) {
            this.anchorPos = NBTUtil.func_186861_c((CompoundNBT)p_70037_1_.func_74775_l("AnchorPos"));
        }
    }

    public boolean hasAnchorPos() {
        return this.anchorPos != null;
    }

    @Nullable
    public BlockPos getAnchorPos() {
        return this.anchorPos;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (!this.hasAnchorPos()) {
            this.anchorPos = this.func_233580_cy_();
        }
        if (this.func_70638_az() != null && this.field_70170_p.func_217374_a(AbstractEndermanVariant.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_186662_g(30.0)).size() > 0) {
            for (AbstractEndermanVariant entity : this.field_70170_p.func_217374_a(AbstractEndermanVariant.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_186662_g(30.0))) {
                entity.func_70624_b(this.func_70638_az());
            }
        }
        if (this.hasAnchorPos() && this.func_233580_cy_() != this.anchorPos && this.field_70146_Z.nextInt(200) == 0) {
            this.func_70634_a(this.anchorPos.func_177958_n(), this.anchorPos.func_177956_o(), this.anchorPos.func_177952_p());
        }
        if (this.getItemThrowTime() > 0) {
            this.setItemThrowTime(this.getItemThrowTime() - 1);
        }
        if (this.getSummonFireballTime() > 0) {
            this.setSummonFireballTime(this.getSummonFireballTime() - 1);
        }
        if (this.getBuffEndermenTime() > 0) {
            this.setBuffEndermenTime(this.getBuffEndermenTime() - 1);
        }
        if (this.func_70638_az() != null && this.getSummonFireballTime() == 0 && this.getBuffEndermenTime() == 0 && this.field_70146_Z.nextInt(50) == 0) {
            this.setSummonFireballTime(100);
            this.func_184185_a((SoundEvent)SoundEventInit.ENTITY_ENDERMAN_SCREAM_ORIGINAL.get(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.func_70638_az() != null && this.field_70170_p.func_217374_a(AbstractEndermanVariant.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_186662_g(30.0)).size() > 0 && this.getBuffEndermenTime() == 0 && this.field_70146_Z.nextInt(250) == 0) {
            this.setBuffEndermenTime(70);
            this.func_184185_a((SoundEvent)SoundEventInit.ENTITY_ENDERMAN_SCREAM_ORIGINAL.get(), this.func_70599_aP(), this.func_70647_i());
            this.setSummonFireballTime(0);
        }
        if (this.getBuffEndermenTime() == 30) {
            for (AbstractEndermanVariant entity : this.field_70170_p.func_217374_a(AbstractEndermanVariant.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_186662_g(30.0))) {
                if (this.field_70146_Z.nextBoolean()) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76424_c, 200, 1));
                    continue;
                }
                entity.func_195064_c(new EffectInstance(Effects.field_76420_g, 200, 1));
            }
        }
        if (this.func_70638_az() != null && this.getSummonFireballTime() == 27) {
            this.performRangedAttack(this.func_70638_az());
        }
        if (this.getItemThrowTime() == 10) {
            this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
            this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), this.itemPool[this.field_70146_Z.nextInt(this.itemPool.length)]);
        }
    }

    private void performRangedAttack(LivingEntity p_82216_2_) {
        this.performRangedAttack(p_82216_2_.func_226277_ct_(), p_82216_2_.func_226278_cu_() + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.func_226281_cx_());
    }

    private void performRangedAttack(double p_82209_2_, double p_82209_4_, double p_82209_6_) {
        this.func_184185_a(SoundEvents.field_187557_bK, this.func_70599_aP(), this.func_70647_i());
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226280_cw_();
        double d2 = this.func_226281_cx_();
        double d3 = p_82209_2_ - d0;
        double d4 = p_82209_4_ - d1;
        double d5 = p_82209_6_ - d2;
        FireballEntity witherskullentity = new FireballEntity(this.field_70170_p, (LivingEntity)this, d3, d4, d5);
        witherskullentity.field_92057_e = 3;
        witherskullentity.func_212361_a((Entity)this);
        witherskullentity.func_226288_n_(d0, d1, d2);
        this.field_70170_p.func_217376_c((Entity)witherskullentity);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ITEM_THROW_TIME, (Object)0);
        this.field_70180_af.func_187214_a(SUMMON_FIREBALL_TIME, (Object)0);
        this.field_70180_af.func_187214_a(BUFF_ENDERMEN_TIME, (Object)0);
    }

    public int getItemThrowTime() {
        return (Integer)this.field_70180_af.func_187225_a(ITEM_THROW_TIME);
    }

    public void setItemThrowTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ITEM_THROW_TIME, (Object)p_189794_1_);
    }

    public int getSummonFireballTime() {
        return (Integer)this.field_70180_af.func_187225_a(SUMMON_FIREBALL_TIME);
    }

    public void setSummonFireballTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(SUMMON_FIREBALL_TIME, (Object)p_189794_1_);
    }

    public int getBuffEndermenTime() {
        return (Integer)this.field_70180_af.func_187225_a(BUFF_ENDERMEN_TIME);
    }

    public void setBuffEndermenTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(BUFF_ENDERMEN_TIME, (Object)p_189794_1_);
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_221696_bj) {
            this.setItemThrowTime(20);
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.FAIL;
    }

    private void throwItemsTowardPlayer(WastelanderChieftainEntity wastelanderEntity, PlayerEntity p_234472_1_, ItemStack p_234472_2_) {
        this.throwItemsTowardPos(wastelanderEntity, p_234472_2_, p_234472_1_.func_213303_ch());
    }

    private void throwItemsTowardPos(WastelanderChieftainEntity p_234476_0_, ItemStack p_234476_1_, Vector3d p_234476_2_) {
        if (!p_234476_1_.func_190926_b()) {
            p_234476_0_.func_184609_a(Hand.OFF_HAND);
            BrainUtil.func_233865_a_((LivingEntity)p_234476_0_, (ItemStack)p_234476_1_, (Vector3d)p_234476_2_.func_72441_c(0.0, 1.0, 0.0));
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.isCreepy() ? (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_SCREAM_ORIGINAL.get() : (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_AMBIENT_ORIGINAL.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_HURT_ORIGINAL.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_DEATH_ORIGINAL.get();
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    @Override
    public boolean shouldAttackOnStare() {
        return false;
    }

    @Override
    public boolean shouldTeleportInDay() {
        return false;
    }

    @Override
    public void playStareSound() {
        if (this.field_70173_aa >= this.lastStareSound + 400) {
            this.lastStareSound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_STARE_ORIGINAL.get(), this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

