/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.entities;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import com.alexander.endermenplus.init.SoundEventInit;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WastelanderEntity
extends AbstractEndermanVariant
implements IAnimatable {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static final DataParameter<Boolean> DELTAS = EntityDataManager.func_187226_a(WastelanderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> ITEM_THROW_TIME = EntityDataManager.func_187226_a(WastelanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public ItemStack[] wastelanderItems = new ItemStack[]{new ItemStack((IItemProvider)Items.field_221693_cI, 7), new ItemStack((IItemProvider)Items.field_221691_cH, 14), new ItemStack((IItemProvider)Items.field_234708_K_, 5), new ItemStack((IItemProvider)Items.field_234798_v_, 9), new ItemStack((IItemProvider)Items.field_151065_br, 3), new ItemStack((IItemProvider)Items.field_221655_bP, 4)};
    public ItemStack[] wastelanderDeltasItems = new ItemStack[]{new ItemStack((IItemProvider)Items.field_234777_rA_, 7), new ItemStack((IItemProvider)Items.field_234735_dn_, 14), new ItemStack((IItemProvider)Items.field_151128_bU, 6), new ItemStack((IItemProvider)Items.field_234799_w_, 9), new ItemStack((IItemProvider)Items.field_221690_bg, 2), new ItemStack((IItemProvider)Items.field_151129_at, 1)};
    public ItemStack currencyStack;
    public static final DataParameter<Boolean> CIRCLING = EntityDataManager.func_187226_a(WastelanderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> CIRCLE_PROGRESS = EntityDataManager.func_187226_a(WastelanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public WastelanderEntity(EntityType<? extends WastelanderEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getItemThrowTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("seasider_throw_shell", Boolean.valueOf(true)));
        } else if (this.isAttacking() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wastelander_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            if (this.isCreepy()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wastelander_run", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wastelander_walk", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wastelander_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AbstractEndermanVariant.StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new AbstractEndermanVariant.PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new AbstractEndermanVariant.TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AbstractEndermanVariant.FindPlayerGoal(this, arg_0 -> ((WastelanderEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, ENDERMITE_SELECTOR));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (!this.getDeltas() && this.func_70638_az() != null && this.field_70146_Z.nextInt(150) == 0) {
            this.setCircling(!this.getCircling());
        }
        if (this.func_70638_az() != null && this.getCircling() && this.field_70173_aa % 20 == 0) {
            int k = this.getCircleProgress();
            LivingEntity livingentity = this.func_70638_az();
            float f = (float)MathHelper.func_181159_b((double)(this.func_226281_cx_() - livingentity.func_226281_cx_()), (double)(this.func_226277_ct_() - livingentity.func_226277_ct_()));
            float f2 = (float)k * (float)Math.PI * 0.4f;
            double d0 = Math.min(livingentity.func_226278_cu_(), this.func_226278_cu_());
            this.field_70699_by.func_75492_a(this.func_70638_az().func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 7.0, d0, this.func_70638_az().func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 7.0, 1.0);
            this.setCircleProgress(this.getCircleProgress() + 1);
            this.func_70624_b(this.func_70638_az());
            this.func_70671_ap().func_220679_a(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226280_cw_(), this.func_70638_az().func_226281_cx_());
        }
        if (this.getItemThrowTime() > 0) {
            this.setItemThrowTime(this.getItemThrowTime() - 1);
        }
        if (this.getItemThrowTime() == 10) {
            if (this.getDeltas()) {
                if (this.currencyStack.func_77973_b() == Items.field_234797_rz_) {
                    this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                    this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_151043_k, 5));
                } else if (this.currencyStack.func_77973_b() == Items.field_221693_cI) {
                    this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                    this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_234777_rA_, 2));
                } else if (this.currencyStack.func_77973_b() == Items.field_221691_cH) {
                    this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                    this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_234735_dn_, 1));
                } else if (this.currencyStack.func_77973_b() == Items.field_234708_K_) {
                    this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                    this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_151128_bU, 2));
                } else if (this.currencyStack.func_77973_b() == Items.field_234798_v_) {
                    this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                    this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_234799_w_, 1));
                } else if (this.currencyStack.func_77973_b() == Items.field_151065_br) {
                    this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                    this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_221690_bg, 2));
                } else if (this.currencyStack.func_77973_b() == Items.field_221655_bP) {
                    this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                    this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_151129_at, 1));
                } else if (this.currencyStack.func_77973_b() == Items.field_151043_k) {
                    this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                    this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), this.wastelanderDeltasItems[this.field_70146_Z.nextInt(this.wastelanderDeltasItems.length)]);
                }
            } else if (this.currencyStack.func_77973_b() == Items.field_234797_rz_) {
                this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_151043_k, 5));
            } else if (this.currencyStack.func_77973_b() == Items.field_234777_rA_) {
                this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_221693_cI, 3));
            } else if (this.currencyStack.func_77973_b() == Items.field_234735_dn_) {
                this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_221691_cH, 2));
            } else if (this.currencyStack.func_77973_b() == Items.field_151128_bU) {
                this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_234708_K_, 2));
            } else if (this.currencyStack.func_77973_b() == Items.field_234799_w_) {
                this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_234798_v_, 1));
            } else if (this.currencyStack.func_77973_b() == Items.field_221690_bg) {
                this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_151065_br, 2));
            } else if (this.currencyStack.func_77973_b() == Items.field_151129_at) {
                this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), new ItemStack((IItemProvider)Items.field_221655_bP, 2));
            } else if (this.currencyStack.func_77973_b() == Items.field_151043_k) {
                this.func_184185_a(SoundEvents.field_187756_df, 1.0f, 1.0f);
                this.throwItemsTowardPlayer(this, this.field_70170_p.func_217362_a((Entity)this, 100.0), this.wastelanderItems[this.field_70146_Z.nextInt(this.wastelanderItems.length)]);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ITEM_THROW_TIME, (Object)0);
        this.field_70180_af.func_187214_a(DELTAS, (Object)false);
        this.field_70180_af.func_187214_a(CIRCLING, (Object)false);
        this.field_70180_af.func_187214_a(CIRCLE_PROGRESS, (Object)0);
    }

    public int getCircleProgress() {
        return (Integer)this.field_70180_af.func_187225_a(CIRCLE_PROGRESS);
    }

    public void setCircleProgress(int p_189794_1_) {
        this.field_70180_af.func_187227_b(CIRCLE_PROGRESS, (Object)p_189794_1_);
    }

    public boolean getDeltas() {
        return (Boolean)this.field_70180_af.func_187225_a(DELTAS);
    }

    public void setDeltas(boolean p_191997_1_) {
        this.field_70180_af.func_187227_b(DELTAS, (Object)p_191997_1_);
    }

    public boolean getCircling() {
        return (Boolean)this.field_70180_af.func_187225_a(CIRCLING);
    }

    public void setCircling(boolean p_191997_1_) {
        this.field_70180_af.func_187227_b(CIRCLING, (Object)p_191997_1_);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74757_a("Deltas", this.getDeltas());
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setDeltas(p_70037_1_.func_74767_n("Deltas"));
    }

    public int getItemThrowTime() {
        return (Integer)this.field_70180_af.func_187225_a(ITEM_THROW_TIME);
    }

    public void setItemThrowTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ITEM_THROW_TIME, (Object)p_189794_1_);
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (this.getDeltas() && (item == Items.field_151043_k || item == Items.field_234797_rz_ || item == Items.field_221693_cI || item == Items.field_221691_cH || item == Items.field_234708_K_ || item == Items.field_234798_v_ || item == Items.field_151065_br || item == Items.field_221655_bP)) {
            this.currencyStack = itemstack;
            this.setItemThrowTime(20);
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!(this.getDeltas() || item != Items.field_151043_k && item != Items.field_234797_rz_ && item != Items.field_234777_rA_ && item != Items.field_234735_dn_ && item != Items.field_151128_bU && item != Items.field_234799_w_ && item != Items.field_221690_bg && item != Items.field_151129_at)) {
            this.currencyStack = itemstack;
            this.setItemThrowTime(20);
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.FAIL;
    }

    private void throwItemsTowardPlayer(WastelanderEntity wastelanderEntity, PlayerEntity p_234472_1_, ItemStack p_234472_2_) {
        this.throwItemsTowardPos(wastelanderEntity, p_234472_2_, p_234472_1_.func_213303_ch());
    }

    private void throwItemsTowardPos(WastelanderEntity p_234476_0_, ItemStack p_234476_1_, Vector3d p_234476_2_) {
        if (!p_234476_1_.func_190926_b()) {
            p_234476_0_.func_184609_a(Hand.OFF_HAND);
            BrainUtil.func_233865_a_((LivingEntity)p_234476_0_, (ItemStack)p_234476_1_, (Vector3d)p_234476_2_.func_72441_c(0.0, 1.0, 0.0));
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.isCreepy() ? (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_SCREAM_ORIGINAL.get() : (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_AMBIENT_ORIGINAL.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_HURT_ORIGINAL.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_DEATH_ORIGINAL.get();
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        ILivingEntityData ilivingentitydata = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        if (this.field_70170_p.func_242406_i(this.func_233580_cy_()).get() == Biomes.field_235251_aB_ || this.field_70170_p.func_242406_i(this.func_233580_cy_()).get() == Biomes.field_235250_aA_) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.setDeltas(false);
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151010_B));
            } else {
                this.setDeltas(true);
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
            }
        } else if (this.field_70146_Z.nextInt(5) == 0) {
            this.setDeltas(true);
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
        } else {
            this.setDeltas(false);
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151010_B));
        }
        this.func_180483_b(p_213386_2_);
        return ilivingentitydata;
    }

    @Override
    public boolean shouldAttackOnStare() {
        return this.getDeltas();
    }

    @Override
    public boolean shouldTeleportInDay() {
        return this.getDeltas();
    }

    @Override
    public void playStareSound() {
        if (this.field_70173_aa >= this.lastStareSound + 400) {
            this.lastStareSound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), (SoundEvent)SoundEventInit.ENTITY_ENDERMAN_STARE_ORIGINAL.get(), this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public final EntityPredicate slimePredicate;

        public AttackGoal() {
            super((CreatureEntity)WastelanderEntity.this, 1.05, true);
            this.slimePredicate = new EntityPredicate().func_221013_a(20.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !WastelanderEntity.this.getCircling();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !WastelanderEntity.this.getCircling();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return this.field_75441_b.func_213311_cf() * 3.0f * this.field_75441_b.func_213311_cf() * 3.0f + p_179512_1_.func_213311_cf();
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 30) {
                    WastelanderEntity.this.setAttacking(30);
                }
            } else {
                this.func_234039_g_();
            }
        }
    }

    public class WaterAvoidingRandomWalkingGoal
    extends RandomWalkingGoal {
        protected final float probability;

        public WaterAvoidingRandomWalkingGoal(CreatureEntity p_i47301_1_, double p_i47301_2_) {
            this(p_i47301_1_, p_i47301_2_, 0.001f);
        }

        public WaterAvoidingRandomWalkingGoal(CreatureEntity p_i47302_1_, double p_i47302_2_, float p_i47302_4_) {
            super(p_i47302_1_, p_i47302_2_);
            this.probability = p_i47302_4_;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !WastelanderEntity.this.getCircling();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !WastelanderEntity.this.getCircling();
        }

        @Nullable
        protected Vector3d func_190864_f() {
            if (this.field_75457_a.func_203005_aq()) {
                Vector3d vector3d = RandomPositionGenerator.func_191377_b((CreatureEntity)this.field_75457_a, (int)15, (int)7);
                return vector3d == null ? super.func_190864_f() : vector3d;
            }
            return this.field_75457_a.func_70681_au().nextFloat() >= this.probability ? RandomPositionGenerator.func_191377_b((CreatureEntity)this.field_75457_a, (int)10, (int)7) : super.func_190864_f();
        }
    }
}

