/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.models.entity;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class GrasslanderModel
extends AnimatedGeoModel {
    public boolean carrying;

    public ResourceLocation getAnimationFileLocation(Object entity) {
        return new ResourceLocation("endermenplus", "animations/enderman.animation.json");
    }

    public ResourceLocation getModelLocation(Object entity) {
        return new ResourceLocation("endermenplus", "geo/grasslander.geo.json");
    }

    public ResourceLocation getTextureLocation(Object entity) {
        return new ResourceLocation("endermenplus", "textures/entities/grasslander.png");
    }

    public void setLivingAnimations(IAnimatable entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("jaw");
        IBone leftArm = this.getAnimationProcessor().getBone("leftArm");
        IBone rightArm = this.getAnimationProcessor().getBone("rightArm");
        IBone body = this.getAnimationProcessor().getBone("body");
        if (this.carrying && ((AbstractEndermanVariant)entity).isAttacking() <= 0) {
            leftArm.setRotationX(0.5f);
            rightArm.setRotationX(0.5f);
            leftArm.setRotationZ(-0.05f);
            rightArm.setRotationZ(0.05f);
            body.setRotationX(0.0f);
        }
        LivingEntity entityIn = (LivingEntity)entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

