/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.models.entity;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import com.alexander.endermenplus.entities.WastelanderEntity;
import com.alexander.endermenplus.interfaces.IGeoTranslateRotate;
import com.alexander.endermenplus.interfaces.IHasGeoArm;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class WastelanderModel
extends AnimatedGeoModel
implements IHasGeoArm,
IGeoTranslateRotate {
    public boolean carrying;

    public ResourceLocation getAnimationFileLocation(Object entity) {
        return new ResourceLocation("endermenplus", "animations/wastelander.animation.json");
    }

    public ResourceLocation getModelLocation(Object entity) {
        if (((WastelanderEntity)((Object)entity)).getDeltas()) {
            return new ResourceLocation("endermenplus", "geo/wastelander_deltas.geo.json");
        }
        return new ResourceLocation("endermenplus", "geo/wastelander.geo.json");
    }

    public ResourceLocation getTextureLocation(Object entity) {
        if (((WastelanderEntity)((Object)entity)).getDeltas()) {
            return new ResourceLocation("endermenplus", "textures/entities/wastelander_deltas.png");
        }
        return new ResourceLocation("endermenplus", "textures/entities/wastelander.png");
    }

    public void setLivingAnimations(IAnimatable entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("jaw");
        IBone leftArm = this.getAnimationProcessor().getBone("leftArm");
        IBone rightArm = this.getAnimationProcessor().getBone("rightArm");
        IBone body = this.getAnimationProcessor().getBone("body");
        if (this.carrying && ((AbstractEndermanVariant)entity).isAttacking() <= 0) {
            leftArm.setRotationX(0.5f);
            rightArm.setRotationX(0.5f);
            leftArm.setRotationZ(-0.05f);
            rightArm.setRotationZ(0.05f);
            body.setRotationX(0.0f);
        }
        LivingEntity entityIn = (LivingEntity)entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }

    @Override
    public IBone getArm(HandSide p_191216_1_) {
        return this.getAnimationProcessor().getBone("rightArm");
    }

    @Override
    public void translateToHand(HandSide p_225599_1_, MatrixStack p_225599_2_) {
        this.translateAndRotate(this.getAnimationProcessor().getBone("body"), p_225599_2_, false);
        this.translateAndRotate(this.getArm(p_225599_1_), p_225599_2_, false);
    }

    @Override
    public void translateAndRotate(IBone bone, MatrixStack p_228307_1_, boolean reverserotations) {
        p_228307_1_.func_227861_a_((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
        if (bone.getRotationZ() != 0.0f) {
            p_228307_1_.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(reverserotations ? -bone.getRotationZ() : bone.getRotationZ()));
        }
        if (bone.getRotationY() != 0.0f) {
            p_228307_1_.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(reverserotations ? -bone.getRotationY() : bone.getRotationY()));
        }
        if (bone.getRotationX() != 0.0f) {
            p_228307_1_.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(reverserotations ? -bone.getRotationX() : bone.getRotationX()));
        }
    }

    @Override
    public boolean shouldRenderHeldItem(LivingEntity entity) {
        return true;
    }
}

