/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.renderers;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import com.alexander.endermenplus.models.entity.SeasiderModel;
import com.alexander.endermenplus.renderers.layers.EndermanHeldBlockLayer;
import com.alexander.endermenplus.renderers.layers.GeoEyeLayer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class SeasiderRenderer
extends GeoEntityRenderer<AbstractEndermanVariant> {
    public SeasiderRenderer(EntityRendererManager renderManager) {
        super(renderManager, (AnimatedGeoModel)new SeasiderModel());
        this.addLayer(new EndermanHeldBlockLayer((IGeoRenderer<AbstractEndermanVariant>)this, 0.4));
        this.addLayer(new GeoEyeLayer(this, new ResourceLocation("endermenplus:textures/entities/seasider_eyes.png")));
    }

    public RenderType getRenderType(AbstractEndermanVariant animatable, float partialTicks, MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228644_e_((ResourceLocation)this.getTextureLocation((LivingEntity)animatable));
    }

    public void render(AbstractEndermanVariant entity, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        BlockState blockstate = entity.getCarriedBlock();
        SeasiderModel endermanmodel = (SeasiderModel)this.getGeoModelProvider();
        endermanmodel.carrying = blockstate != null;
        super.render((LivingEntity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    public void renderRecursively(GeoBone bone, MatrixStack stack, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("rightHand")) {
            stack.func_227860_a_();
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-75.0f));
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(0.0f));
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(0.0f));
            stack.func_227861_a_(0.4, 0.4, 0.2);
            stack.func_227862_a_(1.0f, 1.0f, 1.0f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(this.mainHand, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, packedLightIn, packedOverlayIn, stack, this.rtb);
            stack.func_227865_b_();
            bufferIn = this.rtb.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.whTexture));
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }
}

