/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.endermenplus.renderers;

import com.alexander.endermenplus.entities.AbstractEndermanVariant;
import com.alexander.endermenplus.models.entity.TundramanModel;
import com.alexander.endermenplus.renderers.layers.EndermanHeldBlockLayer;
import com.alexander.endermenplus.renderers.layers.GeoEyeLayer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class TundramanRenderer
extends GeoEntityRenderer<AbstractEndermanVariant> {
    public TundramanRenderer(EntityRendererManager renderManager) {
        super(renderManager, (AnimatedGeoModel)new TundramanModel());
        this.addLayer(new EndermanHeldBlockLayer((IGeoRenderer<AbstractEndermanVariant>)this, 0.4));
        this.addLayer(new GeoEyeLayer(this, new ResourceLocation("endermenplus:textures/entities/tundraman_eyes.png")));
    }

    public RenderType getRenderType(AbstractEndermanVariant animatable, float partialTicks, MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228644_e_((ResourceLocation)this.getTextureLocation((LivingEntity)animatable));
    }

    public void render(AbstractEndermanVariant entity, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        BlockState blockstate = entity.getCarriedBlock();
        TundramanModel endermanmodel = (TundramanModel)this.getGeoModelProvider();
        endermanmodel.carrying = blockstate != null;
        super.render((LivingEntity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }
}

