/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone.config;

import alpvax.mc.goprone.config.ConfigException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigExceptionList<T>
extends ConfigException<List<T>, List<? extends String>> {
    private final String[] configComment;
    private final Supplier<List<String>> defaults;
    private final Function<T, String> toStringMapper;
    private final Function<String, T> toValueMapper;
    private final Predicate<Object> validator;
    private final ConfigException.ConfigPredicate<T> predicate;

    private ConfigExceptionList(Supplier<List<String>> defaults, Function<T, String> toStringMapper, Function<String, T> toValueMapper, Predicate<Object> configValidator, ConfigException.ConfigPredicate<T> predicate, String ... comment) {
        this.defaults = defaults;
        this.toStringMapper = toStringMapper;
        this.toValueMapper = toValueMapper;
        this.validator = configValidator;
        this.predicate = predicate;
        this.configComment = comment;
    }

    @Override
    protected ForgeConfigSpec.ConfigValue<List<? extends String>> makeConfigValue(ForgeConfigSpec.Builder builder) {
        return builder.comment(this.configComment).defineList("exceptions", this.defaults::get, this.validator);
    }

    @Override
    protected List<T> map(List<? extends String> configVal) {
        return configVal.stream().map(this.toValueMapper).collect(Collectors.toList());
    }

    @Override
    protected boolean test(List<T> value, PlayerEntity player) {
        return value.stream().anyMatch(v -> this.predicate.test(v, player));
    }

    public static class Builder<T> {
        private final Function<T, String> toStringMapper;
        private final Function<String, T> toValueMapper;
        private Predicate<Object> validator;
        private String[] comment;
        private List<Supplier<String>> defaults = new ArrayList<Supplier<String>>();

        public Builder(Function<T, String> toStringMapper, Function<String, T> toValueMapper) {
            this.toStringMapper = toStringMapper;
            this.toValueMapper = toValueMapper;
            this.validator = s -> s instanceof String && toValueMapper.apply((String)s) != null;
        }

        public Builder<T> setValidator(Predicate<Object> configValueValidator) {
            this.validator = configValueValidator;
            return this;
        }

        public Builder<T> setComment(String ... configComment) {
            this.comment = configComment;
            return this;
        }

        public Builder<T> withDefaults(Supplier<String> ... defaults) {
            for (Supplier<String> sup : defaults) {
                this.defaults.add(sup);
            }
            return this;
        }

        public Builder<T> withDefaults(String ... defaults) {
            for (String s : defaults) {
                this.defaults.add(() -> s);
            }
            return this;
        }

        public ConfigExceptionList<T> build(ConfigException.ConfigPredicate<T> predicate) {
            return new ConfigExceptionList(() -> this.defaults.stream().map(Supplier::get).collect(Collectors.toList()), (Function)this.toStringMapper, (Function)this.toValueMapper, (Predicate)this.validator, (ConfigException.ConfigPredicate)predicate, this.comment);
        }
    }
}

