/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.events;

import com.song.castle_in_the_sky.config.ConfigCommon;
import com.song.castle_in_the_sky.effects.EffectRegister;
import com.song.castle_in_the_sky.features.StructureFeatureRegister;
import com.song.castle_in_the_sky.items.ItemsRegister;
import com.song.castle_in_the_sky.network.Channel;
import com.song.castle_in_the_sky.network.ClientHandlerClass;
import com.song.castle_in_the_sky.network.ServerToClientInfoPacket;
import com.song.castle_in_the_sky.utils.MyTradingRecipe;
import com.song.castle_in_the_sky.utils.RandomTradeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerEvents {
    @SubscribeEvent
    public void onBiomeLoading(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.OCEAN) {
            event.getGeneration().func_242516_a(StructureFeatureRegister.CONFIGURED_CASTLE_IN_THE_SKY);
        }
    }

    @SubscribeEvent
    public void onVillageTradeRegister(VillagerTradesEvent event) {
        for (MyTradingRecipe recipe : ConfigCommon.MY_TRADING_RECIPES) {
            if (recipe.getItem1() == null && recipe.getItem2() == null || !Objects.requireNonNull(event.getType().getRegistryName()).toString().equals(recipe.getStringProfession())) continue;
            int level = (Integer)recipe.level.get();
            List tmp = (List)event.getTrades().get(level);
            ArrayList<VillagerTrades.ITrade> mutableTrades = new ArrayList<VillagerTrades.ITrade>(tmp);
            mutableTrades.add(new RandomTradeBuilder(64, 25, 0.05f).setPrice(recipe.getItem1(), (Integer)recipe.price1Min.get(), (Integer)recipe.price1Max.get()).setPrice2(recipe.getItem2(), (Integer)recipe.price2Min.get(), (Integer)recipe.price2Max.get()).setForSale(recipe.getOutput(), (Integer)recipe.outputMin.get(), (Integer)recipe.outputMax.get()).build());
            event.getTrades().put(level, mutableTrades);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void modifyStructureSpawnList(StructureSpawnListGatherEvent event) {
    }

    @SubscribeEvent
    public void onBlockBreak(PlayerEvent.BreakSpeed event) {
        PlayerEntity playerEntity = event.getPlayer();
        if (playerEntity.func_70644_a((Effect)EffectRegister.SACRED_CASTLE_EFFECT.get()) && !playerEntity.func_184812_l_()) {
            event.setCanceled(true);
            if (playerEntity.field_70170_p.func_201670_d()) {
                ClientHandlerClass.showSacredCastleInfoBreak();
            }
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_70644_a((Effect)EffectRegister.SACRED_CASTLE_EFFECT.get()) && !((PlayerEntity)entity).func_184812_l_()) {
            event.setCanceled(true);
            if (entity instanceof ServerPlayerEntity) {
                Channel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new ServerToClientInfoPacket((ITextComponent)new TranslationTextComponent(String.format("info.%s.sacred_castle_effect.place", "castle_in_the_sky")).func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD)));
            }
        }
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        Entity killer;
        DamageSource damageSource = event.getSource();
        if (damageSource instanceof EntityDamageSource && (killer = damageSource.func_76346_g()) instanceof LivingEntity && ((LivingEntity)killer).func_70644_a((Effect)EffectRegister.SACRED_CASTLE_EFFECT.get())) {
            LivingEntity dropper = event.getEntityLiving();
            if (dropper.func_70681_au().nextDouble() < (Double)ConfigCommon.YELLOW_KEY_DROP_RATE.get()) {
                event.getDrops().add(new ItemEntity(dropper.field_70170_p, dropper.func_213303_ch().field_72450_a, dropper.func_213303_ch().field_72448_b, dropper.func_213303_ch().field_72449_c, new ItemStack((IItemProvider)ItemsRegister.YELLOW_KEY.get())));
            }
            if (dropper.func_70681_au().nextDouble() < (Double)ConfigCommon.BLUE_KEY_DROP_RATE.get()) {
                event.getDrops().add(new ItemEntity(dropper.field_70170_p, dropper.func_213303_ch().field_72450_a, dropper.func_213303_ch().field_72448_b, dropper.func_213303_ch().field_72449_c, new ItemStack((IItemProvider)ItemsRegister.BLUE_KEY.get())));
            }
            if (dropper.func_70681_au().nextDouble() < (Double)ConfigCommon.RED_KEY_DROP_RATE.get()) {
                event.getDrops().add(new ItemEntity(dropper.field_70170_p, dropper.func_213303_ch().field_72450_a, dropper.func_213303_ch().field_72448_b, dropper.func_213303_ch().field_72449_c, new ItemStack((IItemProvider)ItemsRegister.RED_KEY.get())));
            }
        }
    }
}

