/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.items;

import com.song.castle_in_the_sky.CastleInTheSky;
import com.song.castle_in_the_sky.config.ConfigCommon;
import com.song.castle_in_the_sky.effects.EffectRegister;
import com.song.castle_in_the_sky.features.StructureRegister;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class LevitationStone
extends Item {
    public LevitationStone() {
        super(new Item.Properties().func_200916_a(CastleInTheSky.ITEM_GROUP).func_200917_a(1));
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (isSelected && this.isActive(itemStack)) {
            CompoundNBT nbt;
            if (!world.func_201670_d() && world instanceof ServerWorld && world.func_82737_E() % 40L == 0L && entity instanceof LivingEntity) {
                if (((LivingEntity)entity).func_70644_a((Effect)EffectRegister.SACRED_CASTLE_EFFECT.get())) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_188424_y, 100));
                } else {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_204839_B, 100));
                }
            }
            if (world.func_201670_d() && world.func_234923_W_().func_240901_a_().toString().equals("minecraft:overworld") && (nbt = itemStack.func_179543_a("targetLaputa")) != null) {
                int posX = nbt.func_74762_e("posX");
                int posY = nbt.func_74762_e("posY");
                int posZ = nbt.func_74762_e("posZ");
                BlockPos entityPos = entity.func_233580_cy_();
                double dist = Math.sqrt(entityPos.func_218140_a((double)posX, (double)posY, (double)posZ, false));
                double dx = (double)(posX - entityPos.func_177958_n()) / dist;
                double dy = (double)(posY - entityPos.func_177956_o() - 2) / dist;
                double dz = (double)(posZ - entityPos.func_177952_p()) / dist;
                for (int i = 2; i < 50; ++i) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, (double)i * dx + (double)entityPos.func_177958_n(), (double)i * dy + (double)entityPos.func_177956_o(), (double)i * dz + (double)entityPos.func_177952_p(), 0.0, 0.0, 0.0);
                }
            }
        }
        super.func_77663_a(itemStack, world, entity, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        if (!world.func_201670_d()) {
            BlockPos blockpos;
            CompoundNBT nbt;
            ItemStack itemStack = playerEntity.func_184586_b(hand);
            nbt.func_74757_a("active", !(nbt = itemStack.func_190925_c("castle_in_the_sky")).func_74767_n("active"));
            if (this.isActive(itemStack) && (blockpos = ((ServerWorld)world).func_241117_a_((Structure)StructureRegister.CASTLE_IN_THE_SKY.get(), playerEntity.func_233580_cy_(), 100, false)) != null) {
                CompoundNBT nbt1 = itemStack.func_190925_c("targetLaputa");
                nbt1.func_74768_a("posX", blockpos.func_177958_n() + 72);
                nbt1.func_74768_a("posY", (Integer)ConfigCommon.CASTLE_HEIGHT.get() + 72);
                nbt1.func_74768_a("posZ", blockpos.func_177952_p() + 72);
            }
        }
        return super.func_77659_a(world, playerEntity, hand);
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World p_77624_2_, List<ITextComponent> iTextComponents, ITooltipFlag iTooltipFlag) {
        super.func_77624_a(itemStack, p_77624_2_, iTextComponents, iTooltipFlag);
        iTextComponents.add((ITextComponent)new TranslationTextComponent("tooltip.castle_in_the_sky.levitation_stone.line1").func_240699_a_(TextFormatting.GRAY));
        iTextComponents.add((ITextComponent)new TranslationTextComponent("tooltip.castle_in_the_sky.levitation_stone.line2").func_240699_a_(TextFormatting.GRAY));
        iTextComponents.add((ITextComponent)new TranslationTextComponent("tooltip.castle_in_the_sky.levitation_stone.line3").func_240699_a_(TextFormatting.GRAY));
        String s = this.isActive(itemStack) ? "ON" : "OFF";
        iTextComponents.add((ITextComponent)new StringTextComponent(s).func_240699_a_(TextFormatting.GOLD));
    }

    public boolean isActive(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_190925_c("castle_in_the_sky");
        return nbt.func_74767_n("active");
    }
}

