/*
 * Decompiled with CFR 0.152.
 */
package team.rusty.bumpkinbatch.worldgen.structure;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import team.rusty.bumpkinbatch.worldgen.structure.HalloweenStructureElement;
import team.rusty.util.worldgen.structure.SimpleStructure;

public class HalloweenStructure
extends SimpleStructure {
    @Override
    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return FeatureStart::new;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, WorldgenRandom worldgenRandom, ChunkPos pos, Biome biome, ChunkPos chunkPos2, NoneFeatureConfiguration noneFeatureConfiguration, LevelHeightAccessor levelHeightAccessor) {
        Random random = new Random(seed + (long)pos.hashCode());
        BlockPos centerOfChunk = new BlockPos(pos.m_45604_() + random.nextInt(15), 0, pos.m_45605_() + random.nextInt(15));
        int landHeight = chunkGenerator.m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor);
        NoiseColumn columnOfBlocks = chunkGenerator.m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), levelHeightAccessor);
        BlockState topBlock = columnOfBlocks.m_47156_(centerOfChunk.m_6630_(landHeight));
        return topBlock.m_60819_().m_76178_();
    }

    public static class FeatureStart
    extends StructureStart<NoneFeatureConfiguration> {
        private final long worldSeed;

        public FeatureStart(StructureFeature<NoneFeatureConfiguration> structureIn, ChunkPos pos, int referenceIn, long seedIn) {
            super(structureIn, pos, referenceIn, seedIn);
            this.worldSeed = seedIn;
        }

        public void generatePieces(RegistryAccess registryAccess, ChunkGenerator chunkGenerator, StructureManager manager, ChunkPos pos, Biome biome, NoneFeatureConfiguration noneConfig, LevelHeightAccessor heightAccessor) {
            Random random = new Random(this.worldSeed + (long)pos.hashCode());
            BlockPos centerPos = new BlockPos(pos.m_45604_() + random.nextInt(15), 0, pos.m_45605_() + random.nextInt(15));
            JigsawPlacement.m_161612_((RegistryAccess)registryAccess, (JigsawConfiguration)new JigsawConfiguration(() -> (StructureTemplatePool)registryAccess.m_175515_(Registry.f_122884_).m_7745_(new ResourceLocation(this.m_73610_().m_67098_() + "/pool")), 10), (m, element, p, gld, r, bb) -> new PoolElementStructurePiece(m, (StructurePoolElement)HalloweenStructureElement.create(element), p, gld, r, bb), (ChunkGenerator)chunkGenerator, (StructureManager)manager, (BlockPos)centerPos, (StructurePieceAccessor)this, (Random)this.f_73564_, (boolean)false, (boolean)true, (LevelHeightAccessor)heightAccessor);
            BlockPos structureCenter = ((StructurePiece)this.f_73562_.get(0)).m_73547_().m_162394_();
            int xOffset = centerPos.m_123341_() - structureCenter.m_123341_();
            int zOffset = centerPos.m_123343_() - structureCenter.m_123343_();
            for (StructurePiece structurePiece : this.f_73562_) {
                structurePiece.m_6324_(xOffset, 0, zOffset);
            }
        }
    }
}

